/*
 * Decompiled with CFR 0.152.
 */
package agjava.mp3;

import agjava.mp3.BinParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class MP3Header {
    private final int HEADER_SIZE = 4;
    private final int[][] bitrateTable;
    private final int[][] sampleTable;
    private final String[] versionLabels;
    private final String[] layerLabels;
    private final String[] channelLabels;
    private final String[] emphasisLabels;
    private final int MPEG_V_25 = 0;
    private final int MPEG_V_2 = 2;
    private final int MPEG_V_1 = 3;
    private final int MPEG_L_3 = 1;
    private final int MPEG_L_2 = 2;
    private final int MPEG_L_1 = 3;
    private File mp3;
    private int version;
    private int layer;
    private int bitRate;
    private int sampleRate;
    private int channelMode;
    private boolean copyrighted;
    private boolean crced;
    private boolean original;
    private int emphasis;
    private long location;

    public MP3Header(File file) throws FileNotFoundException, IOException {
        this(file, 0);
    }

    public MP3Header(File file, int n) throws FileNotFoundException, IOException {
        RandomAccessFile randomAccessFile;
        block4: {
            this.HEADER_SIZE = 4;
            this.bitrateTable = new int[][]{{-1, -1, -1, -1, -1}, {32, 32, 32, 32, 8}, {64, 48, 40, 48, 16}, {96, 56, 48, 56, 24}, {128, 64, 56, 64, 32}, {160, 80, 64, 80, 40}, {192, 96, 80, 96, 48}, {224, 112, 96, 112, 56}, {256, 128, 112, 128, 64}, {288, 160, 128, 144, 80}, {320, 192, 160, 160, 96}, {352, 224, 192, 176, 112}, {384, 256, 224, 192, 128}, {416, 320, 256, 224, 144}, {448, 384, 320, 256, 160}, {-1, -1, -1, -1, -1}};
            this.sampleTable = new int[][]{{44100, 22050, 11025}, {48000, 24000, 12000}, {32000, 16000, 8000}, {-1, -1, -1}};
            this.versionLabels = new String[]{"MPEG Version 2.5", null, "MPEG Version 2.0", "MPEG Version 1.0"};
            this.layerLabels = new String[]{null, "Layer III", "Layer II", "Layer I"};
            this.channelLabels = new String[]{"Stereo", "Joint Stereo (STEREO)", "Dual Channel (STEREO)", "Single Channel (MONO)"};
            this.emphasisLabels = new String[]{"none", "50/15 ms", null, "CCIT J.17"};
            this.MPEG_V_25 = 0;
            this.MPEG_V_2 = 2;
            this.MPEG_V_1 = 3;
            this.MPEG_L_3 = 1;
            this.MPEG_L_2 = 2;
            this.MPEG_L_1 = 3;
            this.mp3 = null;
            this.mp3 = file;
            this.version = -1;
            this.layer = -1;
            this.bitRate = -1;
            this.sampleRate = -1;
            this.channelMode = -1;
            this.copyrighted = false;
            this.crced = false;
            this.original = false;
            this.emphasis = -1;
            this.location = -1L;
            randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(file, "r");
                this.location = this.findFrame(randomAccessFile, n);
                if (n == -1) break block4;
                this.readHeader(randomAccessFile, this.location);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                throw throwable;
            }
        }
        Object var5_4 = null;
        if (randomAccessFile != null) {
            randomAccessFile.close();
        }
    }

    private void findBitRate(int n) {
        int n2 = -1;
        if (this.version == 3) {
            if (this.layer == 3) {
                n2 = 0;
            } else if (this.layer == 2) {
                n2 = 1;
            } else if (this.layer == 1) {
                n2 = 2;
            }
        } else if (this.version == 2 || this.version == 0) {
            if (this.layer == 3) {
                n2 = 3;
            } else if (this.layer == 2 || this.layer == 1) {
                n2 = 4;
            }
        }
        if (n2 != -1 && n >= 0 && n <= 15) {
            this.bitRate = this.bitrateTable[n][n2];
        }
    }

    private long findFrame(RandomAccessFile randomAccessFile, int n) throws FileNotFoundException, IOException {
        long l = -1L;
        try {
            randomAccessFile.seek(n);
            while (l == -1L) {
                byte by = randomAccessFile.readByte();
                if (!BinParser.matchPattern(by, "11111111") || !BinParser.matchPattern(by = randomAccessFile.readByte(), "111xxxxx")) continue;
                l = randomAccessFile.getFilePointer() - 2L;
            }
        }
        catch (Exception exception) {
            return 0L;
        }
        return l;
    }

    private void findSampleRate(int n) {
        int n2 = -1;
        switch (this.version) {
            case 3: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 0: {
                n2 = 2;
            }
        }
        if (n2 != -1 && n >= 0 && n <= 3) {
            this.sampleRate = this.sampleTable[n][n2];
        }
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public String getChannelMode() {
        String string = null;
        if (this.channelMode >= 0 && this.channelMode < this.channelLabels.length) {
            string = this.channelLabels[this.channelMode];
        }
        return string;
    }

    public String getEmphasis() {
        String string = null;
        if (this.emphasis >= 0 && this.emphasis < this.emphasisLabels.length) {
            string = this.emphasisLabels[this.emphasis];
        }
        return string;
    }

    public String getLayer() {
        String string = null;
        if (this.layer >= 0 && this.layer < this.layerLabels.length) {
            string = this.layerLabels[this.layer];
        }
        return string;
    }

    public long getLocation() {
        return this.location;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public String getVersion() {
        String string = null;
        if (this.version >= 0 && this.version < this.versionLabels.length) {
            string = this.versionLabels[this.version];
        }
        return string;
    }

    public boolean isCopyrighted() {
        return this.copyrighted;
    }

    public boolean isMP3() {
        return this.layer == 1;
    }

    public boolean isOriginal() {
        return this.original;
    }

    public boolean isProtected() {
        return this.crced;
    }

    private void readHeader(RandomAccessFile randomAccessFile, long l) throws FileNotFoundException, IOException {
        byte[] byArray = new byte[4];
        randomAccessFile.seek(l);
        if (randomAccessFile.read(byArray) != 4) {
            throw new IOException("Error reading MPEG frame header.");
        }
        this.version = BinParser.convertToDecimal(byArray[1], 3, 4);
        this.layer = BinParser.convertToDecimal(byArray[1], 1, 2);
        this.findBitRate(BinParser.convertToDecimal(byArray[2], 4, 7));
        this.findSampleRate(BinParser.convertToDecimal(byArray[2], 2, 3));
        this.channelMode = BinParser.convertToDecimal(byArray[3], 6, 7);
        this.copyrighted = BinParser.bitSet(byArray[3], 3);
        this.crced = BinParser.bitSet(byArray[1], 0) ^ true;
        this.original = BinParser.bitSet(byArray[3], 2);
        this.emphasis = BinParser.convertToDecimal(byArray[3], 0, 1);
    }

    public String toString() {
        return String.valueOf(this.getVersion()) + " " + this.getLayer() + "\nBitRate:\t\t\t" + this.getBitRate() + "kbps\nSampleRate:\t\t\t" + this.getSampleRate() + "Hz\nChannelMode:\t\t\t" + this.getChannelMode() + "\nCopyrighted:\t\t\t" + this.isCopyrighted() + "\nOriginal:\t\t\t" + this.isOriginal() + "\nCRC:\t\t\t\t" + this.isProtected() + "\nEmphasis:\t\t\t" + this.getEmphasis() + "\nOffset:\t\t\t\t" + this.getLocation();
    }
}

