/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import napkin.DrawnScribbleGenerator;
import napkin.DrawnShapeHolder;
import napkin.NapkinBoxBorder;
import napkin.NapkinConstants;

public class DrawnScribbleHolder
extends DrawnShapeHolder
implements NapkinConstants {
    private Rectangle size;
    private Insets insets;
    private int orientation;
    private int shown;
    private boolean backwards;
    private static final float LINE_WIDTH = 3.0f;

    public DrawnScribbleHolder() {
        super(new DrawnScribbleGenerator(3.0f), 3.0f);
    }

    boolean shapeUpToDate(Component c, Rectangle sz, int orient, int shn, boolean bwrds) {
        Insets in;
        Insets insets = in = c instanceof JComponent ? ((JComponent)c).getInsets() : NapkinBoxBorder.DEFAULT_INSETS;
        if (this.size != null && bwrds == this.backwards && this.insets.equals(in) && this.orientation == orient && this.shown == shn && this.size.width == sz.width && this.size.height == sz.height) {
            return false;
        }
        this.size = (Rectangle)sz.clone();
        this.insets = (Insets)in.clone();
        this.orientation = orient;
        this.shown = shn;
        this.backwards = bwrds;
        int cornerX = in.top / 2 + 1;
        int cornerY = in.left / 2 + 1;
        double innerWidth = sz.getWidth() - (double)(in.left + in.right);
        double innerHeight = sz.getHeight() - (double)(in.top + in.bottom);
        DrawnScribbleGenerator gen = (DrawnScribbleGenerator)this.gen;
        gen.setShown(this.shown);
        gen.setOrientation(this.orientation);
        gen.setRange(this.orientation == 0 ? innerHeight : innerWidth);
        gen.setMax(this.orientation == 0 ? innerWidth : innerHeight);
        AffineTransform matrix = new AffineTransform();
        matrix.translate(cornerY, cornerX);
        if (this.backwards) {
            matrix.translate(innerWidth, innerHeight);
            matrix.scale(-1.0, -1.0);
        }
        this.shape = gen.generate(matrix);
        return true;
    }
}

