/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import napkin.DrawnLineHolder;
import napkin.NapkinTheme;
import napkin.NapkinUtil;

public class NapkinTreeUI
extends BasicTreeUI {
    private Map linesFor = new HashMap();

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new DefaultNapkinTreeCellRender();
    }

    public static ComponentUI createUI(JComponent c) {
        return NapkinUtil.uiFor(c, new NapkinTreeUI());
    }

    protected Color getHashColor() {
        NapkinTheme theme = NapkinUtil.currentTheme(this.tree);
        return theme.getPenColor();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        NapkinUtil.installUI(c);
    }

    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
        this.paintLine(g, left, y, right, y);
    }

    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        super.paintHorizontalPartOfLeg(g, this.tree.getBounds(), insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
    }

    private void paintLine(Graphics g, int x1, int y1, int x2, int y2) {
        int w = x2 - x1;
        int h = y2 - y1;
        Rectangle rect = new Rectangle(x1, y1, w, h);
        DrawnLineHolder holder = (DrawnLineHolder)this.linesFor.get(rect);
        if (holder == null) {
            holder = new DrawnLineHolder((double)Math.max(w, h), w == 0);
            this.linesFor.put(rect, holder);
        }
        DrawnLineHolder line = holder;
        line.shapeUpToDate(rect, null);
        line.draw(g);
    }

    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
        this.paintLine(g, x, top, x, bottom);
    }

    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        super.paintVerticalPartOfLeg(g, this.tree.getBounds(), insets, path);
    }

    public void uninstallUI(JComponent c) {
        NapkinUtil.uninstallUI(c);
        super.uninstallUI(c);
    }

    public void update(Graphics g, JComponent c) {
        g = NapkinUtil.defaultGraphics(g, c);
        NapkinTheme theme = NapkinUtil.currentTheme(c);
        this.setHashColor(NapkinUtil.ifReplace(this.getHashColor(), theme.getPenColor()));
        NapkinUtil.background(g, c);
        super.update(g, c);
        NapkinUtil.finishGraphics(g, c);
    }

    public class DefaultNapkinTreeCellRender
    extends DefaultTreeCellRenderer {
        public void paint(Graphics g) {
            g = NapkinUtil.defaultGraphics(g, NapkinTreeUI.this.tree);
            NapkinTheme theme = NapkinUtil.currentTheme(this);
            this.setBackgroundSelectionColor(NapkinUtil.ifReplace(this.getBackgroundSelectionColor(), theme.getHighlightColor()));
            NapkinUtil.background(g, NapkinTreeUI.this.tree);
            super.paint(g);
            NapkinUtil.finishGraphics(g, NapkinTreeUI.this.tree);
        }
    }
}

