/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p;

import ants.p2p.Ant;
import ants.p2p.DirectNeighbour;
import ants.p2p.Message;
import ants.p2p.NeighbourAnt;
import ants.p2p.NetModificationAlert;
import ants.p2p.RoutingTableElement;
import ants.p2p.messages.security.MessageSigner;
import ants.p2p.utils.net.BandwidthFilterIn;
import com.jcraft.jzlib.ZInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.Socket;
import org.apache.log4j.Logger;

public class TCPDirectServerThread
extends Thread {
    Socket local;
    Ant ant;
    private static Logger _logger = Logger.getLogger((String)TCPDirectServerThread.class.getName());

    public TCPDirectServerThread(Socket local, Ant ant) {
        this.ant = ant;
        this.local = local;
    }

    public void run() {
        try {
            BandwidthFilterIn bfIn = new BandwidthFilterIn(this.local.getInputStream());
            ZInputStream zIn = new ZInputStream((InputStream)bfIn);
            ObjectInputStream objIn = new ObjectInputStream((InputStream)zIn);
            String remoteAddress = (String)objIn.readObject();
            if (remoteAddress.startsWith("/")) {
                remoteAddress = remoteAddress.substring(1);
            }
            Object obj = objIn.readObject();
            NeighbourAnt.totalCompressedSizeIn += (double)zIn.getTotalIn();
            NeighbourAnt.totalUncompressionSizeIn += (double)zIn.getTotalOut();
            long size = zIn.getTotalIn();
            objIn.close();
            if (obj instanceof NetModificationAlert && ((NetModificationAlert)obj).getVersion().equals(Ant.getProtocolVersion())) {
                if (!remoteAddress.equals("")) {
                    DirectNeighbour requirer = new DirectNeighbour(remoteAddress, this.ant);
                    _logger.info((Object)("Procesing net modification from DC " + requirer));
                    this.ant.processNetModificationAlert((NetModificationAlert)obj, requirer);
                }
            } else if (obj instanceof Message && ((Message)obj).getVersion().equals(Ant.getProtocolVersion())) {
                Message m = (Message)obj;
                NeighbourAnt.updateInStats(m, size);
                if (this.ant.getIdent().equals(m.getSource()) || !MessageSigner.getInstance().verifySignature(m, m.getSource())) {
                    return;
                }
                _logger.debug((Object)(remoteAddress + ": DCMessage received ID " + m + " From: " + m.getSource() + " To: " + m.getDest()));
                if (!remoteAddress.equals("") && this.ant.routingTable.get(m.getSource()) != null) {
                    RoutingTableElement rte = (RoutingTableElement)this.ant.routingTable.get(m.getSource());
                    rte.addTracedRoute(remoteAddress);
                } else if (!remoteAddress.equals("")) {
                    RoutingTableElement rte = new RoutingTableElement();
                    rte.addTracedRoute(remoteAddress);
                    this.ant.routingTable.put(m.getSource(), rte);
                }
                if (!remoteAddress.equals("")) {
                    this.ant.activateNewRouterProcess(m, remoteAddress);
                } else {
                    this.ant.activateNewRouterProcess(m, this.ant.getIdent());
                }
            }
        }
        catch (Exception e) {
            _logger.debug((Object)"TCP Direct Server thread exception: ", (Throwable)e);
        }
    }
}

