/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.filesharing;

import ants.p2p.filesharing.ByteWrapper;
import ants.p2p.filesharing.WarriorAnt;
import ants.p2p.messages.FilePushMessage;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.log4j.Logger;

public class PartialFile {
    static Logger _logger = Logger.getLogger((String)PartialFile.class.getName());
    File f = null;
    File downloadInfos = null;
    String name;
    String source;
    long fileSize;
    byte[] hash;
    ByteWrapper[] fileParts;
    FilePushMessage fpm;
    public long lastId = 0L;
    int groupFactor;
    long lastActivityTime = System.currentTimeMillis();
    PropertyChangeSupport pcs;

    public static int computeGroupFactor(int blockSize) {
        if (blockSize >= (int)Math.pow(2.0, 20.0)) {
            return 1;
        }
        if (blockSize < (int)Math.pow(2.0, 20.0)) {
            return 1;
        }
        return 1;
    }

    public long getLastId() {
        return this.lastId;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    public PartialFile(String name, String source, byte[] hash, boolean resume, long offset, FilePushMessage fpm, PropertyChangeSupport pcs) throws Exception {
        name = WarriorAnt.chunksHome + name;
        this.downloadInfos = new File(name + ".tmp");
        if (this.downloadInfos.exists() && !resume) {
            ObjectInputStream fis = new ObjectInputStream(new FileInputStream(this.downloadInfos));
            String oldName = (String)fis.readObject();
            fis.close();
            this.f = new File(oldName);
            if (this.f.exists()) {
                this.f.delete();
            }
            this.f = new File(name);
            if (this.f.exists()) {
                this.f.delete();
            }
            ObjectOutputStream fos = new ObjectOutputStream(new FileOutputStream(this.downloadInfos, false));
            fos.writeObject(name);
            fos.close();
        } else {
            if (!this.downloadInfos.exists() && resume) {
                throw new Exception("Resuming error");
            }
            if (this.downloadInfos.exists() && resume) {
                ObjectInputStream fis = new ObjectInputStream(new FileInputStream(this.downloadInfos));
                String oldName = (String)fis.readObject();
                fis.close();
                this.f = new File(oldName);
                if (this.f.length() != offset) {
                    throw new Exception("Resuming error");
                }
            } else {
                this.f = new File(name);
                if (this.f.exists()) {
                    this.f.delete();
                }
                ObjectOutputStream fos = new ObjectOutputStream(new FileOutputStream(this.downloadInfos, false));
                fos.writeObject(name);
                fos.close();
            }
        }
        this.pcs = pcs;
        this.fpm = fpm;
        this.name = name;
        this.source = source;
        this.hash = hash;
        this.fileSize = fpm.getFileSize();
        this.groupFactor = PartialFile.computeGroupFactor(fpm.getBlockSize());
        this.fileParts = new ByteWrapper[this.groupFactor];
    }

    public FilePushMessage getFilePushMessage() {
        return this.fpm;
    }

    public synchronized void appendBytes(byte[] b, long id) {
        try {
            if (id < this.lastId * (long)this.groupFactor) {
                return;
            }
            if (this.fileParts[(int)(id - this.lastId * (long)this.groupFactor)] != null) {
                return;
            }
            _logger.debug((Object)("Writing to memory part " + id));
            this.pcs.firePropertyChange("bytesGroupAppendedToFilePart", null, this);
            this.fileParts[(int)(id - this.lastId * (long)this.groupFactor)] = new ByteWrapper(b);
            if (this.receivedBlock()) {
                this.finalizeFile();
                this.pcs.firePropertyChange("byteBlockFinalizedInFilePart", null, this);
                ++this.lastId;
            }
            this.lastActivityTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
        }
    }

    public boolean receivedBlock() {
        for (int x = 0; x < this.fileParts.length; ++x) {
            if (this.fileParts[x] != null) continue;
            return false;
        }
        return true;
    }

    public synchronized void finalizeFile() {
        try {
            int x;
            _logger.debug((Object)"Finalizing");
            FileOutputStream fos = new FileOutputStream(this.f, true);
            for (x = 0; x < this.fileParts.length && this.fileParts[x] != null; ++x) {
                fos.write(this.fileParts[x].content);
            }
            for (x = 0; x < this.fileParts.length; ++x) {
                this.fileParts[x] = null;
            }
            fos.close();
            this.downloadInfos.delete();
            System.gc();
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof PartialFile) {
            return PartialFile.compareHash(((PartialFile)o).hash, this.hash) && ((PartialFile)o).getFilePushMessage().equals(this.getFilePushMessage());
        }
        return o == this;
    }

    public long getReceivedSize() {
        return this.f.length();
    }

    public static boolean compareHash(byte[] h1, byte[] h2) {
        if (h1.length != h2.length) {
            return false;
        }
        for (int x = 0; x < h1.length; ++x) {
            if (h1[x] == h2[x]) continue;
            return false;
        }
        return true;
    }
}

