/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.gui;

import ants.p2p.filesharing.WarriorAnt;
import ants.p2p.gui.PrivateChatFrame_jTextField1_keyAdapter;
import ants.p2p.messages.PrivateChatMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import ji.JI;
import org.apache.log4j.Logger;

public class PrivateChatFrame
extends JFrame
implements PropertyChangeListener {
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JEditorPane jEditorPane1 = new JEditorPane();
    JTextField jTextField1 = new JTextField();
    String peerId = null;
    WarriorAnt wa = null;
    boolean initiator;
    public static Hashtable activeChats = new Hashtable();
    static Logger _logger = Logger.getLogger((String)PrivateChatFrame.class.getName());

    public PrivateChatFrame(String peerId, WarriorAnt wa, boolean initiator) {
        super("Chatting with: " + peerId.substring(0, 10));
        this.setBounds(100, 100, 300, 300);
        this.peerId = peerId;
        this.wa = wa;
        this.initiator = initiator;
        this.wa.getPropertyChangeSupport().addPropertyChangeListener(this);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static PrivateChatFrame getChatWith(String peerId, WarriorAnt wa, boolean initiator) {
        PrivateChatFrame pcf = (PrivateChatFrame)activeChats.get(peerId);
        if (pcf != null) {
            return pcf;
        }
        pcf = new PrivateChatFrame(peerId, wa, initiator);
        activeChats.put(peerId, pcf);
        return pcf;
    }

    public static void removeChatWith(String peerId, WarriorAnt wa) {
        PrivateChatFrame pcf = (PrivateChatFrame)activeChats.get(peerId);
        if (pcf != null) {
            activeChats.remove(peerId);
            wa.getPropertyChangeSupport().removePropertyChangeListener(pcf);
            pcf.hide();
        }
    }

    public static void removeAllChats(WarriorAnt wa) {
        Enumeration keys = activeChats.keys();
        while (keys.hasMoreElements()) {
            PrivateChatFrame.removeChatWith((String)keys.nextElement(), wa);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        PrivateChatMessage pcm;
        if (e.getPropertyName().equals("privateChatMessageSending")) {
            PrivateChatMessage pcm2 = (PrivateChatMessage)e.getNewValue();
            if (pcm2.getDest().equals(this.peerId)) {
                this.setTitle("Chatting with: " + this.peerId.substring(0, 10) + "   [Sending message...]");
            }
        } else if (e.getPropertyName().equals("privateChatMessageFailed")) {
            PrivateChatMessage pcm3 = (PrivateChatMessage)e.getNewValue();
            if (pcm3.getDest().equals(this.peerId)) {
                this.setTitle("Chatting with: " + this.peerId.substring(0, 10));
                JOptionPane.showMessageDialog(this, JI.i("Error in sending message!"), JI.i("Chat error"), 0);
            }
        } else if (e.getPropertyName().equals("privateChatMessageDelivered") && (pcm = (PrivateChatMessage)e.getNewValue()).getDest().equals(this.peerId)) {
            this.setTitle("Chatting with: " + this.peerId.substring(0, 10));
            this.jEditorPane1.setText(this.jEditorPane1.getText() + "You:\t" + pcm.getContent() + "\n");
        }
    }

    public void insertExternalMessage(String message) {
        this.jEditorPane1.setText(this.jEditorPane1.getText() + this.peerId.substring(0, 10) + ":\t" + message + "\n");
    }

    void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setAutoscrolls(true);
        this.jEditorPane1.setText("");
        this.jTextField1.setText("");
        this.jTextField1.addKeyListener(new PrivateChatFrame_jTextField1_keyAdapter(this));
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jTextField1, "South");
        this.jScrollPane1.getViewport().add((Component)this.jEditorPane1, null);
    }

    void jTextField1_keyReleased(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            try {
                String message = this.jTextField1.getText();
                this.jTextField1.setText("");
                this.wa.sendPrivateChatMessage(this.peerId, message, this.initiator);
            }
            catch (Exception ex) {
                _logger.error((Object)"", (Throwable)ex);
                JOptionPane.showMessageDialog(this, JI.i("Error in sending message: ") + ex.getMessage(), JI.i("Chat error"), 0);
            }
        }
    }
}

