/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.http;

import ants.p2p.filesharing.WarriorAnt;
import ants.p2p.http.HttpRequestSender;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class HttpProxy
extends Thread {
    int port = 8080;
    String nodeID;
    WarriorAnt wa;
    ServerSocket ss;
    static Logger _logger = Logger.getLogger((String)HttpProxy.class.getName());
    public ArrayList activeHandlers = new ArrayList();

    public HttpProxy(int port, String nodeID, WarriorAnt wa) throws Exception {
        this.nodeID = nodeID;
        this.port = port;
        this.wa = wa;
        this.ss = new ServerSocket(port);
        this.ss.setReuseAddress(true);
        this.start();
    }

    public HttpProxy(String nodeID, WarriorAnt wa) throws Exception {
        this.nodeID = nodeID;
        this.wa = wa;
        this.ss = new ServerSocket(this.port);
        this.ss.setReuseAddress(true);
        this.start();
    }

    public int getPort() {
        return this.port;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public WarriorAnt getWarriorAnt() {
        return this.wa;
    }

    public void run() {
        try {
            while (true) {
                Socket listener = this.ss.accept();
                HttpRequestSender handler = new HttpRequestSender(listener, this);
                this.activeHandlers.add(handler);
                this.wa.propertyChangeSupport.addPropertyChangeListener(handler);
                handler.start();
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Proxy stopped (port: " + this.getPort() + ")"), (Throwable)e);
            try {
                this.wa.resetCurrentProxy();
            }
            catch (Exception ex) {
                _logger.error((Object)("Error in closing port: " + this.getPort()), (Throwable)e);
            }
            return;
        }
    }

    public boolean terminate() throws Exception {
        this.ss.close();
        this.stop();
        this.join(5000L);
        return !this.isAlive() && this.ss.isClosed();
    }

    public void removeHandler(HttpRequestSender handler) {
        this.activeHandlers.remove(handler);
        this.wa.propertyChangeSupport.removePropertyChangeListener(handler);
    }
}

