/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.irc;

import ants.p2p.Ant;
import ants.p2p.filesharing.WarriorAnt;
import ants.p2p.gui.ChatAntPanel;
import ants.p2p.gui.ConnectionAntPanel;
import ants.p2p.gui.DoubleBuffer;
import ants.p2p.gui.FrameAnt;
import ants.p2p.gui.LabelIcon;
import ants.p2p.gui.StyledDiscussion;
import ants.p2p.irc.RefreshAndConnectThread;
import ants.p2p.irc.UsersComparator;
import ants.p2p.security.sockets.SSLProvider;
import java.awt.Component;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;
import ji.JI;
import org.apache.log4j.Logger;
import org.jibble.pircbot.PircBot;
import org.jibble.pircbot.User;

public class IrcBot
extends PircBot {
    ConnectionAntPanel caller;
    ChatAntPanel chatPanel;
    Hashtable channels = new Hashtable();
    Hashtable topics = new Hashtable();
    public static final String connectionStateChannel = JI.i("Connection state");
    boolean banWhoisResult = false;
    String banFromChannel = null;
    int channelCounter = 0;
    boolean inibitAutoreconnect = false;
    static Logger _logger = Logger.getLogger((String)IrcBot.class.getName());

    public IrcBot(String nick, ConnectionAntPanel caller) {
        this.setName(nick);
        this.caller = caller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        IrcBot ircBot = this;
        synchronized (ircBot) {
            this.inibitAutoreconnect = true;
            this.disconnect();
        }
    }

    public void removeDiscussion(String key) {
        if (key != null && key.length() > 0 && key.charAt(0) == '#') {
            key = key.toLowerCase();
        }
        this.channels.remove(key);
        this.topics.remove(key);
    }

    void createDiscussion(String key) {
        if (key != null && key.length() > 0 && key.charAt(0) == '#') {
            key = key.toLowerCase();
        }
        StyledDiscussion discussion = new StyledDiscussion();
        try {
            discussion.insertString(0, "", null);
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
        }
        this.channels.put(key, discussion);
        this.chatPanel.addDiscussion(key);
    }

    void createTopic(String key, String topic) {
        if (key != null && key.length() > 0 && key.charAt(0) == '#') {
            key = key.toLowerCase();
            this.topics.put(key, topic);
        }
    }

    public StyledDocument getDiscussion(String key) {
        if (key != null && key.length() > 0 && key.charAt(0) == '#') {
            key = key.toLowerCase();
        }
        return (StyledDocument)this.channels.get(key);
    }

    public Object[] getDiscussions() {
        Enumeration keys = this.channels.keys();
        ArrayList<Object> discussions = new ArrayList<Object>();
        while (keys.hasMoreElements()) {
            discussions.add(keys.nextElement());
        }
        Collections.sort(discussions);
        if (discussions.remove(connectionStateChannel)) {
            discussions.add(0, connectionStateChannel);
        }
        return discussions.toArray();
    }

    public String getTopic(String key) {
        String topic;
        if (key != null && key.length() > 0 && key.charAt(0) == '#') {
            key = key.toLowerCase();
        }
        if ((topic = (String)this.topics.get(key)) != null) {
            return (String)this.topics.get(key);
        }
        return "";
    }

    public void setMessage(String key, String message, String sender) {
        if (key != null && key.length() > 0 && key.charAt(0) == '#') {
            key = key.toLowerCase();
        }
        if (this.channels.get(key) == null) {
            this.createDiscussion(key);
        }
        StyledDocument discussion = (StyledDocument)this.channels.get(key);
        try {
            Style styles = null;
            styles = sender.equals(this.getNick()) ? discussion.getStyle("blue") : discussion.getStyle("red");
            discussion.insertString(discussion.getLength(), "\n" + sender + " ", styles);
            String insertionDate = new Date().toLocaleString();
            String insertionTime = insertionDate.substring(insertionDate.indexOf(32) + 1, insertionDate.length());
            discussion.insertString(discussion.getLength(), insertionTime + ": ", discussion.getStyle("gray"));
            StringTokenizer lxr = new StringTokenizer(message);
            while (lxr.hasMoreTokens()) {
                discussion.insertString(discussion.getLength(), " " + lxr.nextToken(), discussion.getStyle("regular"));
            }
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
        }
        this.channels.put(key, discussion);
    }

    public void setControlMessage(String key, String message) {
        if (key != null && key.length() > 0 && key.charAt(0) == '#') {
            key = key.toLowerCase();
        }
        if (this.channels.get(key) == null) {
            this.createDiscussion(key);
        }
        StyledDocument discussion = (StyledDocument)this.channels.get(key);
        try {
            Style styles = null;
            styles = discussion.getStyle("green");
            discussion.insertString(discussion.getLength(), "\n", styles);
            String insertionDate = new Date().toLocaleString();
            String insertionTime = insertionDate.substring(insertionDate.indexOf(32) + 1, insertionDate.length());
            discussion.insertString(discussion.getLength(), insertionTime + ": ", discussion.getStyle("gray"));
            StringTokenizer lxr = new StringTokenizer(message);
            while (lxr.hasMoreTokens()) {
                discussion.insertString(discussion.getLength(), " " + lxr.nextToken(), discussion.getStyle("green"));
            }
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
        }
        this.channels.put(key, discussion);
    }

    public void setStyledControlMessage(String key, String message, String style) {
        if (key != null && key.length() > 0 && key.charAt(0) == '#') {
            key = key.toLowerCase();
        }
        if (this.channels.get(key) == null) {
            this.createDiscussion(key);
        }
        StyledDocument discussion = (StyledDocument)this.channels.get(key);
        try {
            Style styles = null;
            styles = discussion.getStyle(style);
            discussion.insertString(discussion.getLength(), "\n", styles);
            StringTokenizer lxr = new StringTokenizer(message);
            while (lxr.hasMoreTokens()) {
                discussion.insertString(discussion.getLength(), lxr.nextToken() + " ", discussion.getStyle(style));
            }
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
        }
        this.channels.put(key, discussion);
    }

    public ConnectionAntPanel getCaller() {
        return this.caller;
    }

    public ChatAntPanel getChatPanel() {
        return this.chatPanel;
    }

    public void refreshUsers(String channel) {
        if (channel != null && channel.length() > 0 && channel.charAt(0) == '#') {
            channel = channel.toLowerCase();
        }
        User[] users = this.getUsers(channel);
        Arrays.sort(users, new UsersComparator());
        this.chatPanel.setUserList(users);
        this.chatPanel.updateUsersNumberInCurrentChannel(this.getUsers(channel).length);
        this.chatPanel.setChannel(channel);
    }

    public void onQuit(String sourceNick, String sourceLogin, String sourceHostname, String reason) {
        String channel = this.chatPanel.getCurrentSelectedDiscussion();
        this.setControlMessage(channel, sourceNick + " " + JI.i("quit irc at") + " " + new Date().toLocaleString());
        this.setControlMessage(connectionStateChannel, sourceNick + " " + JI.i("quit irc at") + " " + new Date().toLocaleString());
        this.chatPanel.refreshCurrentChannel();
    }

    public void onNickChange(String oldNick, String login, String hostname, String newNick) {
        Object[] discussionsArray = this.getDiscussions();
        for (int x = 0; x < discussionsArray.length; ++x) {
            String discussionName = (String)discussionsArray[x];
            if (discussionName.charAt(0) != '#') continue;
            User[] usersTemp = this.getUsers(discussionName);
            Object[] users = new Object[usersTemp.length];
            for (int y = 0; y < usersTemp.length; ++y) {
                users[y] = usersTemp[y].getNick();
            }
            if (Arrays.binarySearch(users, oldNick) < 0 && Arrays.binarySearch(users, newNick) < 0) continue;
            this.setControlMessage(discussionName, oldNick + " " + JI.i("is now known as") + " " + newNick);
        }
        this.setControlMessage(connectionStateChannel, oldNick + " " + JI.i("is now known as") + " " + newNick);
        this.chatPanel.refreshCurrentChannel();
        if (oldNick.equals(ConnectionAntPanel.nick)) {
            this.caller.setNick(newNick);
        }
    }

    public void onOp(String channel, String sourceNick, String sourceLogin, String sourceHostname, String recipient) {
        channel = channel.toLowerCase();
        this.setControlMessage(channel, recipient + " " + JI.i("received @ from") + " " + sourceNick + " " + JI.i("on") + " " + channel + " " + JI.i("at") + " " + new Date().toLocaleString());
        if (channel != null && channel.equals(this.chatPanel.getCurrentSelectedDiscussion())) {
            this.chatPanel.updateUsersNumberInCurrentChannel(this.getUsers(channel).length);
            Object[] selected = this.chatPanel.getUserList().getSelectedValues();
            this.refreshUsers(channel);
            this.chatPanel.getUserList().setSelectionMode(2);
            int[] selectedIndices = new int[selected.length];
            for (int x = 0; x < selected.length; ++x) {
                for (int y = 0; y < this.chatPanel.getUserList().getModel().getSize(); ++y) {
                    if (!((User)this.chatPanel.getUserList().getModel().getElementAt(y)).getNick().equals(((User)selected[x]).getNick())) continue;
                    selectedIndices[x] = y;
                }
                this.chatPanel.getUserList().setSelectedIndices(selectedIndices);
            }
        }
        this.chatPanel.checkOp();
    }

    public void onDeop(String channel, String sourceNick, String sourceLogin, String sourceHostname, String recipient) {
        channel = channel.toLowerCase();
        this.setControlMessage(channel, JI.i("You get de@ on") + " " + channel + " " + JI.i("at") + " " + new Date().toLocaleString());
        if (channel != null && channel.equals(this.chatPanel.getCurrentSelectedDiscussion())) {
            this.chatPanel.updateUsersNumberInCurrentChannel(this.getUsers(channel).length);
            Object[] selected = this.chatPanel.getUserList().getSelectedValues();
            this.refreshUsers(channel);
            this.chatPanel.getUserList().setSelectionMode(2);
            int[] selectedIndices = new int[selected.length];
            for (int x = 0; x < selected.length; ++x) {
                for (int y = 0; y < this.chatPanel.getUserList().getModel().getSize(); ++y) {
                    if (!((User)this.chatPanel.getUserList().getModel().getElementAt(y)).getNick().equals(((User)selected[x]).getNick())) continue;
                    selectedIndices[x] = y;
                }
                this.chatPanel.getUserList().setSelectedIndices(selectedIndices);
            }
        }
        this.chatPanel.checkOp();
    }

    public void onRemoveChannelBan(String channel, String sourceNick, String sourceLogin, String sourceHostname, String hostmask) {
        String selectedChannel = this.chatPanel.getCurrentSelectedDiscussion();
        this.setControlMessage(selectedChannel, hostmask + " " + JI.i("unbanned from") + " " + channel);
        this.chatPanel.refreshCurrentChannel();
        this.chatPanel.refreshBanList();
    }

    public void onSetChannelBan(String channel, String sourceNick, String sourceLogin, String sourceHostname, String hostmask) {
        String selectedChannel = this.chatPanel.getCurrentSelectedDiscussion();
        this.setControlMessage(selectedChannel, hostmask + " " + JI.i("banned from") + " " + channel);
        this.chatPanel.refreshCurrentChannel();
        this.chatPanel.refreshBanList();
    }

    public void onKick(String channel, String kickerNick, String kickerLogin, String kickerHostname, String recipientNick, String reason) {
        channel = channel.toLowerCase();
        if (!recipientNick.equals(ConnectionAntPanel.nick)) {
            this.setControlMessage(channel, recipientNick + " " + JI.i("has been kicked by") + " " + kickerNick + " " + JI.i("on") + " " + channel + " " + JI.i("at") + " " + new Date().toLocaleString() + " " + JI.i("reason:") + " " + reason);
            if (channel != null && channel.equals(this.chatPanel.getCurrentSelectedDiscussion())) {
                this.chatPanel.updateUsersNumberInCurrentChannel(this.getUsers(channel).length);
                Object[] selected = this.chatPanel.getUserList().getSelectedValues();
                this.refreshUsers(channel);
                this.chatPanel.getUserList().setSelectionMode(2);
                int[] selectedIndices = new int[selected.length];
                for (int x = 0; x < selected.length; ++x) {
                    for (int y = 0; y < this.chatPanel.getUserList().getModel().getSize(); ++y) {
                        if (!((User)this.chatPanel.getUserList().getModel().getElementAt(y)).getNick().equals(((User)selected[x]).getNick())) continue;
                        selectedIndices[x] = y;
                    }
                    this.chatPanel.getUserList().setSelectedIndices(selectedIndices);
                }
            }
        }
    }

    public void onVoice(String channel, String sourceNick, String sourceLogin, String sourceHostname, String recipient) {
        channel = channel.toLowerCase();
        this.setControlMessage(channel, JI.i("You get voice on") + " " + channel + " " + JI.i("at") + " " + new Date().toLocaleString());
        if (channel != null && channel.equals(this.chatPanel.getCurrentSelectedDiscussion())) {
            this.chatPanel.updateUsersNumberInCurrentChannel(this.getUsers(channel).length);
            Object[] selected = this.chatPanel.getUserList().getSelectedValues();
            this.refreshUsers(channel);
            this.chatPanel.getUserList().setSelectionMode(2);
            int[] selectedIndices = new int[selected.length];
            for (int x = 0; x < selected.length; ++x) {
                for (int y = 0; y < this.chatPanel.getUserList().getModel().getSize(); ++y) {
                    if (!((User)this.chatPanel.getUserList().getModel().getElementAt(y)).getNick().equals(((User)selected[x]).getNick())) continue;
                    selectedIndices[x] = y;
                }
                this.chatPanel.getUserList().setSelectedIndices(selectedIndices);
            }
        }
    }

    public void onDeVoice(String channel, String sourceNick, String sourceLogin, String sourceHostname, String recipient) {
        channel = channel.toLowerCase();
        this.setControlMessage(channel, JI.i("You get deVoice on") + " " + channel + " " + JI.i("at") + " " + new Date().toLocaleString());
        if (channel != null && channel.equals(this.chatPanel.getCurrentSelectedDiscussion())) {
            this.chatPanel.updateUsersNumberInCurrentChannel(this.getUsers(channel).length);
            Object[] selected = this.chatPanel.getUserList().getSelectedValues();
            this.refreshUsers(channel);
            this.chatPanel.getUserList().setSelectionMode(2);
            int[] selectedIndices = new int[selected.length];
            for (int x = 0; x < selected.length; ++x) {
                for (int y = 0; y < this.chatPanel.getUserList().getModel().getSize(); ++y) {
                    if (!((User)this.chatPanel.getUserList().getModel().getElementAt(y)).getNick().equals(((User)selected[x]).getNick())) continue;
                    selectedIndices[x] = y;
                }
                this.chatPanel.getUserList().setSelectedIndices(selectedIndices);
            }
        }
    }

    public void onJoin(String channel, String sender, String login, String hostname) {
        channel = channel.toLowerCase();
        if (sender.equals(ConnectionAntPanel.nick)) {
            this.setControlMessage(channel, JI.i("You joined") + " " + channel + " " + JI.i("at") + " " + new Date().toLocaleString());
            this.chatPanel.setChannel(channel);
        } else {
            this.setControlMessage(channel, sender + " " + JI.i("joined") + " " + channel + " " + JI.i("at") + " " + new Date().toLocaleString());
            this.chatPanel.refreshCurrentChannel();
        }
    }

    public void onPart(String channel, String sender, String login, String hostname) {
        block5: {
            block4: {
                channel = channel.toLowerCase();
                if (sender.equals(ConnectionAntPanel.nick)) break block4;
                this.setControlMessage(channel, sender + " " + JI.i("parted") + " " + channel + " " + JI.i("at") + " " + new Date().toLocaleString());
                if (channel == null || !channel.equals(this.chatPanel.getCurrentSelectedDiscussion())) break block5;
                this.chatPanel.updateUsersNumberInCurrentChannel(this.getUsers(channel).length);
                Object[] selected = this.chatPanel.getUserList().getSelectedValues();
                this.refreshUsers(channel);
                this.chatPanel.getUserList().setSelectionMode(2);
                int[] selectedIndices = new int[selected.length];
                for (int x = 0; x < selected.length; ++x) {
                    for (int y = 0; y < this.chatPanel.getUserList().getModel().getSize(); ++y) {
                        if (!((User)this.chatPanel.getUserList().getModel().getElementAt(y)).getNick().equals(((User)selected[x]).getNick())) continue;
                        selectedIndices[x] = y;
                    }
                    this.chatPanel.getUserList().setSelectedIndices(selectedIndices);
                }
                break block5;
            }
            if (!channel.equals(ConnectionAntPanel.ircChannel)) break block5;
            try {
                Thread.sleep(2000L);
                this.joinChannel(ConnectionAntPanel.ircChannel);
                Thread.sleep(3000L);
                this.refreshUsers(ConnectionAntPanel.ircChannel);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public String getActiveChannel() {
        return this.chatPanel.getCurrentSelectedDiscussion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnect() {
        try {
            IrcBot ircBot = this;
            synchronized (ircBot) {
                this.chatPanel = new ChatAntPanel(this);
                this.chatPanel.updateUsersNumberInCurrentChannel(0);
                this.caller.getContainer().getTabbedPane().add((Component)this.chatPanel, new LabelIcon("IRC: " + this.getServer(), DoubleBuffer.getInstance().getButton(2), this.chatPanel));
            }
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
        }
        _logger.info((Object)"IRC Connected");
        this.caller.getContainer().getSettingsAntPanel().setIrcConnected(true);
        this.caller.getContainer().getSettingsAntPanel().setIrcEnabled(true);
    }

    public void onTopic(String channel, String topic, String setBy, long date, boolean changed) {
        this.createTopic(channel, topic);
        this.setControlMessage(channel, setBy + " " + JI.i("set topic:") + " \"" + topic + "\" " + JI.i("at") + " " + new Date(date).toLocaleString());
        String selectedChannel = this.chatPanel.getCurrentSelectedDiscussion();
        if (channel.equals(selectedChannel)) {
            this.chatPanel.setTopic(this.getTopic(channel));
        }
    }

    public void onServerResponse(int code, String response) {
        super.onServerResponse(code, response);
        response = response.substring(this.getNick().length() + 1);
        if (code == 311 || code == 312 || code == 319 || code == 318) {
            String selectedChannel = this.chatPanel.getCurrentSelectedDiscussion();
            if (this.banWhoisResult && code == 311) {
                response = response.substring(response.indexOf(32) + 1);
                response = response.substring(response.indexOf(32) + 1);
                response = response.substring(0, response.indexOf(42));
                this.ban(this.banFromChannel, "*!*@" + response);
                this.banFromChannel = null;
                this.banWhoisResult = false;
            } else {
                this.setControlMessage(selectedChannel, response);
            }
        } else if (code > 0 && code < 3 || code == 375 || code == 372 || code >= 251 && code <= 266) {
            try {
                this.setControlMessage(connectionStateChannel, response);
            }
            catch (Exception e) {}
        } else if (code == 367) {
            String selectedChannel = this.chatPanel.getCurrentSelectedDiscussion();
            if (response.startsWith(selectedChannel + " ")) {
                response = response.substring((selectedChannel + " ").length());
                response = response.substring(0, response.indexOf(32));
                this.chatPanel.addBanlistElement(response);
            }
        } else if (code == 322) {
            try {
                ++this.channelCounter;
                String name = response.substring(0, response.indexOf(32));
                response = response.substring(response.indexOf(32));
                String users = response.substring(0, response.indexOf(58));
                response = response.substring(response.indexOf(58));
                this.setStyledControlMessage(connectionStateChannel, name, "blue");
                this.setStyledControlMessage(connectionStateChannel, JI.i("Active users") + ": " + users, "red");
                this.setStyledControlMessage(connectionStateChannel, response, "green");
            }
            catch (Exception exception) {}
        } else if (code == 321) {
            this.channelCounter = 0;
            this.setStyledControlMessage(connectionStateChannel, JI.i("Channels List"), "gray");
        } else if (code == 323) {
            this.setStyledControlMessage(connectionStateChannel, JI.i("end of list") + ": " + this.channelCounter + JI.i(" channels listed"), "gray");
        }
    }

    public void scheduleBan(String nick, String channel) {
        this.banWhoisResult = true;
        this.banFromChannel = channel;
        this.sendRawLine("WHOIS " + nick);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoReconnect() {
        boolean stopTryingConnection = false;
        while (!stopTryingConnection) {
            if (!ConnectionAntPanel.autoReconnectIRC || this.inibitAutoreconnect || this.isConnected() || this.caller.warriorAnt == null || this.caller.warriorAnt.isDisconnected()) break;
            try {
                Thread.currentThread();
                Thread.sleep(30000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            IrcBot e = this;
            synchronized (e) {
                block16: {
                    try {
                        _logger.info((Object)"Trying to reconnect to IRC server");
                        if (!ConnectionAntPanel.ircServer.equals("")) {
                            String password = this.caller.getContainer().getSettingsAntPanel().getIrcPassword();
                            if (!password.equals("")) {
                                this.caller.ircBot.connect(ConnectionAntPanel.ircServer, 6667, password);
                            } else {
                                this.caller.ircBot.connect(ConnectionAntPanel.ircServer);
                            }
                            Thread.sleep(2000L);
                            this.caller.ircBot.joinChannel(ConnectionAntPanel.ircChannel);
                            Thread.sleep(2000L);
                            this.caller.ircBot.refreshUsers(ConnectionAntPanel.ircChannel);
                        }
                        this.caller.getContainer().getSettingsAntPanel().setIrcConnected(true);
                        stopTryingConnection = true;
                    }
                    catch (Exception ex) {
                        _logger.error((Object)("Failed to reconnect to IRC: " + ex.getMessage()));
                        if (this.isConnected()) break block16;
                        this.caller.getContainer().getSettingsAntPanel().setIrcConnected(false);
                        this.caller.getContainer().getSettingsAntPanel().setIrcEnabled(false);
                    }
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(30000L);
            }
            catch (Exception e2) {}
        }
        if (this.inibitAutoreconnect) {
            try {
                this.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisconnect() {
        IrcBot ircBot = this;
        synchronized (ircBot) {
            _logger.info((Object)"IRC Disconnected");
            this.caller.getContainer().getSettingsAntPanel().setIrcConnected(false);
            this.caller.getContainer().getSettingsAntPanel().setIrcEnabled(false);
        }
        this.autoReconnect();
    }

    public void onAction(String sender, String login, String hostname, String target, String action) {
        this.setControlMessage(target, "* " + sender + " " + action);
    }

    public void onANtsCommandMessage(String sender, String login, String hostname, String message) {
        if (message == null || !ConnectionAntPanel.searchPeersOnIRC) {
            return;
        }
        if (message.equalsIgnoreCase("ANtsCommandCode:0000")) {
            _logger.info((Object)("Received connect message from: " + sender + " " + login + " " + hostname));
            try {
                this.sendCTCPCommand(sender, "ANtsResponseCode:0000 " + this.caller.getLocalStringAddress() + ":" + this.caller.warriorAnt.getServerPort());
            }
            catch (Exception e) {
                _logger.error((Object)"", (Throwable)e);
            }
        } else if (message.equalsIgnoreCase("ANtsCommandCode:0003")) {
            _logger.info((Object)("Received connect message from: " + sender + " " + login + " " + hostname));
            try {
                this.sendCTCPCommand(sender, "ANtsResponseCode:0003 " + this.caller.getLocalStringAddress() + ":" + this.caller.warriorAnt.getServerPort());
            }
            catch (Exception e) {
                _logger.error((Object)"", (Throwable)e);
            }
        } else if (message.indexOf("ANtsCommandCode:0004 ") >= 0) {
            _logger.info((Object)("Received firewall probe message from: " + sender + " " + login + " " + hostname));
            int beginIndex = message.indexOf("ANtsCommandCode:0004 ");
            message = message.substring(beginIndex += "ANtsCommandCode:0004 ".length(), message.length());
            int endIndex = message.indexOf(":");
            try {
                if (!InetAddress.getByName(message.substring(0, endIndex)).getHostAddress().equals(InetAddress.getLocalHost().getHostAddress()) || !message.substring(endIndex + 1, message.length()).equals(this.caller.warriorAnt.getServerPort() + "")) {
                    _logger.info((Object)("Probing firewall of: " + message.substring(0, endIndex) + ":" + Integer.parseInt(message.substring(endIndex + 1, message.length()))));
                    Socket probeSocket = SSLProvider.getSSLSecuredSocket(message.substring(0, endIndex), Integer.parseInt(message.substring(endIndex + 1, message.length())), Ant.proxied);
                    ObjectOutputStream probeOutputStream = new ObjectOutputStream(probeSocket.getOutputStream());
                    probeOutputStream.write(0);
                    probeOutputStream.close();
                    _logger.info((Object)"Probe firewall: Firewall DOWN");
                    this.sendCTCPCommand(sender, "ANtsResponseCode:0004 FWDW");
                }
            }
            catch (Exception e) {
                _logger.info((Object)("Probe firewall: Firewall UP[" + e.getMessage() + "]"));
                this.sendCTCPCommand(sender, "ANtsResponseCode:0004 FWUP");
            }
        } else if (message.indexOf("ANtsResponseCode:0004 ") >= 0) {
            int beginIndex = message.indexOf("ANtsResponseCode:0004 ");
            if ((message = message.substring(beginIndex += "ANtsResponseCode:0004 ".length(), message.length())).equals("FWUP")) {
                _logger.info((Object)"Probe firewall: Your Firewall is UP!");
                this.caller.setFirewallState(true);
            } else if (message.equals("FWDW")) {
                _logger.info((Object)"Probe firewall: Your Firewall is DOWN!");
                this.caller.setFirewallState(false);
            }
        } else if (message.indexOf("ANtsCommandCode:0001 ") >= 0) {
            _logger.info((Object)("Received request connection message from: " + sender + " " + login + " " + hostname));
            int beginIndex = message.indexOf("ANtsCommandCode:0001 ");
            message = message.substring(beginIndex += "ANtsCommandCode:0001 ".length(), message.length());
            int endIndex = message.indexOf(":");
            try {
                _logger.info((Object)"Trying connection...");
                if (!InetAddress.getByName(message.substring(0, endIndex)).getHostAddress().equals(InetAddress.getLocalHost().getHostAddress()) || !message.substring(endIndex + 1, message.length()).equals(this.caller.warriorAnt.getServerPort() + "")) {
                    this.caller.warriorAnt.addP2PNeighbour(message.substring(0, endIndex), Integer.parseInt(message.substring(endIndex + 1, message.length())), true, FrameAnt.getInstance(null).getGuiAnt().getConnectionAntPanel().getLocalInetAddress());
                }
            }
            catch (Exception e) {
                _logger.error((Object)"", (Throwable)e);
            }
        } else if (message.indexOf("ANtsCommandCode:0002 ") >= 0) {
            _logger.info((Object)("Received op request message from: " + sender + " " + login + " " + hostname));
            int beginIndex = message.indexOf("ANtsCommandCode:0002 ");
            message = message.substring(beginIndex += "ANtsCommandCode:0002 ".length(), message.length());
            int endIndex = message.indexOf(" ");
            String passwd = message.substring(0, endIndex);
            String channel = message.substring(endIndex + 1, message.length());
            if (!WarriorAnt.password.equals("") && WarriorAnt.password.equals(passwd)) {
                this.op(channel, sender);
            }
        } else if (message.indexOf("ANtsResponseCode:0000 ") >= 0) {
            _logger.info((Object)("Received peer address message from: " + sender + " " + login + " " + hostname));
            int beginIndex = message.indexOf("ANtsResponseCode:0000 ");
            message = message.substring(beginIndex += "ANtsResponseCode:0000 ".length(), message.length());
            int endIndex = message.indexOf(":");
            try {
                _logger.info((Object)"Setting routing point...");
                if (!InetAddress.getByName(message.substring(0, endIndex)).getHostAddress().equals(InetAddress.getLocalHost().getHostAddress()) || !message.substring(endIndex + 1, message.length()).equals(this.caller.warriorAnt.getServerPort() + 1 + "")) {
                    this.caller.setRoutingPoint(InetAddress.getByName(message.substring(0, endIndex)), Integer.parseInt(message.substring(endIndex + 1, message.length())));
                }
            }
            catch (Exception e) {
                _logger.error((Object)"", (Throwable)e);
            }
        } else if (message.indexOf("ANtsResponseCode:0003 ") >= 0) {
            _logger.info((Object)("Received peer address message from: " + sender + " " + login + " " + hostname));
            int beginIndex = message.indexOf("ANtsResponseCode:0003 ");
            message = message.substring(beginIndex += "ANtsResponseCode:0003 ".length(), message.length());
            int endIndex = message.indexOf(":");
            try {
                _logger.info((Object)"Setting routing point...");
                if (!InetAddress.getByName(message.substring(0, endIndex)).getHostAddress().equals(InetAddress.getLocalHost().getHostAddress()) || !message.substring(endIndex + 1, message.length()).equals(this.caller.warriorAnt.getServerPort() + 1 + "")) {
                    this.caller.setRoutingPoint(InetAddress.getByName(message.substring(0, endIndex)), Integer.parseInt(message.substring(endIndex + 1, message.length())));
                    RefreshAndConnectThread refreshAndConnectThread = new RefreshAndConnectThread(this.caller);
                    refreshAndConnectThread.start();
                    refreshAndConnectThread.join();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"", (Throwable)e);
            }
        }
    }

    public void onPrivateMessage(String sender, String login, String hostname, String message) {
        if (message == null) {
            return;
        }
        this.chatPanel.setMessage(sender, sender, message);
    }

    public void onMessage(String channel, String sender, String login, String hostname, String message) {
        if (channel != null && sender != null && message != null) {
            channel = channel.toLowerCase();
            this.chatPanel.setMessage(channel, sender, message);
        }
    }
}

