/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.query.security;

import ants.p2p.query.security.PublicHeader;
import ants.p2p.utils.encoding.Base16;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class MessageHeader
extends PublicHeader
implements Serializable {
    SecureRandom sr = new SecureRandom();
    AsymmetricCipherKeyPair acKp;
    AsymmetricBlockCipher eng = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
    static final BigInteger pubExp = new BigInteger("11", 16);

    public PublicHeader generatePublicHeader() {
        return new PublicHeader(this.exp, this.mod);
    }

    public MessageHeader(int size, int certainty) throws Exception {
        RSAKeyGenerationParameters param = new RSAKeyGenerationParameters(pubExp, this.sr, size, certainty);
        RSAKeyPairGenerator kpGen = new RSAKeyPairGenerator();
        kpGen.init((KeyGenerationParameters)param);
        this.acKp = kpGen.generateKeyPair();
        RSAKeyParameters rsaParam = (RSAKeyParameters)this.acKp.getPublic();
        this.exp = rsaParam.getExponent();
        this.mod = rsaParam.getModulus();
        this.eng.init(false, this.acKp.getPrivate());
    }

    public BigInteger getExp() {
        return this.exp;
    }

    public BigInteger getMod() {
        return this.mod;
    }

    public String decryptSessionKey(String encryptedSessionKey) throws Exception {
        return Base16.toHexString(this.generate(Base16.fromHexString(encryptedSessionKey)));
    }

    private byte[] generate(byte[] encryptedSessionKey) throws Exception {
        return this.eng.processBlock(encryptedSessionKey, 0, encryptedSessionKey.length);
    }
}

