/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.security.sockets;

import ants.p2p.security.sockets.NewClientHandler;
import ants.p2p.security.sockets.SecureServer;
import ants.p2p.utils.addresses.AddressServerThread;
import ants.p2p.utils.addresses.InetAddressWatchdog;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.log4j.Logger;

class AddressesRequestHandler
extends Thread {
    Socket localSocket;
    SecureServer caller;
    static Logger _logger = Logger.getLogger((String)NewClientHandler.class.getName());

    public AddressesRequestHandler(SecureServer caller, Socket localSocket) {
        this.localSocket = localSocket;
        this.caller = caller;
        this.setPriority(5);
    }

    public void run() {
        try {
            String remoteAddress = this.localSocket.getInetAddress().getHostAddress();
            if (!InetAddressWatchdog.getInstance().allowedAddress(InetAddress.getByName(remoteAddress).getHostAddress())) {
                _logger.info((Object)("Address is not allowed: " + remoteAddress));
                this.localSocket.close();
            } else {
                AddressServerThread serverThread = new AddressServerThread(this.localSocket);
                serverThread.start();
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Addresses request handler: " + this.caller.serverSocket.getLocalPort() + " "), (Throwable)e);
        }
    }
}

