/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.security.sockets;

import ants.p2p.Ant;
import ants.p2p.security.sockets.SecureClientSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.DHParameterSpec;
import org.apache.log4j.Logger;

public class SecureClientSocketThread {
    public static final String cipher = "AES";
    public static final int cipherKeySize = 16;
    public static final int DHKeyExchangeBits = 512;
    public static final int MinDHKeyExchangeBits = 512;
    static Logger _logger = Logger.getLogger((String)SecureClientSocketThread.class.getName());
    DHParameterSpec dhParamSpec;
    KeyPair clientKpair;
    KeyAgreement clientKeyAgree;
    PublicKey serverPubKey;
    PublicKey clientPubKey;
    byte[] sharedSecret;
    byte[] aesKey;
    Cipher clientCipherEnc;
    Cipher clientCipherDec;
    long timeElapsed;
    int pingSize = 32;
    boolean newVersionDetected = false;
    String newerVersion = Ant.getVersion();
    SecureClientSocket localSocket;
    InputStream socketInputStream;
    OutputStream socketOutputStream;
    private static final byte[] skip1024ModulusBytes = new byte[]{-12, -120, -3, 88, 78, 73, -37, -51, 32, -76, -99, -28, -111, 7, 54, 107, 51, 108, 56, 13, 69, 29, 15, 124, -120, -77, 28, 124, 91, 45, -114, -10, -13, -55, 35, -64, 67, -16, -91, 91, 24, -115, -114, -69, 85, -116, -72, 93, 56, -45, 52, -3, 124, 23, 87, 67, -93, 29, 24, 108, -34, 51, 33, 44, -75, 42, -1, 60, -31, -79, 41, 64, 24, 17, -115, 124, -124, -89, 10, 114, -42, -122, -60, 3, 25, -56, 7, 41, 122, -54, -107, 12, -39, -106, -97, -85, -48, 10, 80, -101, 2, 70, -45, 8, 61, 102, -92, 93, 65, -97, -100, 124, -67, -119, 75, 34, 25, 38, -70, -85, -94, 94, -61, 85, -23, 47, 120, -57};
    private BigInteger skip1024Modulus = new BigInteger(1, skip1024ModulusBytes);
    private BigInteger skip1024Base = BigInteger.valueOf(2L);

    public SecureClientSocketThread(SecureClientSocket localSocket) throws IOException, NoSuchAlgorithmException, InvalidParameterSpecException, InvalidAlgorithmParameterException, InvalidKeyException {
        this.localSocket = localSocket;
    }

    private void generateDHParameters() throws IOException, NoSuchAlgorithmException, InvalidParameterSpecException, InvalidAlgorithmParameterException, InvalidKeyException {
        if (this.skip1024Modulus.bitLength() < 512) {
            throw new InvalidAlgorithmParameterException("Security Error: key size < 512");
        }
        this.dhParamSpec = new DHParameterSpec(this.skip1024Modulus, this.skip1024Base);
        KeyPairGenerator clientKpairGen = KeyPairGenerator.getInstance("DH");
        clientKpairGen.initialize(this.dhParamSpec);
        this.clientKpair = clientKpairGen.generateKeyPair();
        this.clientKeyAgree = KeyAgreement.getInstance("DH");
        this.clientKeyAgree.init(this.clientKpair.getPrivate());
        this.clientPubKey = this.clientKpair.getPublic();
    }

    public void run() {
        try {
            _logger.info((Object)"Client is Accepting...");
            this.clientCipherEnc = Cipher.getInstance(cipher);
            this.clientCipherDec = Cipher.getInstance(cipher);
            this.socketInputStream = this.localSocket.getInputStream();
            this.socketOutputStream = this.localSocket.getOutputStream();
            ObjectOutputStream keyAgreementOutStream = new ObjectOutputStream(this.socketOutputStream);
            ObjectInputStream keyAgreementInStream = new ObjectInputStream(this.socketInputStream);
            keyAgreementOutStream.writeObject(Ant.getProtocolVersion());
            String protocolVersion = (String)keyAgreementInStream.readObject();
            if (!protocolVersion.equals(Ant.getProtocolVersion())) {
                if (!protocolVersion.startsWith("beta") && protocolVersion.compareTo(Ant.getProtocolVersion()) > 0) {
                    this.newVersionDetected = true;
                    this.newerVersion = "Protocol update: " + protocolVersion;
                }
                this.localSocket.close();
                return;
            }
            keyAgreementOutStream.writeObject(Ant.getApplicationName());
            keyAgreementOutStream.writeObject(Ant.getVersion());
            String applicationName = (String)keyAgreementInStream.readObject();
            if (applicationName.equals(Ant.getApplicationName())) {
                String version = (String)keyAgreementInStream.readObject();
                if (!version.equals(Ant.getVersion()) && version.compareTo(Ant.getVersion()) > 0) {
                    this.newVersionDetected = true;
                    this.newerVersion = version;
                }
            } else {
                keyAgreementInStream.readObject();
            }
            keyAgreementOutStream.writeInt(this.localSocket.getLocalServerPort());
            keyAgreementOutStream.writeObject(new byte[this.pingSize]);
            keyAgreementOutStream.flush();
            long startProbe = System.currentTimeMillis();
            keyAgreementInStream.readObject();
            this.timeElapsed = System.currentTimeMillis() - startProbe;
            _logger.info((Object)"Neighbourg accepted.");
        }
        catch (Exception e) {
            try {
                this.localSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            _logger.info((Object)("Failed secure connection with " + this.localSocket.getInetAddress() + ":" + this.localSocket.getPort() + " :" + e.getMessage()), (Throwable)e);
            _logger.debug((Object)"Failed secure connection ", (Throwable)e);
        }
    }

    public boolean isNewVersionDetected() {
        return this.newVersionDetected;
    }

    public String getNewerVersion() {
        return this.newerVersion;
    }

    public long getTimeElapsed() {
        return this.timeElapsed;
    }

    public Cipher getCipherEnc() {
        return this.clientCipherEnc;
    }

    public Cipher getCipherDec() {
        return this.clientCipherDec;
    }

    public SecureClientSocket getSocket() {
        return this.localSocket;
    }
}

