/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.utils.donkey;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class MD4 {
    private ByteBuffer buffer = ByteBuffer.allocate(64).order(ByteOrder.LITTLE_ENDIAN);
    private int stateA = 1732584193;
    private int stateB = -271733879;
    private int stateC = -1732584194;
    private int stateD = 271733878;
    private long count = 0L;

    public void reset() {
        this.stateA = 1732584193;
        this.stateB = -271733879;
        this.stateC = -1732584194;
        this.stateD = 271733878;
        this.count = 0L;
        this.buffer.rewind();
        for (int i = 0; i < 64; ++i) {
            this.buffer.put((byte)0);
        }
        this.buffer.rewind();
    }

    public void update(ByteBuffer input) {
        int inputLen = input.remaining();
        int index = (int)this.count & 0x3F;
        this.count += (long)inputLen;
        int partLen = 64 - index;
        int i = 0;
        if (inputLen >= partLen) {
            if (index > 0) {
                int t = input.limit();
                input.limit(input.position() + partLen);
                this.buffer.put(input);
                this.buffer.rewind();
                input.limit(t);
                this.transform(this.buffer);
                this.buffer.rewind();
                i = partLen;
                index = partLen;
            }
            while (i + 63 < inputLen) {
                this.transform(input);
                i += 64;
            }
        }
        if (i < inputLen) {
            this.buffer.put(input);
        }
    }

    public void finalDigest(ByteBuffer digest) {
        int index = (int)this.count & 0x3F;
        if (index < 56) {
            this.buffer.put((byte)-128);
            for (int i = index; i < 55; ++i) {
                this.buffer.put((byte)0);
            }
            this.buffer.putLong(this.count << 3);
            this.buffer.rewind();
            this.transform(this.buffer);
            this.buffer.rewind();
        } else {
            int i;
            this.buffer.put((byte)-128);
            for (i = index; i < 63; ++i) {
                this.buffer.put((byte)0);
            }
            this.buffer.rewind();
            this.transform(this.buffer);
            this.buffer.rewind();
            for (i = 0; i < 56; ++i) {
                this.buffer.put((byte)0);
            }
            this.buffer.putLong(this.count << 3);
            this.buffer.rewind();
            this.transform(this.buffer);
            this.buffer.rewind();
        }
        digest.putInt(this.stateA);
        digest.putInt(this.stateB);
        digest.putInt(this.stateC);
        digest.putInt(this.stateD);
        this.reset();
    }

    private void transform(ByteBuffer block) {
        int a = this.stateA;
        int b = this.stateB;
        int c = this.stateC;
        int d = this.stateD;
        long e = block.getLong();
        long f = block.getLong();
        long g = block.getLong();
        long h = block.getLong();
        long i = block.getLong();
        long j = block.getLong();
        long k = block.getLong();
        long l = block.getLong();
        a = MD4.FF(a, b, c, d, (int)e, 3);
        d = MD4.FF(d, a, b, c, (int)(e >>> 32), 7);
        c = MD4.FF(c, d, a, b, (int)f, 11);
        b = MD4.FF(b, c, d, a, (int)(f >>> 32), 19);
        a = MD4.FF(a, b, c, d, (int)g, 3);
        d = MD4.FF(d, a, b, c, (int)(g >>> 32), 7);
        c = MD4.FF(c, d, a, b, (int)h, 11);
        b = MD4.FF(b, c, d, a, (int)(h >>> 32), 19);
        a = MD4.FF(a, b, c, d, (int)i, 3);
        d = MD4.FF(d, a, b, c, (int)(i >>> 32), 7);
        c = MD4.FF(c, d, a, b, (int)j, 11);
        b = MD4.FF(b, c, d, a, (int)(j >>> 32), 19);
        a = MD4.FF(a, b, c, d, (int)k, 3);
        d = MD4.FF(d, a, b, c, (int)(k >>> 32), 7);
        c = MD4.FF(c, d, a, b, (int)l, 11);
        b = MD4.FF(b, c, d, a, (int)(l >>> 32), 19);
        a = MD4.GG(a, b, c, d, (int)e, 3);
        d = MD4.GG(d, a, b, c, (int)g, 5);
        c = MD4.GG(c, d, a, b, (int)i, 9);
        b = MD4.GG(b, c, d, a, (int)k, 13);
        a = MD4.GG(a, b, c, d, (int)(e >>> 32), 3);
        d = MD4.GG(d, a, b, c, (int)(g >>> 32), 5);
        c = MD4.GG(c, d, a, b, (int)(i >>> 32), 9);
        b = MD4.GG(b, c, d, a, (int)(k >>> 32), 13);
        a = MD4.GG(a, b, c, d, (int)f, 3);
        d = MD4.GG(d, a, b, c, (int)h, 5);
        c = MD4.GG(c, d, a, b, (int)j, 9);
        b = MD4.GG(b, c, d, a, (int)l, 13);
        a = MD4.GG(a, b, c, d, (int)(f >>> 32), 3);
        d = MD4.GG(d, a, b, c, (int)(h >>> 32), 5);
        c = MD4.GG(c, d, a, b, (int)(j >>> 32), 9);
        b = MD4.GG(b, c, d, a, (int)(l >>> 32), 13);
        a = MD4.HH(a, b, c, d, (int)e, 3);
        d = MD4.HH(d, a, b, c, (int)i, 9);
        c = MD4.HH(c, d, a, b, (int)g, 11);
        b = MD4.HH(b, c, d, a, (int)k, 15);
        a = MD4.HH(a, b, c, d, (int)f, 3);
        d = MD4.HH(d, a, b, c, (int)j, 9);
        c = MD4.HH(c, d, a, b, (int)h, 11);
        b = MD4.HH(b, c, d, a, (int)l, 15);
        a = MD4.HH(a, b, c, d, (int)(e >>> 32), 3);
        d = MD4.HH(d, a, b, c, (int)(i >>> 32), 9);
        c = MD4.HH(c, d, a, b, (int)(g >>> 32), 11);
        b = MD4.HH(b, c, d, a, (int)(k >>> 32), 15);
        a = MD4.HH(a, b, c, d, (int)(f >>> 32), 3);
        d = MD4.HH(d, a, b, c, (int)(j >>> 32), 9);
        c = MD4.HH(c, d, a, b, (int)(h >>> 32), 11);
        b = MD4.HH(b, c, d, a, (int)(l >>> 32), 15);
        this.stateA += a;
        this.stateB += b;
        this.stateC += c;
        this.stateD += d;
    }

    private static int FF(int a, int b, int c, int d, int x, int s) {
        int t = a + (b & c | ~b & d) + x;
        return t << s | t >>> 32 - s;
    }

    private static int GG(int a, int b, int c, int d, int x, int s) {
        int t = a + (b & (c | d) | c & d) + x + 1518500249;
        return t << s | t >>> 32 - s;
    }

    private static int HH(int a, int b, int c, int d, int x, int s) {
        int t = a + (b ^ c ^ d) + x + 1859775393;
        return t << s | t >>> 32 - s;
    }
}

