/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid.skin;

import javax.swing.AbstractButton;
import javax.swing.JButton;

public class SkinToggleButtonIndexModel {
    private AbstractButton button;
    boolean checkForDefaultButton;
    private int defaultButton;
    private int disabled;
    private int normal;
    private int pressed;
    private int rollover;
    private int selected;
    private int selectedDisabled;
    private int selectedPressed;
    private int selectedRollover;

    public SkinToggleButtonIndexModel(int normal, int rollover, int pressed, int disabled, int selected, int selectedRollover, int selectedPressed, int selectedDisabled) {
        this.normal = normal;
        this.rollover = rollover;
        this.pressed = pressed;
        this.disabled = disabled;
        this.selected = selected;
        this.selectedRollover = selectedRollover;
        this.selectedPressed = selectedPressed;
        this.selectedDisabled = selectedDisabled;
    }

    public SkinToggleButtonIndexModel(boolean checkForDefaultButton) {
        this();
        this.checkForDefaultButton = checkForDefaultButton;
    }

    public SkinToggleButtonIndexModel() {
        this.normal = 0;
        this.rollover = 1;
        this.pressed = 2;
        this.disabled = 3;
        this.selected = 4;
        this.selectedRollover = 5;
        this.selectedPressed = 6;
        this.selectedDisabled = 7;
        this.defaultButton = 8;
        this.checkForDefaultButton = false;
    }

    public AbstractButton getButton() {
        return this.button;
    }

    public int getIndexForState(boolean isSelected, boolean isEnabled, boolean isPressed, boolean isRollover) {
        if (!isSelected) {
            if (!isEnabled) {
                return this.disabled;
            }
            if (isPressed) {
                return this.pressed;
            }
            if (isRollover) {
                return this.rollover;
            }
            return this.normal;
        }
        if (!isEnabled) {
            return this.selectedDisabled;
        }
        if (isPressed) {
            return this.selectedPressed;
        }
        if (isRollover) {
            return this.selectedRollover;
        }
        return this.selected;
    }

    public int getIndexForState() {
        if (this.button == null) {
            return 0;
        }
        if (!this.button.isSelected()) {
            JButton jb;
            if (!this.button.isEnabled()) {
                return this.disabled;
            }
            if (this.button.getModel().isPressed()) {
                return this.pressed;
            }
            if (this.button.getModel().isRollover()) {
                return this.rollover;
            }
            if (this.checkForDefaultButton && (jb = null) instanceof JButton && (jb = (JButton)this.button).isDefaultButton()) {
                return this.defaultButton;
            }
            return this.normal;
        }
        if (!this.button.isEnabled()) {
            return this.selectedDisabled;
        }
        if (this.button.getModel().isPressed()) {
            return this.selectedPressed;
        }
        if (this.button.getModel().isRollover()) {
            return this.selectedRollover;
        }
        return this.selected;
    }

    public boolean isCheckForDefaultButton() {
        return this.checkForDefaultButton;
    }

    public void setButton(AbstractButton button) {
        this.button = button;
    }

    public void setCheckForDefaultButton(boolean hasToggleButton) {
        this.checkForDefaultButton = hasToggleButton;
    }
}

