/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralNames;

public class IssuerSerial
extends ASN1Encodable {
    GeneralNames issuer;
    DERBitString issuerUID;
    DERInteger serial;

    public IssuerSerial(GeneralNames issuer, DERInteger serial) {
        this.issuer = issuer;
        this.serial = serial;
    }

    public IssuerSerial(ASN1Sequence seq) {
        this.issuer = GeneralNames.getInstance(seq.getObjectAt(0));
        this.serial = (DERInteger)seq.getObjectAt(1);
        if (seq.size() == 3) {
            this.issuerUID = (DERBitString)seq.getObjectAt(2);
        }
    }

    public static IssuerSerial getInstance(ASN1TaggedObject obj, boolean explicit) {
        return IssuerSerial.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static IssuerSerial getInstance(Object obj) {
        if (obj == null || obj instanceof GeneralNames) {
            return (IssuerSerial)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new IssuerSerial((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public GeneralNames getIssuer() {
        return this.issuer;
    }

    public DERBitString getIssuerUID() {
        return this.issuerUID;
    }

    public DERInteger getSerial() {
        return this.serial;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.issuer);
        v.add(this.serial);
        if (this.issuerUID != null) {
            v.add(this.issuerUID);
        }
        return new DERSequence(v);
    }
}

