/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

public class X509NameTokenizer {
    private StringBuffer buf = new StringBuffer();
    private int index;
    private char seperator;
    private String value;

    public X509NameTokenizer(String oid, char seperator) {
        this.value = oid;
        this.index = -1;
        this.seperator = seperator;
    }

    public X509NameTokenizer(String oid) {
        this(oid, ',');
    }

    public boolean hasMoreTokens() {
        return this.index != this.value.length();
    }

    public String nextToken() {
        if (this.index == this.value.length()) {
            return null;
        }
        int end = this.index + 1;
        boolean quoted = false;
        boolean escaped = false;
        this.buf.setLength(0);
        while (end != this.value.length()) {
            char c = this.value.charAt(end);
            if (c == '\"') {
                if (!escaped) {
                    quoted = !quoted;
                } else {
                    this.buf.append(c);
                }
                escaped = false;
            } else if (escaped || quoted) {
                this.buf.append(c);
                escaped = false;
            } else if (c == '\\') {
                escaped = true;
            } else {
                if (c == this.seperator) break;
                this.buf.append(c);
            }
            ++end;
        }
        this.index = end;
        return this.buf.toString().trim();
    }
}

