/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.StreamCipher;

public class StreamBlockCipher
implements StreamCipher {
    private BlockCipher cipher;
    private byte[] oneByte = new byte[1];

    public StreamBlockCipher(BlockCipher cipher) {
        if (cipher.getBlockSize() != 1) {
            throw new IllegalArgumentException("block cipher block size != 1.");
        }
        this.cipher = cipher;
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName();
    }

    public void init(boolean forEncryption, CipherParameters params) {
        this.cipher.init(forEncryption, params);
    }

    public void processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
        if (outOff + len > out.length) {
            throw new DataLengthException("output buffer too small in processBytes()");
        }
        int i = 0;
        while (i != len) {
            this.cipher.processBlock(in, inOff + i, out, outOff + i);
            ++i;
        }
    }

    public void reset() {
        this.cipher.reset();
    }

    public byte returnByte(byte in) {
        this.oneByte[0] = in;
        this.cipher.processBlock(this.oneByte, 0, this.oneByte, 0);
        return this.oneByte[0];
    }
}

