/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.ElGamalKeyParameters;
import org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;

public class ElGamalEngine
implements AsymmetricBlockCipher {
    private static BigInteger ONE;
    private static BigInteger TWO;
    private static BigInteger ZERO;
    private boolean forEncryption;
    private ElGamalKeyParameters key;
    private SecureRandom random;

    static {
        ZERO = BigInteger.valueOf(0L);
        ONE = BigInteger.valueOf(1L);
        TWO = BigInteger.valueOf(2L);
    }

    public int getInputBlockSize() {
        int bitSize = this.key.getParameters().getP().bitLength();
        if (this.forEncryption) {
            if (bitSize % 8 == 0) {
                return bitSize / 8 - 1;
            }
            return bitSize / 8;
        }
        return 2 * ((bitSize - 1 + 7) / 8);
    }

    public int getOutputBlockSize() {
        int bitSize = this.key.getParameters().getP().bitLength();
        if (this.forEncryption) {
            return 2 * ((bitSize - 1 + 7) / 8);
        }
        return (bitSize - 7) / 8;
    }

    public void init(boolean forEncryption, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom p = (ParametersWithRandom)param;
            this.key = (ElGamalKeyParameters)p.getParameters();
            this.random = p.getRandom();
        } else {
            this.key = (ElGamalKeyParameters)param;
            this.random = new SecureRandom();
        }
        this.forEncryption = forEncryption;
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        byte[] block;
        if (inLen > this.getInputBlockSize() + 1) {
            throw new DataLengthException("input too large for ElGamal cipher.\n");
        }
        if (inLen == this.getInputBlockSize() + 1 && (in[inOff] & 0x80) != 0) {
            throw new DataLengthException("input too large for ElGamal cipher.\n");
        }
        if (inOff != 0 || inLen != in.length) {
            block = new byte[inLen];
            System.arraycopy(in, inOff, block, 0, inLen);
        } else {
            block = in;
        }
        BigInteger g = this.key.getParameters().getG();
        BigInteger p = this.key.getParameters().getP();
        if (this.key instanceof ElGamalPrivateKeyParameters) {
            byte[] in1 = new byte[block.length / 2];
            byte[] in2 = new byte[block.length / 2];
            System.arraycopy(block, 0, in1, 0, in1.length);
            System.arraycopy(block, in1.length, in2, 0, in2.length);
            BigInteger gamma = new BigInteger(1, in1);
            BigInteger phi = new BigInteger(1, in2);
            ElGamalPrivateKeyParameters priv = (ElGamalPrivateKeyParameters)this.key;
            BigInteger m = gamma.modPow(p.subtract(ONE).subtract(priv.getX()), p).multiply(phi).mod(p);
            byte[] out = m.toByteArray();
            if (out[0] != 0) {
                return out;
            }
            byte[] output = new byte[out.length - 1];
            System.arraycopy(out, 1, output, 0, output.length);
            return output;
        }
        ElGamalPublicKeyParameters pub = (ElGamalPublicKeyParameters)this.key;
        BigInteger input = new BigInteger(1, block);
        int pBitLength = p.bitLength();
        BigInteger k = new BigInteger(pBitLength, this.random);
        while (k.equals(ZERO) || k.compareTo(p.subtract(TWO)) > 0) {
            k = new BigInteger(pBitLength, this.random);
        }
        BigInteger gamma = g.modPow(k, p);
        BigInteger phi = input.multiply(pub.getY().modPow(k, p)).mod(p);
        byte[] out1 = gamma.toByteArray();
        byte[] out2 = phi.toByteArray();
        byte[] output = new byte[this.getOutputBlockSize()];
        if (out1.length > output.length / 2) {
            System.arraycopy(out1, 1, output, output.length / 2 - (out1.length - 1), out1.length - 1);
        } else {
            System.arraycopy(out1, 0, output, output.length / 2 - out1.length, out1.length);
        }
        if (out2.length > output.length / 2) {
            System.arraycopy(out2, 1, output, output.length - (out2.length - 1), out2.length - 1);
        } else {
            System.arraycopy(out2, 0, output, output.length - out2.length, out2.length);
        }
        return output;
    }
}

