/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.ZStream;
import com.jcraft.jzlib.ZStreamException;
import java.io.IOException;
import java.io.OutputStream;

public class ZOutputStream
extends OutputStream {
    protected byte[] buf;
    protected byte[] buf1;
    protected int bufsize = 512;
    protected boolean compress;
    protected int flush = 0;
    private OutputStream out;
    protected ZStream z = new ZStream();

    public ZOutputStream(OutputStream out, int level) {
        this.buf = new byte[this.bufsize];
        this.buf1 = new byte[1];
        this.out = out;
        this.z.deflateInit(level);
        this.compress = true;
    }

    public ZOutputStream(OutputStream out) {
        this.buf = new byte[this.bufsize];
        this.buf1 = new byte[1];
        this.out = out;
        this.z.inflateInit();
        this.compress = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            try {
                this.finish();
            }
            catch (IOException ignored) {
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.end();
            this.out.close();
            this.out = null;
            throw throwable;
        }
        this.end();
        this.out.close();
        this.out = null;
    }

    public void end() throws IOException {
        if (this.compress) {
            this.z.deflateEnd();
        } else {
            this.z.inflateEnd();
        }
        this.z.free();
        this.z = null;
    }

    public void finish() throws IOException {
        do {
            this.z.next_out = this.buf;
            this.z.next_out_index = 0;
            this.z.avail_out = this.bufsize;
            int err = this.compress ? this.z.deflate(4) : this.z.inflate(4);
            if (err != 1 && err != 0) {
                throw new ZStreamException((this.compress ? "de" : "in") + "flating: " + this.z.msg);
            }
            if (this.bufsize - this.z.avail_out <= 0) continue;
            this.out.write(this.buf, 0, this.bufsize - this.z.avail_out);
        } while (this.z.avail_in > 0 || this.z.avail_out == 0);
        try {
            this.flush();
        }
        catch (IOException ignored) {
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public int getFlushMode() {
        return this.flush;
    }

    public long getTotalIn() {
        return this.z.total_in;
    }

    public long getTotalOut() {
        return this.z.total_out;
    }

    public void setFlushMode(int flush) {
        this.flush = flush;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        this.z.next_in = b;
        this.z.next_in_index = off;
        this.z.avail_in = len;
        do {
            this.z.next_out = this.buf;
            this.z.next_out_index = 0;
            this.z.avail_out = this.bufsize;
            int err = this.compress ? this.z.deflate(this.flush) : this.z.inflate(this.flush);
            if (err != 0) {
                throw new ZStreamException((this.compress ? "de" : "in") + "flating: " + this.z.msg);
            }
            this.out.write(this.buf, 0, this.bufsize - this.z.avail_out);
        } while (this.z.avail_in > 0 || this.z.avail_out == 0);
    }

    public void write(int b) throws IOException {
        this.buf1[0] = (byte)b;
        this.write(this.buf1, 0, 1);
    }
}

