/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;

public final class downloadcore {
    public static final byte DOWNLOAD_UNKNOWN = 0;
    public static final byte DOWNLOAD_OK = 1;
    public static final byte DOWNLOAD_ERR = 2;
    public static final byte DOWNLOAD_FATAL = 3;
    public static final byte DOWNLOAD_REDIRECT = 4;
    public static final byte DOWNLOAD_BUSY = 5;
    public static final byte DOWNLOAD_RESUME = 6;
    public static final int RESUME_UNKNOWN = 0;
    public static final int RESUME_NOCACHE = 1;
    public static final int RESUME_DIRECT = 2;
    public static final int RESUME_NORMAL = 3;

    public static final int downloadCore(String URL2, qfile qf) throws MalformedURLException, IOException {
        int skipbytes = (int)new File(dmachine.tmp_dir, qf.getLocalName()).length();
        URL url = new URL(URL2);
        if (url.getProtocol().equalsIgnoreCase("ftp")) {
            if (dmachine.ftp_proxydefined) {
                boolean nocache = false;
                if (skipbytes > 0) {
                    if (dmachine.ftp_resume == 1) {
                        nocache = true;
                    } else if (dmachine.ftp_resume == 2) {
                        return downloadcore.GenericTransferLogic(InetAddress.getByName(url.getHost()), url.getPort() > 0 ? url.getPort() : 21, false, new ftpfactory(URL2, qf, true));
                    }
                }
                return downloadcore.GenericTransferLogic(dmachine.ftp_proxyserver, dmachine.ftp_proxyport, nocache, new httpfactory(URL2, qf, false));
            }
            return downloadcore.GenericTransferLogic(InetAddress.getByName(url.getHost()), url.getPort() > 0 ? url.getPort() : 21, false, new ftpfactory(URL2, qf, true));
        }
        if (!dmachine.http_proxydefined && url.getProtocol().equalsIgnoreCase("http")) {
            return downloadcore.GenericTransferLogic(InetAddress.getByName(url.getHost()), url.getPort() > 0 ? url.getPort() : 80, false, new httpfactory(URL2, qf, true));
        }
        if (url.getProtocol().equalsIgnoreCase("fsp")) {
            return downloadcore.GenericTransferLogic(InetAddress.getByName(url.getHost()), url.getPort() > 0 ? url.getPort() : 21, false, new fspfactory(URL2, qf, true));
        }
        if (!dmachine.http_proxydefined) {
            return 3;
        }
        boolean nocache = false;
        if (skipbytes > 0) {
            if (dmachine.http_resume == 1) {
                nocache = true;
            } else if (dmachine.http_resume == 2) {
                return downloadcore.GenericTransferLogic(InetAddress.getByName(url.getHost()), url.getPort() > 0 ? url.getPort() : 80, false, new httpfactory(URL2, qf, true));
            }
        }
        return downloadcore.GenericTransferLogic(dmachine.http_proxyserver, dmachine.http_proxyport, nocache, new httpfactory(URL2, qf, false));
    }

    protected static final int GenericTransferLogic(InetAddress server, int port, boolean nocache, downloadfactory df) throws MalformedURLException, IOException {
        df.processRequest(server, port, nocache);
        long skipbytes = df.havebytes;
        switch (df.rc) {
            case 2: 
            case 3: 
            case 5: {
                df.close();
                return df.rc;
            }
        }
        if (df.rc != 1 && df.rc != 6) {
            System.out.println("[INTERNAL ERROR] rc=" + df.rc + " returned from processRequest for " + df.url);
            df.close();
            return df.rc;
        }
        if (df.rc == 1 && df.contentSize < skipbytes && df.contentSize > 0L) {
            new File(dmachine.attic_dir).mkdirs();
            new File(dmachine.attic_dir, df.qf.getLocalName()).delete();
            new File(dmachine.tmp_dir, df.qf.getLocalName()).renameTo(new File(dmachine.attic_dir, df.qf.getLocalName()));
            dmachine.log_err("Temporary file " + df.qf.getLocalName() + " for " + df.url + " is bigger than expected. Moving it into Attic directory.");
            skipbytes = 0L;
            df.havebytes = 0L;
        }
        if (df.rc == 6) {
            System.out.println("[INFO] Continuing download of " + df.qf.getLocalName() + " on pos=" + df.havebytes + ".");
            skipbytes = 0L;
        } else {
            skipbytes = df.havebytes;
        }
        if (skipbytes > 0L && downloadcore.DataTransfer(df, skipbytes) == 2) {
            return 2;
        }
        return downloadcore.DataTransfer(df, 0L);
    }

    private static final int DataTransfer(downloadfactory df, long skipbytes) throws IOException {
        byte[] b = new byte[4096];
        long total = 0L;
        FilterOutputStream dos = null;
        long start = System.currentTimeMillis() - 1100L;
        long lastrep = start - dmachine.reptime + 10000L;
        if (skipbytes > 0L) {
            System.err.println("[INFO] Resume on " + df.url + " is not supported by server.");
        } else {
            dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(dmachine.tmp_dir + File.separator + df.qf.getLocalName(), true), 4096));
        }
        while (dos == null && skipbytes > 0L || dos != null) {
            long ct;
            int rb;
            try {
                rb = dos != null || skipbytes >= 4096L ? df.datain.read(b) : df.datain.read(b, 0, (int)skipbytes);
            }
            catch (IOException ioe) {
                if (dos != null) {
                    dos.close();
                }
                throw ioe;
            }
            if (rb == -1) break;
            total += (long)rb;
            if (skipbytes > 0L) {
                skipbytes -= (long)rb;
            }
            if (dos != null) {
                ((DataOutputStream)dos).write(b, 0, rb);
            }
            if ((ct = System.currentTimeMillis()) - lastrep <= dmachine.reptime) continue;
            long CPS = total / ((ct - start) / 1000L);
            System.err.println((skipbytes > 0L ? "[SKIP] " : "[LOAD] ") + df.qf.getName() + " " + (df.havebytes - skipbytes + total) + "/" + df.fileSize + " B (" + (int)(100.0f * (float)(df.havebytes - skipbytes + total) / (float)df.fileSize) + "%), ETA=" + util.timeToString(ct - start) + " of " + util.timeToString(1000L * df.contentSize / CPS) + ", BPS=" + CPS);
            lastrep = ct;
        }
        if (dos != null) {
            dos.close();
            df.close();
        }
        if (skipbytes > 0L) {
            dmachine.log_err("Connection closed on " + df.url);
            return 2;
        }
        if (dos == null) {
            return 1;
        }
        if (total < df.contentSize) {
            dmachine.log_err("Connection closed on " + df.url + " Got " + total + "B, expected " + df.contentSize + "B.");
            return 2;
        }
        dmachine.log_ok("*** Download of " + df.qf.getName() + " (" + new File(dmachine.tmp_dir, df.qf.getLocalName()).length() + " B) was SUCCESSFULL ***");
        if (!downloadcore.handleDownloadedFile(df, df.qf)) {
            return 3;
        }
        return 1;
    }

    private static final boolean handleDownloadedFile(downloadfactory df, qfile qf) {
        int i;
        File savedir = new File(dmachine.download_dir);
        File tmpfile = new File(dmachine.tmp_dir, qf.getLocalName());
        if (dmachine.preservemodtime && df.lastModified > 0L) {
            tmpfile.setLastModified(df.lastModified);
        }
        if ((i = qfile.isInRegexpArray(df.url.toString(), qfile.saveto, 0)) > -1) {
            savedir = qfile.saveto_dir[i];
        }
        if (!tmpfile.renameTo(new File(savedir, qf.getLocalName()))) {
            dmachine.log_err("Can not rename file " + qf.getLocalName() + " from " + dmachine.tmp_dir + " to " + savedir);
            if (i == -1) {
                return false;
            }
            if (!tmpfile.renameTo(new File(dmachine.download_dir, qf.getLocalName()))) {
                dmachine.log_fatal("Can not move downloaded file " + qf.getLocalName() + " from temporary directory " + dmachine.tmp_dir + " to download directory " + dmachine.download_dir);
                return false;
            }
            dmachine.log_ok("File " + qf.getName() + " moved to normal download directory instead.");
        }
        if (!qf.getName().equals(qf.getLocalName())) {
            dmachine.log_ok("*** File " + qf.getName() + " saved as " + qf.getLocalName() + " ***");
            String autonm = qfile.genAutoName(qf.getName());
            if (!qf.getLocalName().equals(autonm)) {
                qf.touch();
            }
        }
        return true;
    }
}

