import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.StringTokenizer;

/**
 * HTTP/1.1 download factory
 *
 * @author Radim Kolar
 * @since 0.24
 */
public class httpfactory extends downloadfactory {

	public static String checkreferer[]; /* url with special referer checks */
	public static String sendreferer[];  /* referer to send */

	public static String checkcookie[]; /* url with special cookie */
	public static String sendcookie[];  /* Cookie to sent */

	public static String useragent;
	public static boolean send_useragent;
	public static boolean send_referer;

	/**
	 * @param URL
	 * @param qf
	 * @param dirc
	 * @throws MalformedURLException
	 */
	httpfactory(String URL, qfile qf, boolean dirc)
			throws MalformedURLException {
		super(URL, qf, dirc);
	}

	private final void sendHTTPRequest(java.net.InetAddress adr,int port, boolean nocache) throws java.io.IOException
	{
		Socket s;
		s=new Socket(adr,port);
		s.setSoTimeout(dmachine.timeout);

		// otevrit data output stream
		dataout=new DataOutputStream(new java.io.BufferedOutputStream(s.getOutputStream(),1024));
		datain=new DataInputStream(s.getInputStream());

		// send request
		StringBuffer sb;
		sb=new StringBuffer(1024);
		sb.append("GET ");
		if(direct)
		{
			String fname;
			fname=url.getFile();
			if(fname.length()==0) fname="/";
			sb.append(fname);
		}
		else
			sb.append(url);
		if(havebytes==0) sb.append(" HTTP/1.0");
		else
			sb.append(" HTTP/1.1");

		sb.append("\r\nHost: "+url.getHost());
		sb.append("\r\nAccept: */*");
		if(send_useragent)
			sb.append("\r\nUser-Agent: "+useragent);

		//referer check
		String referer=null;

		if(checkreferer==null) checkreferer=sendreferer=new String[0];

		for(int i=checkreferer.length-1;i>=0;i--)
			if(url.toString().startsWith(checkreferer[i]))
			{
				referer=sendreferer[i];
				break;
			}

		if(referer==null && send_referer)
		{
			/* set default referer */
			referer="http://"+url.getHost()+"/index.html";
		}

		if(referer!=null)
		{
			sb.append("\r\nReferer: ");
			sb.append(referer);
		}

		sb.append("\r\nConnection: close\r\nProxy-Connection: close\r\n");
		if(nocache) sb.append("Pragma: no-cache\r\n");
		if(havebytes>0) sb.append("Range: bytes="+havebytes+"-\r\n");

		/* add custom cookie header */
		if(checkcookie==null) checkcookie=sendcookie=new String[0];
		for(int i=checkcookie.length-1;i>=0;i--)
			if(url.toString().startsWith(checkcookie[i]))
			{
				sb.append("Cookie: ");
				sb.append(sendcookie[i]);
				sb.append("\r\n");
				break;
			}

		// add proxy auth

		if(direct==false)
		{
			if(dmachine.http_auth!=null &&
					url.getProtocol().equals("http"))
				sb.append(dmachine.http_auth);

			if(dmachine.ftp_auth!=null &&
					url.getProtocol().equals("ftp"))
				sb.append(dmachine.ftp_auth);
		}

		// end of HTTP/1.0+ Request
		sb.append("\r\n");
		dataout.writeBytes(sb.toString());
		dataout.flush();
	}

	/* prevede HTTP RC kod na dmachine rc kod */
	private final byte getHTTPRC() throws java.io.IOException
	{
		// read http-encoded reply
		int httprc;
		String line;
		line=datain.readLine(); /* HTTP/1.0 XX OK */
		if(line==null) throw new EOFException("Connection closed");
		/* precteme si tedy httprc kod */
		StringTokenizer st;
		st=new StringTokenizer(line);

		/* WARN: tady to spadne pri remote HTTP 0.9 serveru */
		try
		{
			st.nextToken(); /* http/1.0 - nezajimave */
			httprc=Integer.valueOf(st.nextToken()).intValue();
		}
		catch (Exception http09)
		{
			System.out.println("HTTP Response was: "+line);
			dmachine.log_fatal(url+" HTTP 0.9 server is unsupported");
			return downloadcore.DOWNLOAD_FATAL;
		}

		/* HTTP RC test */
		if(httprc>400 && httprc< 500)
		{
			dmachine.log_fatal("Error "+httprc+" when loading "+url);
			return downloadcore.DOWNLOAD_FATAL;
		}
		else if(httprc>=300 && httprc<400 && httprc!=305) return downloadcore.DOWNLOAD_REDIRECT;
		else if(httprc==206) return downloadcore.DOWNLOAD_RESUME;
		else if(httprc==200 || httprc==202) return downloadcore.DOWNLOAD_OK;
		else if(httprc==503 || httprc==502) return downloadcore.DOWNLOAD_BUSY; // server busy
		else if(httprc==500) return downloadcore.DOWNLOAD_ERR; // server overloaded/tmp error
		else if(httprc==504) return downloadcore.DOWNLOAD_ERR; // gateway timeout
		else if(httprc>=500) {
			dmachine.log_fatal("Error "+httprc+" when loading "+url);
			return downloadcore.DOWNLOAD_FATAL;
		}
		else
		{
			dmachine.log_err("GOT httprc="+httprc+" when loading "+url+" - will retry");
			return downloadcore.DOWNLOAD_ERR;
		}
	}

	private final void getHTTPHeaderData(qfile qf,URL url) throws IOException
	{
		contentSize=0;

		/* cteme hlavicky */
		while(true)
		{
			int j;
			String s1,s2,line;
			line=datain.readLine();
			if(line==null) break;
			if(line.length()==0) break;
			j=line.indexOf(':',0);
			if(j==-1) continue;
			s1=line.substring(0,j).toLowerCase();
			s2=line.substring(j+1).trim();

			if(s1.equals("location"))
			{
				/* kill # */
				int in = s2.indexOf('#');
				if (in>-1)
					s2 = s2.substring(0,in);
				/* get new URL */
				URL nurl;
				nurl=new URL(url,s2);
				qf.redirect(url.toString(),nurl.toString());
				// return DOWNLOAD_REDIRECT; ??
				// no! we are supporting multiple redirects ...
			}
			else if(s1.equals("content-length"))
			{
				try
				{
					contentSize=Integer.valueOf(s2).intValue();
				}
				catch (Exception ignore)
				{}
				continue;
			}
			else if(s1.equals("last-modified"))
			{
				try
				{
					lastModified=new java.util.Date(s2).getTime();
				}
				catch (IllegalArgumentException e)
				{ lastModified=0;}
				continue;
			}
		} /* hlavicky */
		/* compute final filesize if possible */
		if(rc==downloadcore.DOWNLOAD_OK && contentSize>0)
			fileSize=contentSize;
		else
			if(rc==downloadcore.DOWNLOAD_RESUME && contentSize>0)
				fileSize=havebytes+contentSize;
	}

	public static boolean addCookie(String urlmask, String cookie)
	{
		if(urlmask==null || cookie==null) return false;
		if(urlmask.length()==0 || cookie.length()==0) return false;

		if(checkcookie==null) checkcookie=sendcookie=new String[0];

		for(int i=checkcookie.length-1;i>=0;i--)
			if(checkcookie[i].startsWith(urlmask))
			{
				sendcookie[i]=cookie;
				return false;
			}

		// add new record
		checkcookie=util.addStringToArray(urlmask,checkcookie);
		sendcookie= util.addStringToArray(cookie,sendcookie);

		return true;
	}

	public static boolean addReferer(String urlmask, String referer)
	{
		if(urlmask==null || referer==null) return false;
		if(urlmask.length()==0 || referer.length()==0) return false;

		if(checkreferer==null) checkreferer=sendreferer=new String[0];

		for(int i=checkreferer.length-1;i>=0;i--)
			if(checkreferer[i].startsWith(urlmask))
			{
				sendreferer[i]=referer;
				return false;
			}

		// add new record
		checkreferer=util.addStringToArray(urlmask,checkreferer);
		sendreferer= util.addStringToArray(referer,sendreferer);
		return true;
	}



	/* this procedure should modify protected variables as result */
	/* Download factory MUST implement this! */
	/* prepares data connection for download */
	protected void processRequest(InetAddress server,int port,boolean nocache) throws IOException,java.net.MalformedURLException
	{
		sendHTTPRequest(server,port,nocache);
		/* precist httprc */
		rc=getHTTPRC();
		if(rc==downloadcore.DOWNLOAD_FATAL) return;
		getHTTPHeaderData(qf,url);
	}


}
