/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.tasks.ConnectResult;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.core.tasks.ScreenInputBlocker;
import cz.vity.freerapid.core.tasks.exceptions.NoAvailableConnection;
import cz.vity.freerapid.gui.managers.ClientManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadClient;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Browser;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.xmlimport.XMLBind;
import cz.vity.freerapid.xmlimport.ver1.Plugin;
import cz.vity.freerapid.xmlimport.ver1.Plugins;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;

public class CheckPluginUpdateTask
extends CoreTask<List<Plugin>, Void> {
    private static final Logger logger = Logger.getLogger(CheckPluginUpdateTask.class.getName());
    private final ManagerDirector director;
    private final boolean quietMode;
    private static final String VERSION__PARAM = "version";
    private static final String PRODUCT_PARAM = "product";
    private static final String APIVERSION_PARAM = "apiversion";
    private static final String PARAM_LANGUAGE = "lang";
    private static final String PARAM_VERSION_ONLY = "versiononly";
    private static final String PARAM_COUNTRY = "country";
    private static int failed = 0;
    private String newVersionURL;
    private ConnectResult result;

    public CheckPluginUpdateTask(ManagerDirector director, ApplicationContext context, boolean quiet) {
        super(context.getApplication());
        this.director = director;
        this.quietMode = quiet;
        this.result = ConnectResult.SAME_VERSION;
        logger.info("Starting to check for a new plugins version");
        this.setTaskToForeground();
        if (!quiet) {
            this.setInputBlocker(new ScreenInputBlocker(this, Task.BlockingScope.APPLICATION, Swinger.getActiveFrame(), null));
        } else {
            this.setInputBlocker(null);
        }
    }

    @Override
    protected List<Plugin> doInBackground() throws Exception {
        HttpMethodBase method;
        ArrayList<Plugin> newPlugins = new ArrayList<Plugin>();
        if (this.quietMode && failed > 6) {
            return newPlugins;
        }
        AppPrefs.storeProperty("pluginLastUpdateDateTime", System.currentTimeMillis());
        this.message("updatesPluginCheck", new Object[0]);
        ClientManager clientManager = this.director.getClientManager();
        List<ConnectionSettings> connectionSettingses = clientManager.getEnabledConnections();
        if (connectionSettingses.isEmpty()) {
            throw new NoAvailableConnection(this.getResourceMap().getString("noAvailableConnection", new Object[0]));
        }
        DownloadClient client = new DownloadClient();
        client.initClient(connectionSettingses.get(0));
        String url = AppPrefs.getProperty("pluginCheckUrlSelected", "http://wordrider.net/freerapid/pluginsCheck.php");
        if (url.toLowerCase().endsWith(".xml")) {
            method = client.getGetMethod(url);
        } else {
            PostMethod postMethod = client.getPostMethod(url);
            postMethod.addParameter(PRODUCT_PARAM, "FreeRapid");
            postMethod.addParameter(VERSION__PARAM, "0.9u4");
            postMethod.addParameter(APIVERSION_PARAM, "0.855");
            postMethod.addParameter(PARAM_VERSION_ONLY, "0.9u4");
            Locale locale = Locale.getDefault();
            postMethod.addParameter(PARAM_LANGUAGE, locale.getLanguage());
            postMethod.addParameter(PARAM_COUNTRY, locale.getCountry());
            method = postMethod;
        }
        this.message("message.connecting", new Object[0]);
        if (client.makeRequest(method, true) != 200) {
            throw new ConnectException(this.getResourceMap().getString("Connection_failed", new Object[0]));
        }
        this.message("message.checkingData", new Object[0]);
        if (this.isCancelled()) {
            throw new InterruptedException();
        }
        String line = client.getContentAsString();
        if (line != null && line.contains("thisisanupdate")) {
            String lineL = line.toLowerCase();
            if (lineL.contains("required")) {
                int i = lineL.indexOf("http://");
                this.newVersionURL = i != -1 ? line.substring(i).trim() : "http://wordrider.net/freerapid";
                this.result = ConnectResult.NEW_VERSION_REQUIRED;
            } else {
                this.result = lineL.contains("yes") ? ConnectResult.CONNECT_NEW_VERSION : ConnectResult.SAME_VERSION;
            }
        } else {
            this.result = ConnectResult.SAME_VERSION;
        }
        if (this.result == ConnectResult.SAME_VERSION) {
            Plugins rootPlugins = new XMLBind().loadPluginList(line);
            return rootPlugins.getPlugin();
        }
        return Collections.emptyList();
    }

    @Override
    protected void failed(Throwable cause) {
        LogUtils.processException(logger, cause);
        if (this.quietMode) {
            ++failed;
            AppPrefs.storeProperty("pluginLastUpdateDateTime", -1);
            return;
        }
        if (cause instanceof UnknownHostException) {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_check_inet_settings", new Object[0]);
        } else {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_submit_failed", cause.getMessage());
        }
    }

    @Override
    protected void succeeded(List<Plugin> plugins) {
        switch (this.result) {
            case NEW_VERSION_REQUIRED: {
                Swinger.showInformationDialog(this.getResourceMap().getString("message.connect.newVersionRequired", new Object[0]));
                Browser.openBrowser(this.newVersionURL);
                this.getApplication().exit();
                return;
            }
        }
        assert (false);
        for (Plugin plugin : plugins) {
            logger.info("plugin update from server: " + plugin.getId());
        }
    }
}

