/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.tasks.ProxyOutputStream;
import java.io.IOException;
import java.io.OutputStream;

final class CountingOutputStream
extends ProxyOutputStream {
    volatile transient long count;

    public CountingOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        ++this.count;
    }

    @Override
    public void write(byte[] b) throws IOException {
        super.write(b);
        this.count += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.count += (long)len;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }
}

