/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.application.SubmitErrorInfo;
import cz.vity.freerapid.core.tasks.CheckPluginUpdateTask;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.core.tasks.exceptions.NoAvailableConnection;
import cz.vity.freerapid.gui.managers.ClientManager;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadClient;
import java.net.ConnectException;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class SubmitErrorInfoTask
extends CoreTask<Void, Void> {
    private static final Logger logger = Logger.getLogger(SubmitErrorInfoTask.class.getName());
    private final SubmitErrorInfo errorInfo;

    public SubmitErrorInfoTask(SubmitErrorInfo errorInfo) {
        super(Application.getInstance());
        this.errorInfo = errorInfo;
        this.setUserCanCancel(false);
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.message("message.connecting", new Object[0]);
        String url = AppPrefs.getProperty("weburlSubmitError", "http://wordrider.net/posterror.php");
        ClientManager clientManager = ((MainApp)this.getApplication()).getManagerDirector().getClientManager();
        List<ConnectionSettings> connectionSettingses = clientManager.getEnabledConnections();
        ResourceMap map = this.getApplication().getContext().getResourceMap(CheckPluginUpdateTask.class);
        if (connectionSettingses.isEmpty()) {
            throw new NoAvailableConnection(map.getString("noAvailableConnection", new Object[0]));
        }
        DownloadClient client = new DownloadClient();
        client.initClient(connectionSettingses.get(0));
        PostMethod postMethod = client.getPostMethod(url);
        this.errorInfo.toURLPostData(postMethod);
        logger.info("Connected to the web, Writing params");
        this.message("message.sending", new Object[0]);
        if (client.makeRequest(postMethod, true) != 200) {
            throw new ConnectException(map.getString("Connection_failed", new Object[0]));
        }
        logger.info("disconnecting");
        this.message("message.disconnect", new Object[0]);
        return null;
    }
}

