/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs.filechooser;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.FRDUtils;
import cz.vity.freerapid.gui.dialogs.filechooser.EnhancedFileFilter;
import cz.vity.freerapid.gui.dialogs.filechooser.IFileType;
import cz.vity.freerapid.gui.dialogs.filechooser.JAppFileChooser;
import cz.vity.freerapid.gui.dialogs.filechooser.OpenFileChooser;
import cz.vity.freerapid.gui.dialogs.filechooser.SaveFileChooser;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Utils;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

public class OpenSaveDialogFactory {
    private static OpenSaveDialogFactory instance = null;
    private ApplicationContext context;

    private OpenSaveDialogFactory(ApplicationContext context) {
        this.context = context;
    }

    public static synchronized OpenSaveDialogFactory getInstance(ApplicationContext context) {
        if (instance == null) {
            return new OpenSaveDialogFactory(context);
        }
        return instance;
    }

    public File getSaveResultsDialog() {
        ArrayList<EnhancedFileFilter> filters = new ArrayList<EnhancedFileFilter>(3);
        filters.add(new EnhancedFileFilter(new String[]{"txt"}, "filterTxt", new Object[0]));
        filters.add(new EnhancedFileFilter(new String[]{"csv"}, "filterCsv", new Object[0]));
        filters.add(new EnhancedFileFilter(new String[]{"dxf"}, "filterDxf", new Object[0]));
        String path = AppPrefs.getProperty("lastUsedFolderExport", "export");
        String defaultName = AppPrefs.getProperty("lastExportFilename", new File(path).getName());
        File result = this.getSaveFileDialog(filters, "lastExportFilter", "lastUsedFolderExport", defaultName);
        if (result != null) {
            AppPrefs.storeProperty("lastExportFilename", result.getName());
        }
        return result;
    }

    public File getDirChooser(File currentDirectory, String directoryChooserTitle) {
        OpenFileChooser fileDialog = new OpenFileChooser(currentDirectory);
        fileDialog.setAcceptAllFileFilterUsed(false);
        fileDialog.setDialogTitle(directoryChooserTitle);
        fileDialog.setMultiSelectionEnabled(false);
        fileDialog.setFileSelectionMode(1);
        int result = fileDialog.showOpenDialog(Frame.getFrames()[0]);
        if (result != 0) {
            return null;
        }
        return fileDialog.getSelectedFile();
    }

    public File[] getChooseImageFileDialog() {
        ArrayList<EnhancedFileFilter> filters = new ArrayList<EnhancedFileFilter>(3);
        filters.add(new EnhancedFileFilter(new String[]{"tif", "tiff"}, "filterTIF", new Object[0]));
        return this.getOpenFileDialog(filters, "lastUsedImportFilter", "importLastUsedFolder", false);
    }

    private File[] getOpenFileDialog(List<EnhancedFileFilter> fileFilters, String lastUsedFilterKey, String folderPathKey, boolean multiSelection) {
        File[] fileArray;
        OpenFileChooser fileDialog = new OpenFileChooser(new File(AppPrefs.getProperty(folderPathKey, "")));
        fileDialog.updateFileFilters(fileFilters, lastUsedFilterKey);
        fileDialog.setAcceptAllFileFilterUsed(false);
        fileDialog.setMultiSelectionEnabled(multiSelection);
        int result = fileDialog.showOpenDialog(Frame.getFrames()[0]);
        if (result != 0) {
            return new File[0];
        }
        AppPrefs.storeProperty(lastUsedFilterKey, fileFilters.indexOf(fileDialog.getFileFilter()));
        AppPrefs.storeProperty(folderPathKey, FRDUtils.getAbsRelPath(fileDialog.getSelectedFile()).getPath());
        if (multiSelection) {
            fileArray = fileDialog.getSelectedFiles();
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = fileDialog.getSelectedFile();
        }
        return fileArray;
    }

    private File getSaveFileDialog(List<EnhancedFileFilter> fileFilters, String lastUsedFilterKey, String folderPathKey, String fileName) {
        ResourceMap map;
        int choice;
        SaveFileChooser fileDialog = new SaveFileChooser(new File(AppPrefs.getProperty(folderPathKey, "")));
        fileDialog.setMultiSelectionEnabled(false);
        fileDialog.setAcceptAllFileFilterUsed(false);
        fileDialog.setFileName(fileName);
        fileDialog.updateFileFilters(fileFilters, lastUsedFilterKey);
        int result = fileDialog.showSaveDialog(Frame.getFrames()[0]);
        if (result != 0) {
            return null;
        }
        File f = fileDialog.getSelectedFile();
        if (f == null) {
            return null;
        }
        FileFilter usedFilter = fileDialog.getFileFilter();
        if (usedFilter instanceof IFileType && Utils.getExtension(f) == null) {
            String extension = ((IFileType)((Object)usedFilter)).getExtension();
            f = new File(f.getPath().concat(".").concat(extension));
        }
        if (f.isFile() && f.exists() && (choice = Swinger.getChoiceYesNoCancel((map = Swinger.getResourceMap(JAppFileChooser.class)).getString("message.confirm.overwrite", new Object[0]))) == 1) {
            return null;
        }
        AppPrefs.storeProperty(lastUsedFilterKey, fileFilters.indexOf(usedFilter));
        AppPrefs.storeProperty(folderPathKey, f.getPath());
        return f;
    }

    public File[] getChooseProxyList() {
        ArrayList<EnhancedFileFilter> filters = new ArrayList<EnhancedFileFilter>(1);
        filters.add(new EnhancedFileFilter(new String[]{"txt", "list"}, "filterTxt", new Object[0]));
        return this.getOpenFileDialog(filters, "lastUsedImportFilter", "importLastUsedFolder", false);
    }

    public File[] getImportLinks(List<String[]> supportedTypes) {
        return this.getOpenFileDialog(OpenSaveDialogFactory.getFilters(supportedTypes, false), "lastUsedImportFilter", "importLastUsedFolder", true);
    }

    public File getExportLinks(List<String[]> supportedTypes) {
        return this.getSaveFileDialog(OpenSaveDialogFactory.getFilters(supportedTypes, true), "lastExportFilter", "lastUsedFolderExport", "");
    }

    private static List<EnhancedFileFilter> getFilters(List<String[]> supportedTypes, boolean export) {
        String[] allSupported = OpenSaveDialogFactory.getAllSupported(supportedTypes);
        ArrayList<EnhancedFileFilter> filters = new ArrayList<EnhancedFileFilter>(allSupported.length + 1);
        if (!export) {
            filters.add(new EnhancedFileFilter(allSupported, "allSupportedFiles", new Object[0]));
        }
        for (String[] strings : supportedTypes) {
            if (strings[0].equals("txt")) {
                filters.add(new EnhancedFileFilter(strings, "filterTxt", new Object[0]));
                continue;
            }
            if (strings[0].equals("csv")) {
                filters.add(new EnhancedFileFilter(strings, "filterCsv", new Object[0]));
                continue;
            }
            filters.add(new EnhancedFileFilter(strings, "filterContainer", strings[0].toUpperCase(Locale.ENGLISH)));
        }
        return filters;
    }

    private static String[] getAllSupported(List<String[]> supportedTypes) {
        int len = 0;
        for (String[] strings : supportedTypes) {
            len += strings.length;
        }
        String[] allSupported = new String[len];
        len = 0;
        for (String[] strings : supportedTypes) {
            System.arraycopy(strings, 0, allSupported, len, strings.length);
            len += strings.length;
        }
        return allSupported;
    }
}

