/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.application.GlobalEDTExceptionHandler;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.KeyboardFocusManager;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.SwingUtilities;
import org.jdesktop.application.ApplicationContext;

public class ClipboardMonitorManager
extends Thread
implements ClipboardOwner {
    private static final Logger logger = Logger.getLogger(ClipboardMonitorManager.class.getName());
    private ApplicationContext context;
    private final ManagerDirector managerDirector;
    private boolean threadSuspended;
    private static final String URL_LIST_MIME_TYPE = "application/x-java-url; class=java.net.URL";
    private DataFlavor urlFlavor;
    private volatile Object currentClipboardData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClipboardMonitorManager(ApplicationContext context, ManagerDirector managerDirector) {
        this.context = context;
        this.managerDirector = managerDirector;
        this.setPriority(1);
        ClipboardMonitorManager clipboardMonitorManager = this;
        synchronized (clipboardMonitorManager) {
            this.threadSuspended = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName("ClipboardMonitorManager");
        this.setUncaughtExceptionHandler(new GlobalEDTExceptionHandler());
        Clipboard clipboard = this.context.getClipboard();
        while (!ClipboardMonitorManager.interrupted()) {
            try {
                ClipboardMonitorManager clipboardMonitorManager = this;
                synchronized (clipboardMonitorManager) {
                    logger.fine("Clipboard test for sleeping");
                    while (this.threadSuspended) {
                        this.wait();
                    }
                }
                Thread.sleep(700L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                boolean urlFlavorAvailable;
                if (clipboard.getAvailableDataFlavors().length < 10) continue;
                boolean stFlavorAvailable = clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor);
                boolean bl = urlFlavorAvailable = !stFlavorAvailable && clipboard.isDataFlavorAvailable(this.urlFlavor);
                if (!stFlavorAvailable && !urlFlavorAvailable) continue;
                try {
                    Transferable contents = clipboard.getContents(this);
                    Object data = stFlavorAvailable ? contents.getTransferData(DataFlavor.stringFlavor) : contents.getTransferData(this.urlFlavor);
                    if (this.currentClipboardData.equals(data)) continue;
                    this.currentClipboardData = data;
                    this.paste();
                }
                catch (Exception e) {
                }
            }
            catch (IllegalStateException e) {
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LogUtils.processException(logger, e);
            }
            catch (NullPointerException e) {
                LogUtils.processException(logger, e);
            }
            catch (AbstractMethodError e) {
                LogUtils.processException(logger, e);
            }
        }
        logger.info("ClipboardMonitorManager was interrupted");
    }

    void initManager() {
        this.currentClipboardData = "";
        try {
            this.urlFlavor = new DataFlavor(URL_LIST_MIME_TYPE);
        }
        catch (ClassNotFoundException e) {
            LogUtils.processException(logger, e);
        }
        this.updateThreadSleep();
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if ("clipboardMonitoring".equals(evt.getKey())) {
                    ClipboardMonitorManager.this.updateThreadSleep();
                }
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("activeWindow", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null && evt.getNewValue() == null) {
                    ClipboardMonitorManager.this.copyClipboard();
                }
                ClipboardMonitorManager.this.updateThreadSleep();
            }
        });
    }

    private boolean isEnabled() {
        return AppPrefs.getProperty("clipboardMonitoring", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateThreadSleep() {
        boolean newValue;
        boolean oldValue;
        boolean b = this.isEnabled();
        ClipboardMonitorManager clipboardMonitorManager = this;
        synchronized (clipboardMonitorManager) {
            oldValue = this.threadSuspended;
            newValue = this.threadSuspended = !b;
        }
        if (b && oldValue != newValue) {
            if (!this.isAlive()) {
                this.start();
            } else {
                this.wakeUp();
            }
        }
    }

    private void paste() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClipboardMonitorManager.this.managerDirector.getContentManager().getContentPanel().paste();
            }
        });
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        logger.info("Lost Clipboard ownership");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUp() {
        ClipboardMonitorManager clipboardMonitorManager = this;
        synchronized (clipboardMonitorManager) {
            this.notify();
        }
    }

    private void copyClipboard() {
        Clipboard clipboard = this.context.getClipboard();
        try {
            boolean urlFlavorAvailable;
            boolean stFlavorAvailable = clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor);
            boolean bl = urlFlavorAvailable = !stFlavorAvailable && clipboard.isDataFlavorAvailable(this.urlFlavor);
            if (stFlavorAvailable || urlFlavorAvailable) {
                Transferable contents = clipboard.getContents(this);
                try {
                    this.currentClipboardData = stFlavorAvailable ? contents.getTransferData(DataFlavor.stringFlavor) : contents.getTransferData(this.urlFlavor);
                }
                catch (UnsupportedFlavorException e) {
                }
                catch (IOException e) {
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogUtils.processException(logger, e);
                }
            }
        }
        catch (IllegalStateException e) {
        }
        catch (AbstractMethodError e) {
            LogUtils.processException(logger, e);
        }
    }
}

