/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugimpl;

import cz.vity.freerapid.plugins.webclient.interfaces.ConfigurationStorageSupport;
import cz.vity.freerapid.utilities.LogUtils;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.util.logging.Logger;
import org.jdesktop.application.ApplicationContext;

public class StandardStorageSupportImpl
implements ConfigurationStorageSupport {
    private static final Logger logger = Logger.getLogger(StandardStorageSupportImpl.class.getName());
    private final ApplicationContext context;

    public StandardStorageSupportImpl(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public boolean configFileExists(String fileName) {
        File file = new File(this.context.getLocalStorage().getDirectory(), fileName);
        return file.isFile() && file.exists();
    }

    @Override
    public <E> E loadConfigFromFile(String fileName, Class<E> type) throws Exception {
        Object object;
        XMLDecoder xmlDecoder = null;
        try {
            xmlDecoder = new XMLDecoder(this.context.getLocalStorage().openInputFile(fileName), null, null, type.getClassLoader());
            object = xmlDecoder.readObject();
        }
        catch (RuntimeException e) {
            LogUtils.processException(logger, e);
            throw new Exception(e);
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
            throw e;
        }
        finally {
            if (xmlDecoder != null) {
                try {
                    xmlDecoder.close();
                }
                catch (Exception e) {}
            }
        }
        return (E)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeConfigToFile(Object object, String fileName) throws Exception {
        ClassLoader threadCL = null;
        try {
            threadCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(object.getClass().getClassLoader());
            XMLEncoder xmlEncoder = null;
            try {
                xmlEncoder = new XMLEncoder(this.context.getLocalStorage().openOutputFile(fileName));
                xmlEncoder.writeObject(object);
            }
            catch (Exception e) {
                LogUtils.processException(logger, e);
                throw e;
            }
            finally {
                if (xmlEncoder != null) {
                    try {
                        xmlEncoder.close();
                    }
                    catch (Exception e) {
                        LogUtils.processException(logger, e);
                    }
                }
            }
        }
        finally {
            if (threadCL != null) {
                Thread.currentThread().setContextClassLoader(threadCL);
            }
        }
    }
}

