/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient;

import cz.vity.freerapid.plugins.webclient.hoster.PremiumAccount;
import cz.vity.freerapid.plugins.webclient.interfaces.DialogSupport;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpFileDownloadTask;
import cz.vity.freerapid.plugins.webclient.interfaces.PluginContext;
import cz.vity.freerapid.plugins.webclient.interfaces.PluginRunner;
import cz.vity.freerapid.plugins.webclient.interfaces.ShareDownloadService;
import cz.vity.freerapid.utilities.LogUtils;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.java.plugin.Plugin;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.registry.PluginAttribute;
import org.java.plugin.registry.PluginDescriptor;

public abstract class AbstractFileShareService
extends Plugin
implements ShareDownloadService {
    private static final Logger logger = Logger.getLogger(AbstractFileShareService.class.getName());
    private PluginContext pluginContext;
    private Icon image;

    @Override
    protected final void doStart() throws Exception {
        PluginClassLoader loader;
        PluginDescriptor desc = this.getDescriptor();
        PluginAttribute attr = desc.getAttribute("faviconImage");
        if (attr != null && (loader = this.getManager().getPluginClassLoader(desc)) != null) {
            URL resource = loader.getResource(attr.getValue());
            if (resource == null) {
                logger.warning("Icon image for plugin '" + desc.getId() + "' was not found");
            } else {
                try {
                    this.image = new ImageIcon(ImageIO.read(resource));
                }
                catch (IOException e) {
                    logger.warning("Icon image for plugin '" + desc.getId() + "' reading failed");
                }
            }
        }
        this.pluginInit();
    }

    @Override
    public void pluginInit() {
    }

    @Override
    public void pluginStop() {
    }

    @Override
    protected final void doStop() throws Exception {
        this.pluginStop();
    }

    @Override
    public Icon getFaviconImage() {
        return this.image;
    }

    @Override
    public String getId() {
        return this.getDescriptor().getId();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public void run(HttpFileDownloadTask downloadTask) throws Exception {
        PluginRunner pluginRunner = this.getPluginRunnerInstance();
        if (pluginRunner == null) {
            throw new NullPointerException("getPluginRunnerInstance must no return null");
        }
        pluginRunner.init(this, downloadTask);
        pluginRunner.run();
    }

    @Override
    public void runCheck(HttpFileDownloadTask downloadTask) throws Exception {
        PluginRunner pluginRunner = this.getPluginRunnerInstance();
        if (pluginRunner == null) {
            throw new NullPointerException("getPluginRunnerInstance must no return null");
        }
        pluginRunner.init(this, downloadTask);
        pluginRunner.runCheck();
    }

    @Override
    public boolean supportsRunCheck() {
        return false;
    }

    @Override
    public void showOptions() throws Exception {
    }

    @Override
    public PluginContext getPluginContext() {
        return this.pluginContext;
    }

    @Override
    public void setPluginContext(PluginContext pluginContext) {
        this.pluginContext = pluginContext;
    }

    protected PremiumAccount showAccountDialog(PremiumAccount account, String dialogTitle, String pluginConfigFile) {
        DialogSupport dialogSupport = this.getPluginContext().getDialogSupport();
        try {
            PremiumAccount pa = dialogSupport.showAccountDialog(account, dialogTitle);
            if (pa != null) {
                this.getPluginContext().getConfigurationStorageSupport().storeConfigToFile(pa, pluginConfigFile);
                return pa;
            }
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
        }
        return account;
    }

    protected PremiumAccount getAccountConfigFromFile(String pluginConfigFile) {
        if (this.getPluginContext().getConfigurationStorageSupport().configFileExists(pluginConfigFile)) {
            try {
                return this.getPluginContext().getConfigurationStorageSupport().loadConfigFromFile(pluginConfigFile, PremiumAccount.class);
            }
            catch (Exception e) {
                LogUtils.processException(logger, e);
                return new PremiumAccount();
            }
        }
        return new PremiumAccount();
    }

    protected abstract PluginRunner getPluginRunnerInstance();
}

