/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing.components;

import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.utilities.Browser;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;

public class EditorPaneLinkDetector
extends JEditorPane {
    private static final Logger logger = Logger.getLogger(EditorPaneLinkDetector.class.getName());
    private static final String EXAMPLE = "";
    private static final Pattern REGEXP_URL = Pattern.compile("(http|https)://([a-zA-Z0-9\\.\\- ]+(:[a-zA-Z0-9\\.:&%\\$\\- ]+)*@)?((25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9])\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[0-9])|([a-zA-Z0-9\\- ]+\\.)*[a-zA-Z0-9\\- ]+\\.[a-zA-Z ]{2,4})(:[0-9]+)?(/[^/][\\p{Lu}\\p{Ll}0-9\\[\\]\\.:,\\?'\\\\/\\+&%\\$#=~_\\-@ ]*)*");

    public EditorPaneLinkDetector() {
        Action copyAction = this.getActionMap().get("copy");
        Action pasteAction = this.getActionMap().get("paste");
        this.getInputMap().put(SwingUtils.getShiftKeyStroke(155), pasteAction);
        this.getInputMap().put(SwingUtils.getCtrlKeyStroke(155), copyAction);
        final SyntaxDocument doc = new SyntaxDocument();
        this.setEditorKit(new StyledEditorKit(){

            @Override
            public Document createDefaultDocument() {
                return doc;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JTextComponent source = (JTextComponent)e.getSource();
                if (source.isEditable()) {
                    return;
                }
                StyledDocument doc = (StyledDocument)source.getDocument();
                Object attribute = doc.getCharacterElement(source.viewToModel(e.getPoint())).getAttributes().getAttribute("EMAIL");
                if (attribute != null) {
                    e.consume();
                    String email = attribute.toString();
                    logger.info("EditorPaneLinkDetector opening email " + e);
                    Browser.openBrowser("mailto:" + email);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 17) {
                    if (EditorPaneLinkDetector.this.isEditable()) {
                        EditorPaneLinkDetector.this.setEditable(false);
                    }
                } else if (!EditorPaneLinkDetector.this.isEditable()) {
                    EditorPaneLinkDetector.this.setEditable(true);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 17) {
                    EditorPaneLinkDetector.this.setEditable(true);
                }
            }
        });
        this.insertExampleEmail(doc);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JTextComponent source = (JTextComponent)e.getSource();
                if (EditorPaneLinkDetector.EXAMPLE.equals(source.getText())) {
                    source.setText(EditorPaneLinkDetector.EXAMPLE);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                JTextComponent source = (JTextComponent)e.getSource();
                if (source.getText().length() <= 0) {
                    EditorPaneLinkDetector.this.insertExampleEmail((StyledDocument)source.getDocument());
                }
            }
        });
    }

    public void setURLList(List<URL> urlList) {
        LinkedList<String> urlStringList = new LinkedList<String>();
        for (URL url : urlList) {
            urlStringList.add(url.toExternalForm());
        }
        this.setURLs(urlStringList);
    }

    private void insertExampleEmail(StyledDocument doc) {
        SimpleAttributeSet example = new SimpleAttributeSet();
        StyleConstants.setForeground(example, Color.GRAY);
        try {
            doc.insertString(0, EXAMPLE, example);
        }
        catch (BadLocationException e) {
            LogUtils.processException(logger, e);
        }
    }

    public void setURLs(List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        Document document = this.getDocument();
        String s = EXAMPLE;
        try {
            s = document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        StringBuilder builder = new StringBuilder();
        s = s.trim();
        builder.append(s);
        if (s.length() > 0) {
            builder.append('\n');
        }
        for (String item : list) {
            builder.append(item).append('\n');
        }
        String str = builder.toString();
        try {
            this.setText(EXAMPLE);
            document.insertString(0, str, null);
        }
        catch (BadLocationException e) {
            LogUtils.processException(logger, e);
        }
    }

    public void setURLs(String s) {
        Pattern pattern = REGEXP_URL;
        Matcher matcher = pattern.matcher(s);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            String e = matcher.group();
            if (EXAMPLE.equals(e)) continue;
            list.add(e);
        }
        this.setURLs(list);
    }

    public List<URL> getURLs() {
        String s = this.getText();
        String[] urls = s.split("\n|\t|(?:  )");
        ArrayList<URL> list = new ArrayList<URL>(urls.length);
        for (String url : urls) {
            URL u;
            if (url.trim().isEmpty() || (u = this.getURL(url)) == null) continue;
            list.add(u);
        }
        return list;
    }

    public List<String> getURLsAsStringList() {
        String s = this.getText();
        String[] urls = s.split("\n|\t|(?:  )");
        ArrayList<String> list = new ArrayList<String>(urls.length);
        for (String url : urls) {
            if (url.isEmpty()) continue;
            list.add(url);
        }
        return list;
    }

    private String checkURI(String url) throws URIException {
        String defaultProtocolCharset = URI.getDefaultProtocolCharset();
        try {
            return new URI(url, true, defaultProtocolCharset).getEscapedURIReference();
        }
        catch (URIException e) {
            logger.warning(String.format("Invalid URL - '%s' does not match URI specification", url));
            try {
                return new URI(URIUtil.encodePathQuery(url), true, defaultProtocolCharset).getEscapedURIReference();
            }
            catch (URIException e1) {
                throw e;
            }
        }
    }

    private URL getURL(String url) {
        try {
            return new URL(this.checkURI(url));
        }
        catch (MalformedURLException e) {
        }
        catch (URIException uRIException) {
            // empty catch block
        }
        return null;
    }

    static /* synthetic */ Pattern access$200() {
        return REGEXP_URL;
    }

    class SyntaxDocument
    extends DefaultStyledDocument {
        private DefaultStyledDocument doc;
        private Element rootElement;
        private MutableAttributeSet normal;
        private MutableAttributeSet keyword;
        private final Pattern EMAIL_PATTERN = EditorPaneLinkDetector.access$200();
        private static final String DELIMITERS = "\n\t";

        public SyntaxDocument() {
            this.doc = this;
            this.rootElement = this.doc.getDefaultRootElement();
            this.putProperty("__EndOfLine__", "\n");
            this.normal = new SimpleAttributeSet();
            StyleConstants.setForeground(this.normal, Color.RED);
            this.keyword = new SimpleAttributeSet();
            StyleConstants.setForeground(this.keyword, Color.BLUE);
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            super.insertString(offset, str, a);
            if (str.equals(EditorPaneLinkDetector.EXAMPLE)) {
                return;
            }
            this.processChangedLines(offset, str.length());
        }

        @Override
        public void remove(int offset, int length) throws BadLocationException {
            super.remove(offset, length);
            this.processChangedLines(offset, 0);
        }

        public void processChangedLines(int offset, int length) throws BadLocationException {
            String content = this.doc.getText(0, this.doc.getLength());
            int startLine = this.rootElement.getElementIndex(offset);
            int endLine = this.rootElement.getElementIndex(offset + length);
            for (int i = startLine; i <= endLine; ++i) {
                this.applyHighlighting(content, i);
            }
        }

        private void applyHighlighting(String content, int line) throws BadLocationException {
            int startOffset = this.rootElement.getElement(line).getStartOffset();
            int endOffset = this.rootElement.getElement(line).getEndOffset() - 1;
            int lineLength = endOffset - startOffset;
            int contentLength = content.length();
            if (endOffset >= contentLength) {
                endOffset = contentLength - 1;
            }
            this.doc.setCharacterAttributes(startOffset, lineLength, this.normal, true);
            this.checkForTokens(content, startOffset, endOffset);
        }

        private void checkForTokens(String content, int startOffset, int endOffset) {
            while (startOffset <= endOffset) {
                while (this.isDelimiter(content.substring(startOffset, startOffset + 1))) {
                    if (startOffset < endOffset) {
                        ++startOffset;
                        continue;
                    }
                    return;
                }
                startOffset = this.getOtherToken(content, startOffset, endOffset);
            }
        }

        private int getOtherToken(String content, int startOffset, int endOffset) {
            int endOfToken;
            for (endOfToken = startOffset + 1; endOfToken <= endOffset && !this.isDelimiter(content.substring(endOfToken, endOfToken + 1)); ++endOfToken) {
            }
            String token = content.substring(startOffset, endOfToken);
            if (this.isKeyword(token)) {
                this.keyword.addAttribute("EMAIL", token);
                this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.keyword, false);
            }
            return endOfToken + 1;
        }

        protected boolean isDelimiter(String character) {
            return DELIMITERS.indexOf(character.charAt(0)) != -1;
        }

        protected boolean isKeyword(String token) {
            Matcher match = this.EMAIL_PATTERN.matcher(token);
            return match.find() && EditorPaneLinkDetector.this.getURL(match.group()) != null;
        }
    }
}

