/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;

public final class Crc32 {
    private Crc32() {
    }

    public static byte[] crc32(byte[] data) {
        CRC32 crc = new CRC32();
        crc.update(data);
        return Crc32.crc32ToByteArray(crc.getValue());
    }

    public static byte[] crc32(String data) {
        return Crc32.crc32(StringUtils.getBytesUtf8(data));
    }

    public static byte[] crc32(InputStream data) throws IOException {
        int i;
        CRC32 crc = new CRC32();
        byte[] b = new byte[1024];
        while ((i = data.read(b)) > -1) {
            crc.update(b, 0, i);
        }
        return Crc32.crc32ToByteArray(crc.getValue());
    }

    private static byte[] crc32ToByteArray(long l) {
        byte[] b = new byte[4];
        ByteBuffer.wrap(b).asIntBuffer().put((int)l);
        return b;
    }

    public static String crc32Hex(byte[] data) {
        return Hex.encodeHexString(Crc32.crc32(data));
    }

    public static String crc32Hex(String data) {
        return Hex.encodeHexString(Crc32.crc32(data));
    }

    public static String crc32Hex(InputStream data) throws IOException {
        return Hex.encodeHexString(Crc32.crc32(data));
    }
}

