/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private Date dat = new Date();
    private static final String format = "{0,time}";
    private MessageFormat formatter;
    private Object[] args = new Object[1];
    static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");

    @Override
    public synchronized String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        this.dat.setTime(record.getMillis());
        this.args[0] = this.dat;
        StringBuffer text = new StringBuffer();
        if (this.formatter == null) {
            this.formatter = new MessageFormat(format);
        }
        this.formatter.format(this.args, text, (FieldPosition)null);
        sb.append(text);
        sb.append(' ');
        String message = this.formatMessage(record);
        sb.append(record.getLevel().getName());
        sb.append(": ");
        sb.append(message);
        sb.append(LINE_SEPARATOR);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

