/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities;

import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.QuietMode;
import java.applet.Applet;
import java.applet.AudioClip;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.jdesktop.application.ResourceManager;
import org.jdesktop.application.ResourceMap;

public class Sound {
    private static final Logger logger = Logger.getLogger(Sound.class.getName());
    private static final Map<String, AudioClip> clipsMap = new HashMap<String, AudioClip>(1);

    private Sound() {
    }

    private static void playSound(AudioClip clip) {
        if (clip != null) {
            clip.play();
        }
    }

    private static AudioClip getCachedAudioClip(String fileName) {
        if (!clipsMap.containsKey(fileName)) {
            AudioClip audioClip = Sound.getAudioClip(fileName);
            if (audioClip != null) {
                clipsMap.put(fileName, audioClip);
            }
            return audioClip;
        }
        return clipsMap.get(fileName);
    }

    private static AudioClip getAudioClip(String fileName) {
        ResourceManager rm = MainApp.getAContext().getResourceManager();
        ResourceMap resourceMap = rm.getResourceMap();
        String dir = resourceMap.getResourcesDir() + "sound" + "/" + fileName;
        URL url = resourceMap.getClassLoader().getResource(dir);
        if (url == null) {
            return null;
        }
        return Applet.newAudioClip(url);
    }

    public static void playSound(String clip) {
        Sound.playSound(clip, true);
    }

    public static void playSound(String clip, boolean considerQuietMode) {
        if (!(considerQuietMode && QuietMode.getInstance().isSoundsDisabled() && QuietMode.getInstance().isActive())) {
            AudioClip audioClip = Sound.getCachedAudioClip(clip);
            if (audioClip == null) {
                logger.warning("Unable to load " + clip);
            }
            Sound.playSound(audioClip);
        }
    }
}

