/*
 * Decompiled with CFR 0.152.
 */
package nl.ikarus.nxt.priv.imageio.icoreader.obj;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.LinkedList;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.Bitmap16;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.Bitmap24;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.Bitmap32;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.BitmapImageIO;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.IconEntry;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.IndexedBitmap;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.MyReader;

public abstract class Bitmap {
    private BufferedImage _cachedImage = null;
    protected IconEntry entry;
    protected int biWidth;
    protected int biHeight;
    protected int biSize;
    protected int biPlanes;
    protected int biBitCount;
    protected int biCompression;
    protected int biSizeImage;
    protected int biXPelsPerMeter;
    protected int biYPelsPerMeter;
    protected int biColorsUsed;
    protected int biColorsImportant;
    protected int XORmaskSize;
    protected int ANDMaskSize;
    protected byte[] RGBQUAD;
    protected byte[] XOR;
    protected byte[] AND;
    protected MyReader reader;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$nl$ikarus$nxt$priv$imageio$icoreader$obj$Bitmap;

    protected static int readBitCountFromData(byte[] data) throws IOException {
        MyReader reader = new MyReader(new DataInputStream(new ByteArrayInputStream(data)));
        reader.readDWORD();
        reader.readLONG();
        reader.readLONG();
        reader.readWORD();
        int bitcount = reader.readWORD();
        return bitcount;
    }

    protected Bitmap(IconEntry pEntry) throws IOException {
        this.entry = pEntry;
        this.reader = new MyReader(new DataInputStream(new ByteArrayInputStream(this.entry.getImageData())));
        this.biSize = this.reader.readDWORD();
        this.biWidth = this.reader.readLONG();
        this.biHeight = this.reader.readLONG();
        this.biPlanes = this.reader.readWORD();
        this.biBitCount = this.reader.readWORD();
        this.biCompression = this.reader.readDWORD();
        this.biSizeImage = this.reader.readDWORD();
        this.biXPelsPerMeter = this.reader.readLONG();
        this.biYPelsPerMeter = this.reader.readLONG();
        this.biColorsUsed = this.reader.readDWORD();
        this.biColorsImportant = this.reader.readDWORD();
        this.checkCompression();
    }

    private void checkCompression() throws IOException {
        if (this.biCompression != 0 && !(this instanceof BitmapImageIO)) {
            throw new IOException("Compressed icons are currently unsupported... If you want support, please send an example to the author of this class, used compression: " + new Compression().getCompressionName(this.biCompression));
        }
    }

    public static Bitmap getImageIoBitmap(IconEntry entry) throws IOException {
        return new BitmapImageIO(entry);
    }

    public static Bitmap getBitmap(IconEntry entry) throws IOException {
        Bitmap res = null;
        switch (entry.getBitCount()) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                res = new IndexedBitmap(entry);
                break;
            }
            case 16: {
                System.err.println("16 Bpp not yet tested: " + entry.getBitCount() + " using an untested class");
                res = new Bitmap16(entry);
                break;
            }
            case 24: {
                res = new Bitmap24(entry);
                break;
            }
            case 32: {
                res = new Bitmap32(entry);
                break;
            }
            default: {
                System.err.println("Unsupported bpp: " + entry.getBitCount());
            }
        }
        return res;
    }

    public BufferedImage getImage() throws IOException {
        if (this._cachedImage != null) {
            return this._cachedImage;
        }
        this.checkCompression();
        this._cachedImage = this.createImage();
        return this._cachedImage;
    }

    protected abstract BufferedImage createImage() throws IOException;

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        String name = this.getClass().getName();
        int idx = name.lastIndexOf(46);
        sb.append(name.substring(idx + 1));
        sb.append(" [");
        try {
            Class<?> tmpC;
            LinkedList classes = new LinkedList();
            for (tmpC = this.getClass(); tmpC != (class$nl$ikarus$nxt$priv$imageio$icoreader$obj$Bitmap == null ? Bitmap.class$("nl.ikarus.nxt.priv.imageio.icoreader.obj.Bitmap") : class$nl$ikarus$nxt$priv$imageio$icoreader$obj$Bitmap) && tmpC != (class$java$lang$Object == null ? Bitmap.class$("java.lang.Object") : class$java$lang$Object) && tmpC != null; tmpC = tmpC.getSuperclass()) {
                classes.addFirst(tmpC);
            }
            this.append(sb, true, tmpC.getDeclaredFields());
            Iterator i$ = classes.iterator();
            while (i$.hasNext()) {
                Class c = (Class)i$.next();
                this.append(sb, false, c.getDeclaredFields());
            }
        }
        catch (IllegalAccessException ex) {
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        sb.append("]");
        return sb.toString();
    }

    private void append(StringBuffer sb, boolean first, Field[] data) throws IllegalAccessException, IllegalArgumentException {
        Field[] arr$ = data;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Field f = arr$[i$];
            if (f.getName().equals("entry") || f.getName().equals("reader")) continue;
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(f.getName()).append("=");
            sb.append(f.get(this));
        }
    }

    protected class Compression {
        public static final int BI_BITFIELDS = 3;
        public static final int BI_JPEG = 4;
        public static final int BI_PNG = 5;
        public static final int BI_RGB = 0;
        public static final int BI_RLE4 = 2;
        public static final int BI_RLE8 = 1;
        public static final int BI_1632 = 842217009;

        protected Compression() {
        }

        public String getCompressionName(int val) {
            switch (val) {
                case 3: {
                    return "BI_BITFIELDS";
                }
                case 4: {
                    return "BI_JPEG";
                }
                case 5: {
                    return "BI_PNG";
                }
                case 0: {
                    return "BI_RGB (uncompressed)";
                }
                case 2: {
                    return "BI_RLE4";
                }
                case 1: {
                    return "BI_RLE8";
                }
                case 842217009: {
                    return "BI_1632";
                }
            }
            return "UNKNOWN";
        }
    }
}

