/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.filterchain;

import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.filterchain.IoFilterChainBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIoFilterChainBuilder
implements IoFilterChainBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIoFilterChainBuilder.class);
    private final List<IoFilterChain.Entry> entries = new CopyOnWriteArrayList<IoFilterChain.Entry>();

    public IoFilterChain.Entry getEntry(String string) {
        for (IoFilterChain.Entry entry : this.entries) {
            if (!entry.getName().equals(string)) continue;
            return entry;
        }
        return null;
    }

    public boolean contains(String string) {
        return this.getEntry(string) != null;
    }

    public synchronized void addFirst(String string, IoFilter ioFilter) {
        this.register(0, new EntryImpl(string, ioFilter));
    }

    public synchronized void addLast(String string, IoFilter ioFilter) {
        this.register(this.entries.size(), new EntryImpl(string, ioFilter));
    }

    public synchronized IoFilter remove(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name");
        }
        ListIterator<IoFilterChain.Entry> listIterator = this.entries.listIterator();
        while (listIterator.hasNext()) {
            IoFilterChain.Entry entry = listIterator.next();
            if (!entry.getName().equals(string)) continue;
            this.entries.remove(listIterator.previousIndex());
            return entry.getFilter();
        }
        throw new IllegalArgumentException("Unknown filter name: " + string);
    }

    public void buildFilterChain(IoFilterChain ioFilterChain) throws Exception {
        for (IoFilterChain.Entry entry : this.entries) {
            ioFilterChain.addLast(entry.getName(), entry.getFilter());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ ");
        boolean bl = true;
        for (IoFilterChain.Entry entry : this.entries) {
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            stringBuilder.append('(');
            stringBuilder.append(entry.getName());
            stringBuilder.append(':');
            stringBuilder.append(entry.getFilter());
            stringBuilder.append(')');
        }
        if (bl) {
            stringBuilder.append("empty");
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    private void register(int n, IoFilterChain.Entry entry) {
        if (this.contains(entry.getName())) {
            throw new IllegalArgumentException("Other filter is using the same name: " + entry.getName());
        }
        this.entries.add(n, entry);
    }

    private class EntryImpl
    implements IoFilterChain.Entry {
        private final String name;
        private volatile IoFilter filter;

        private EntryImpl(String string, IoFilter ioFilter) {
            if (string == null) {
                throw new IllegalArgumentException("name");
            }
            if (ioFilter == null) {
                throw new IllegalArgumentException("filter");
            }
            this.name = string;
            this.filter = ioFilter;
        }

        public String getName() {
            return this.name;
        }

        public IoFilter getFilter() {
            return this.filter;
        }

        public IoFilter.NextFilter getNextFilter() {
            throw new IllegalStateException();
        }

        public String toString() {
            return "(" + this.getName() + ':' + this.filter + ')';
        }
    }
}

