/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractIconFactory;
import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BaseTableHeaderUI
extends BasicTableHeaderUI {
    private TableCellRenderer originalHeaderRenderer;
    protected MouseAdapter myMouseAdapter = null;
    protected MouseMotionAdapter myMouseMotionAdapter = null;
    protected int rolloverCol = -1;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseTableHeaderUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.originalHeaderRenderer = this.header.getDefaultRenderer();
        if (this.originalHeaderRenderer != null && "sun.swing.table.DefaultTableCellHeaderRenderer".equals(this.originalHeaderRenderer.getClass().getName())) {
            this.header.setDefaultRenderer(new BaseDefaultHeaderRenderer());
        }
    }

    public void uninstallUI(JComponent jComponent) {
        if (this.header.getDefaultRenderer() instanceof BaseDefaultHeaderRenderer) {
            this.header.setDefaultRenderer(this.originalHeaderRenderer);
        }
        super.uninstallUI(jComponent);
    }

    public void installListeners() {
        super.installListeners();
        this.myMouseAdapter = new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                boolean bl = false;
                if (JTattooUtilities.getJavaVersion() >= 1.6) {
                    boolean bl2 = bl = BaseTableHeaderUI.this.header.getTable().getRowSorter() != null;
                }
                if (bl || BaseTableHeaderUI.this.header.getReorderingAllowed()) {
                    if (BaseTableHeaderUI.this.header.getBounds().contains(mouseEvent.getPoint())) {
                        int n = BaseTableHeaderUI.this.rolloverCol;
                        BaseTableHeaderUI.this.rolloverCol = BaseTableHeaderUI.this.header.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
                        BaseTableHeaderUI.this.updateRolloverColumn(n, BaseTableHeaderUI.this.rolloverCol);
                    } else {
                        int n = BaseTableHeaderUI.this.rolloverCol;
                        BaseTableHeaderUI.this.rolloverCol = -1;
                        BaseTableHeaderUI.this.updateRolloverColumn(n, BaseTableHeaderUI.this.rolloverCol);
                    }
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                boolean bl = false;
                if (JTattooUtilities.getJavaVersion() >= 1.6) {
                    boolean bl2 = bl = BaseTableHeaderUI.this.header.getTable().getRowSorter() != null;
                }
                if (bl || BaseTableHeaderUI.this.header.getReorderingAllowed()) {
                    int n = BaseTableHeaderUI.this.rolloverCol;
                    BaseTableHeaderUI.this.rolloverCol = BaseTableHeaderUI.this.header.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
                    BaseTableHeaderUI.this.updateRolloverColumn(n, BaseTableHeaderUI.this.rolloverCol);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                boolean bl = false;
                if (JTattooUtilities.getJavaVersion() >= 1.6) {
                    boolean bl2 = bl = BaseTableHeaderUI.this.header.getTable().getRowSorter() != null;
                }
                if (bl || BaseTableHeaderUI.this.header.getReorderingAllowed()) {
                    int n = BaseTableHeaderUI.this.rolloverCol;
                    BaseTableHeaderUI.this.rolloverCol = -1;
                    BaseTableHeaderUI.this.updateRolloverColumn(n, BaseTableHeaderUI.this.rolloverCol);
                }
            }
        };
        this.myMouseMotionAdapter = new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                boolean bl = false;
                if (JTattooUtilities.getJavaVersion() >= 1.6) {
                    boolean bl2 = bl = BaseTableHeaderUI.this.header.getTable().getRowSorter() != null;
                }
                if ((bl || BaseTableHeaderUI.this.header.getReorderingAllowed()) && BaseTableHeaderUI.this.header.getDraggedColumn() == null) {
                    int n = BaseTableHeaderUI.this.rolloverCol;
                    BaseTableHeaderUI.this.rolloverCol = BaseTableHeaderUI.this.header.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
                    BaseTableHeaderUI.this.updateRolloverColumn(n, BaseTableHeaderUI.this.rolloverCol);
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                boolean bl = false;
                if (JTattooUtilities.getJavaVersion() >= 1.6) {
                    boolean bl2 = bl = BaseTableHeaderUI.this.header.getTable().getRowSorter() != null;
                }
                if (bl || BaseTableHeaderUI.this.header.getReorderingAllowed()) {
                    if (BaseTableHeaderUI.this.header.getDraggedColumn() != null && BaseTableHeaderUI.this.header.getDraggedColumn().getIdentifier() != null) {
                        BaseTableHeaderUI.this.rolloverCol = BaseTableHeaderUI.this.header.getColumnModel().getColumnIndex(BaseTableHeaderUI.this.header.getDraggedColumn().getIdentifier());
                    } else if (BaseTableHeaderUI.this.header.getResizingColumn() != null) {
                        BaseTableHeaderUI.this.rolloverCol = -1;
                    }
                }
            }
        };
        this.header.addMouseListener(this.myMouseAdapter);
        this.header.addMouseMotionListener(this.myMouseMotionAdapter);
    }

    public void uninstallListeners() {
        this.header.removeMouseListener(this.myMouseAdapter);
        this.header.removeMouseMotionListener(this.myMouseMotionAdapter);
        super.uninstallListeners();
    }

    protected boolean drawAllwaysActive() {
        return false;
    }

    protected boolean drawRolloverBar() {
        return false;
    }

    protected Component getHeaderRenderer(int n) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.header.getDefaultRenderer();
        }
        return tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
    }

    private int getHeaderHeight() {
        int n = 0;
        boolean bl = false;
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            Object object;
            boolean bl2;
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            boolean bl3 = bl2 = tableColumn.getHeaderRenderer() == null;
            if (bl2 && bl) continue;
            Component component = this.getHeaderRenderer(i);
            int n2 = component.getPreferredSize().height;
            n = Math.max(n, n2);
            if (!bl2 || n2 <= 0 || (object = tableColumn.getHeaderValue()) == null || (object = object.toString()) == null || object.equals("")) continue;
            bl = true;
        }
        return n + 2;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getPreferredWidth();
        }
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        return new Dimension((int)l, this.getHeaderHeight());
    }

    protected void updateRolloverColumn(int n, int n2) {
        this.header.repaint(this.header.getHeaderRect(n));
        this.header.repaint(this.header.getHeaderRect(n2));
    }

    protected void rolloverColumnUpdated(int n, int n2) {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean bl = this.header.getComponentOrientation().isLeftToRight();
        Rectangle rectangle = graphics.getClipBounds();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y);
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n2 = this.header.columnAtPoint(bl ? point : point2);
        int n3 = this.header.columnAtPoint(bl ? point2 : point);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = tableColumnModel.getColumnCount() - 1;
        }
        TableColumn tableColumn = this.header.getDraggedColumn();
        Rectangle rectangle2 = this.header.getHeaderRect(bl ? n2 : n3);
        if (bl) {
            for (n = n2; n <= n3; ++n) {
                int n4;
                TableColumn tableColumn2 = tableColumnModel.getColumn(n);
                rectangle2.width = n4 = tableColumn2.getWidth();
                if (tableColumn2 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n);
                }
                rectangle2.x += n4;
            }
        } else {
            for (n = n3; n >= n2; --n) {
                int n5;
                TableColumn tableColumn3 = tableColumnModel.getColumn(n);
                rectangle2.width = n5 = tableColumn3.getWidth();
                if (tableColumn3 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n);
                }
                rectangle2.x += n5;
            }
        }
        if (tableColumn != null) {
            n = this.viewIndexForColumn(tableColumn);
            Rectangle rectangle3 = this.header.getHeaderRect(n);
            graphics.setColor(this.header.getParent().getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            rectangle3.x += this.header.getDraggedDistance();
            graphics.setColor(this.header.getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            this.paintCell(graphics, rectangle3, n);
        }
        this.rendererPane.removeAll();
    }

    protected void paintBackground(Graphics graphics, Rectangle rectangle, int n) {
        Component component = this.getHeaderRenderer(n);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        if (n == this.rolloverCol && component.isEnabled()) {
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getRolloverColors(), n2, n3, n4, n5);
        } else if (JTattooUtilities.isFrameActive(this.header)) {
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getColHeaderColors(), n2, n3, n4, n5);
        } else {
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getInActiveColors(), n2, n3, n4, n5);
        }
    }

    protected void paintCell(Graphics graphics, Rectangle rectangle, int n) {
        Component component = this.getHeaderRenderer(n);
        if (!(component instanceof BaseDefaultHeaderRenderer)) {
            this.paintBackground(graphics, rectangle, n);
        }
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }

    private class MyRenderComponent
    extends JLabel {
        private JTable table = null;
        private int col = 0;
        private int gv = 0;

        public MyRenderComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.table = jTable;
            this.col = n2;
            if (object != null) {
                this.setText(object.toString());
            } else {
                this.setText("");
            }
            this.setOpaque(false);
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(10);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            if (JTattooUtilities.getJavaVersion() >= 1.6) {
                RowSorter.SortKey sortKey;
                List<RowSorter.SortKey> list;
                RowSorter<? extends TableModel> rowSorter = jTable == null ? null : jTable.getRowSorter();
                List<RowSorter.SortKey> list2 = list = rowSorter == null ? null : rowSorter.getSortKeys();
                if (list != null && list.size() > 0 && (sortKey = list.get(0)).getColumn() == jTable.convertColumnIndexToModel(n2)) {
                    AbstractIconFactory abstractIconFactory = ((AbstractLookAndFeel)UIManager.getLookAndFeel()).getIconFactory();
                    if (sortKey.getSortOrder().equals((Object)SortOrder.ASCENDING)) {
                        this.setIcon(abstractIconFactory.getUpArrowIcon());
                    } else if (sortKey.getSortOrder().equals((Object)SortOrder.DESCENDING)) {
                        this.setIcon(abstractIconFactory.getDownArrowIcon());
                    }
                }
            }
            this.gv = ColorHelper.getGrayValue(AbstractLookAndFeel.getTheme().getRolloverColor());
        }

        protected void paintBackground(Graphics graphics) {
            int n = -1;
            if (BaseTableHeaderUI.this.header.getDraggedColumn() != null) {
                n = BaseTableHeaderUI.this.header.getColumnModel().getColumnIndex(BaseTableHeaderUI.this.header.getDraggedColumn().getIdentifier());
            }
            if (this.table.isEnabled() && (this.col == BaseTableHeaderUI.this.rolloverCol || this.col == n)) {
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getRolloverColors(), 0, 0, this.getWidth(), this.getHeight());
                if (BaseTableHeaderUI.this.drawRolloverBar()) {
                    graphics.setColor(AbstractLookAndFeel.getFocusColor());
                    graphics.drawLine(0, 0, this.getWidth() - 1, 0);
                    graphics.drawLine(0, 1, this.getWidth() - 1, 1);
                    graphics.drawLine(0, 2, this.getWidth() - 1, 2);
                }
            } else if (BaseTableHeaderUI.this.drawAllwaysActive() || JTattooUtilities.isFrameActive(BaseTableHeaderUI.this.header)) {
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getColHeaderColors(), 0, 0, this.getWidth(), this.getHeight());
            } else {
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getInActiveColors(), 0, 0, this.getWidth(), this.getHeight());
            }
        }

        public void paint(Graphics graphics) {
            this.paintBackground(graphics);
            if (BaseTableHeaderUI.this.rolloverCol == this.col) {
                if (this.gv > 128) {
                    this.setForeground(Color.black);
                } else {
                    this.setForeground(Color.white);
                }
            }
            super.paint(graphics);
        }
    }

    private class BaseDefaultHeaderRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return new MyRenderComponent(jTable, object, bl, bl2, n, n2);
        }
    }
}

