/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseButtonUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.mcwin.McWinLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class McWinButtonUI
extends BaseButtonUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new McWinButtonUI();
    }

    protected void paintBackground(Graphics graphics, AbstractButton abstractButton) {
        if (abstractButton.getParent() instanceof JToolBar) {
            abstractButton.setContentAreaFilled(true);
        }
        if (!abstractButton.isContentAreaFilled() || abstractButton.getParent() instanceof JMenuBar) {
            return;
        }
        int n = abstractButton.getWidth();
        int n2 = abstractButton.getHeight();
        if (!abstractButton.isBorderPainted() || !(abstractButton.getBorder() instanceof UIResource) || abstractButton.getParent() instanceof JToolBar) {
            super.paintBackground(graphics, abstractButton);
            if (abstractButton.getParent() instanceof JToolBar) {
                graphics.setColor(Color.lightGray);
                graphics.drawRect(0, 0, n - 2, n2 - 1);
                graphics.setColor(AbstractLookAndFeel.getTheme().getToolbarBackgroundColor());
                graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
            }
            return;
        }
        ButtonModel buttonModel = abstractButton.getModel();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (McWinLookAndFeel.getTheme().doDrawSquareButtons() || (n < 64 || n2 < 16) && (abstractButton.getText() == null || abstractButton.getText().length() == 0)) {
            Color[] colorArray = null;
            if (abstractButton.getBackground() instanceof ColorUIResource) {
                if (!buttonModel.isEnabled()) {
                    colorArray = McWinLookAndFeel.getTheme().getDisabledColors();
                } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    colorArray = new Color[]{McWinLookAndFeel.getTheme().getBackgroundColor()};
                } else if (buttonModel.isRollover()) {
                    colorArray = McWinLookAndFeel.getTheme().getRolloverColors();
                } else if (abstractButton.equals(abstractButton.getRootPane().getDefaultButton())) {
                    if (JTattooUtilities.isFrameActive(abstractButton)) {
                        if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && abstractButton.hasFocus()) {
                            colorArray = McWinLookAndFeel.getTheme().getFocusColors();
                        } else if (McWinLookAndFeel.getTheme().isBrightMode()) {
                            colorArray = new Color[McWinLookAndFeel.getTheme().getSelectedColors().length];
                            for (int i = 0; i < colorArray.length; ++i) {
                                colorArray[i] = ColorHelper.brighter(McWinLookAndFeel.getTheme().getSelectedColors()[i], 30.0);
                            }
                        } else {
                            colorArray = McWinLookAndFeel.getTheme().getSelectedColors();
                        }
                    } else {
                        colorArray = McWinLookAndFeel.getTheme().getButtonColors();
                    }
                } else {
                    colorArray = AbstractLookAndFeel.getTheme().doShowFocusFrame() && abstractButton.hasFocus() ? McWinLookAndFeel.getTheme().getFocusColors() : McWinLookAndFeel.getTheme().getButtonColors();
                }
            } else {
                colorArray = ColorHelper.createColorArr(ColorHelper.brighter(abstractButton.getBackground(), 20.0), ColorHelper.darker(abstractButton.getBackground(), 20.0), 20);
            }
            JTattooUtilities.fillHorGradient(graphics, colorArray, 0, 0, n - 1, n2 - 1);
            Color color = colorArray[colorArray.length / 2];
            graphics2D.setColor(ColorHelper.darker(color, 25.0));
            graphics2D.drawRect(0, 0, n - 1, n2 - 1);
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.4f);
            graphics2D.setComposite(alphaComposite);
            graphics2D.setColor(Color.white);
            graphics2D.drawRect(1, 1, n - 3, n2 - 3);
        } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
            int n3 = n2 - 2;
            ColorUIResource colorUIResource = McWinLookAndFeel.getTheme().getBackgroundColor();
            graphics2D.setColor(colorUIResource);
            graphics2D.fillRoundRect(1, 1, n - 1, n2 - 1, n3, n3);
            graphics2D.setColor(ColorHelper.darker(colorUIResource, 40.0));
            graphics2D.drawRoundRect(0, 0, n - 1, n2 - 1, n3, n3);
        } else {
            int n4 = n2 - 2;
            Color[] colorArray = null;
            colorArray = abstractButton.getBackground() instanceof ColorUIResource ? (!buttonModel.isEnabled() ? McWinLookAndFeel.getTheme().getDisabledColors() : (buttonModel.isRollover() ? McWinLookAndFeel.getTheme().getRolloverColors() : (abstractButton.equals(abstractButton.getRootPane().getDefaultButton()) ? (JTattooUtilities.isFrameActive(abstractButton) ? McWinLookAndFeel.getTheme().getSelectedColors() : McWinLookAndFeel.getTheme().getButtonColors()) : McWinLookAndFeel.getTheme().getButtonColors()))) : ColorHelper.createColorArr(ColorHelper.brighter(abstractButton.getBackground(), 20.0), ColorHelper.darker(abstractButton.getBackground(), 20.0), 20);
            Color color = colorArray[colorArray.length / 2];
            Shape shape = graphics.getClip();
            Area area = new Area(shape);
            Area area2 = new Area(new RoundRectangle2D.Double(0.0, 0.0, n - 1, n2 - 1, n4, n4));
            area2.intersect(area);
            graphics2D.setClip(area2);
            JTattooUtilities.fillHorGradient(graphics, colorArray, 0, 0, n - 1, n2 - 1);
            graphics2D.setClip(shape);
            graphics2D.setColor(ColorHelper.darker(color, 25.0));
            graphics2D.drawRoundRect(0, 0, n - 1, n2 - 1, n4, n4);
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.6f);
            graphics2D.setComposite(alphaComposite);
            graphics2D.setColor(Color.white);
            graphics2D.drawRoundRect(1, 1, n - 3, n2 - 3, n4 - 2, n4 - 2);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setComposite(composite);
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = abstractButton.getWidth();
        int n2 = abstractButton.getHeight();
        if (McWinLookAndFeel.getTheme().doDrawSquareButtons() || !abstractButton.isContentAreaFilled() || (n < 64 || n2 < 16) && (abstractButton.getText() == null || abstractButton.getText().length() == 0)) {
            graphics.setColor(AbstractLookAndFeel.getFocusColor());
            BasicGraphicsUtils.drawDashedRect(graphics, 4, 3, n - 8, n2 - 6);
        } else {
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(AbstractLookAndFeel.getFocusColor());
            int n3 = abstractButton.getHeight() - 4;
            graphics2D.drawRoundRect(2, 2, abstractButton.getWidth() - 5, abstractButton.getHeight() - 5, n3, n3);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }
}

