/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseInternalFrameTitlePane;
import com.jtattoo.plaf.BaseTitleButton;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.mcwin.McWinLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class McWinInternalFrameTitlePane
extends BaseInternalFrameTitlePane {
    public McWinInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected LayoutManager createLayout() {
        return new MyTitlePaneLayout();
    }

    protected void createButtons() {
        this.iconButton = new BaseTitleButton(this.iconifyAction, "Iconify", this.iconIcon, 1.0f);
        this.maxButton = new BaseTitleButton(this.maximizeAction, "Maximize", this.maxIcon, 1.0f);
        this.closeButton = new BaseTitleButton(this.closeAction, "Close", this.closeIcon, 1.0f);
        this.setButtonIcons();
    }

    public void paintBorder(Graphics graphics) {
        if (JTattooUtilities.isActive(this)) {
            graphics.setColor(McWinLookAndFeel.getWindowBorderColor());
        } else {
            graphics.setColor(McWinLookAndFeel.getWindowInactiveBorderColor());
        }
        graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintText(Graphics graphics, int n, int n2, String string) {
        if (this.isActive()) {
            graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getWindowTitleColorLight(), 40.0));
            JTattooUtilities.drawString(this.frame, graphics, string, n, n2 + 1);
            graphics.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
            JTattooUtilities.drawString(this.frame, graphics, string, n, n2);
        } else {
            graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getWindowInactiveTitleColorLight(), 40.0));
            JTattooUtilities.drawString(this.frame, graphics, string, n, n2 + 1);
            graphics.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
            JTattooUtilities.drawString(this.frame, graphics, string, n, n2);
        }
    }

    class MyTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        MyTitlePaneLayout() {
            super(McWinInternalFrameTitlePane.this);
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public Dimension minimumLayoutSize(Container container) {
            int n;
            int n2;
            int n3 = 30;
            if (McWinInternalFrameTitlePane.this.frame.isClosable()) {
                n3 += 21;
            }
            if (McWinInternalFrameTitlePane.this.frame.isMaximizable()) {
                n3 += 16 + (McWinInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
            }
            if (McWinInternalFrameTitlePane.this.frame.isIconifiable()) {
                n3 += 16 + (McWinInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (McWinInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4));
            }
            FontMetrics fontMetrics = McWinInternalFrameTitlePane.this.getFontMetrics(McWinInternalFrameTitlePane.this.getFont());
            String string = McWinInternalFrameTitlePane.this.frame.getTitle();
            int n4 = string != null ? fontMetrics.stringWidth(string) : 0;
            int n5 = n2 = string != null ? string.length() : 0;
            n3 = n2 > 2 ? (n3 += n4 < (n = fontMetrics.stringWidth(McWinInternalFrameTitlePane.this.frame.getTitle().substring(0, 2) + "...")) ? n4 : n) : (n3 += n4);
            n = McWinInternalFrameTitlePane.this.paletteTitleHeight;
            if (!McWinInternalFrameTitlePane.this.isPalette) {
                int n6 = fontMetrics.getHeight() + 7;
                Icon icon = McWinInternalFrameTitlePane.this.frame.getFrameIcon();
                int n7 = 0;
                if (icon != null) {
                    n7 = Math.min(icon.getIconHeight(), 18);
                }
                n = Math.max(n6, n7 += 5);
            }
            return new Dimension(n3, n);
        }

        public void layoutContainer(Container container) {
            boolean bl = JTattooUtilities.isLeftToRight(McWinInternalFrameTitlePane.this.frame);
            int n = McWinInternalFrameTitlePane.this.getWidth();
            int n2 = McWinInternalFrameTitlePane.this.getHeight();
            int n3 = 4;
            int n4 = 26;
            if (n2 <= 23) {
                n3 = 2;
                n4 = 18;
            } else if (n2 <= 26) {
                n3 = 3;
                n4 = 22;
            } else {
                n3 = 4;
                n4 = 26;
            }
            int n5 = n4;
            int n6 = bl ? n - n3 : 0;
            int n7 = Math.max(0, (n2 - n4) / 2 - 1);
            if (McWinInternalFrameTitlePane.this.frame.isClosable()) {
                McWinInternalFrameTitlePane.this.closeButton.setBounds(n6 += bl ? -n5 : n3, n7, n5, n4);
                if (!bl) {
                    n6 += n5;
                }
            }
            if (McWinInternalFrameTitlePane.this.frame.isMaximizable() && !McWinInternalFrameTitlePane.this.isPalette) {
                McWinInternalFrameTitlePane.this.maxButton.setBounds(n6 += bl ? -n3 - n5 : n3, n7, n5, n4);
                if (!bl) {
                    n6 += n5;
                }
            }
            if (McWinInternalFrameTitlePane.this.frame.isIconifiable() && !McWinInternalFrameTitlePane.this.isPalette) {
                McWinInternalFrameTitlePane.this.iconButton.setBounds(n6 += bl ? -n3 - n5 : n3, n7, n5, n4);
                if (!bl) {
                    n6 += n5;
                }
            }
            McWinInternalFrameTitlePane.this.buttonsWidth = bl ? n - n6 : n6;
        }
    }
}

