/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.smart;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitleButton;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.DecorationHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.smart.SmartLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;

public class SmartTitlePane
extends BaseTitlePane {
    public SmartTitlePane(JRootPane jRootPane, BaseRootPaneUI baseRootPaneUI) {
        super(jRootPane, baseRootPaneUI);
    }

    public void createButtons() {
        this.iconifyButton = new BaseTitleButton(this.iconifyAction, "Iconify", this.iconifyIcon, 1.0f);
        this.maxButton = new BaseTitleButton(this.restoreAction, "Maximize", this.maximizeIcon, 1.0f);
        this.closeButton = new BaseTitleButton(this.closeAction, "Close", this.closeIcon, 1.0f);
    }

    public void paintBorder(Graphics graphics) {
        if (this.isActive()) {
            graphics.setColor(AbstractLookAndFeel.getTheme().getFrameColor());
        } else {
            graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 40.0));
        }
        graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        String string;
        int n3;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getFrame() != null) {
            this.setState(DecorationHelper.getExtendedState(this.getFrame()));
        }
        this.paintBackground(graphics);
        boolean bl = this.window == null ? this.getRootPane().getComponentOrientation().isLeftToRight() : this.window.getComponentOrientation().isLeftToRight();
        boolean bl2 = this.window == null ? true : JTattooUtilities.isWindowActive(this.window);
        ColorUIResource colorUIResource = AbstractLookAndFeel.getWindowInactiveTitleForegroundColor();
        Color color = SmartLookAndFeel.getTheme().getWindowInactiveTitleColors()[10];
        if (bl2) {
            colorUIResource = AbstractLookAndFeel.getWindowTitleForegroundColor();
            color = SmartLookAndFeel.getTheme().getWindowTitleColors()[10];
        }
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        int n6 = n4 - this.buttonsWidth - 4;
        int n7 = n3 = bl ? 2 : n4 - 2;
        if (this.getWindowDecorationStyle() == 1) {
            int n8 = this.menuBar.getWidth() + 2;
            n3 += bl ? n8 : -n8;
            n6 -= n5;
        }
        if ((string = this.getTitle()) != null) {
            int n9;
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.setColor(colorUIResource);
            n2 = (n5 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent() - 1;
            Rectangle rectangle = this.iconifyButton.getBounds();
            if (bl) {
                if (rectangle.x == 0) {
                    rectangle.x = this.window.getWidth() - this.window.getInsets().right - 2;
                }
                n9 = rectangle.x - n3 - 4;
                string = JTattooUtilities.getClippedText(string, fontMetrics, n9);
            } else {
                n9 = n3 - rectangle.x - rectangle.width - 4;
                string = JTattooUtilities.getClippedText(string, fontMetrics, n9);
                n3 -= SwingUtilities.computeStringWidth(fontMetrics, string);
            }
            int n10 = SwingUtilities.computeStringWidth(fontMetrics, string);
            if (ColorHelper.getGrayValue(colorUIResource) > 164) {
                graphics.setColor(Color.black);
                JTattooUtilities.drawString(this.rootPane, graphics, string, n3 + 1, n2 + 1);
            }
            graphics.setColor(colorUIResource);
            JTattooUtilities.drawString(this.rootPane, graphics, string, n3, n2);
            n3 += bl ? n10 + 5 : -5;
        }
        if (bl) {
            n2 = n4 - this.buttonsWidth - n3 - 10;
            n = n3;
        } else {
            n2 = n3 - this.buttonsWidth - 10;
            n = this.buttonsWidth + 10;
        }
        int n11 = 3;
        if (n2 > 0) {
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.6f);
            graphics2D.setComposite(alphaComposite);
            float f = 50.0f;
            float f2 = 5.0f;
            Color color2 = ColorHelper.brighter(color, f);
            Color color3 = null;
            while (n11 + 5 < n5) {
                color3 = ColorHelper.darker(color, f2);
                f2 += 5.0f;
                graphics.setColor(color2);
                graphics.drawLine(n, n11, n + n2, n11);
                graphics.setColor(color3);
                graphics.drawLine(n, ++n11, n + n2, n11);
                n11 += 3;
            }
            graphics2D.setComposite(composite);
        }
    }
}

