/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.graph;

public final class Path {
    private Path parentPath;
    private Object elem;
    private int index;
    public boolean lastElem = false;

    public Path(Object elem) {
        if (elem == null) {
            throw new IllegalArgumentException("element in path must be non null");
        }
        this.elem = elem;
        this.index = 0;
    }

    private Path(Path parentPath, Object elem, int index) {
        this.parentPath = parentPath;
        this.elem = elem;
        this.index = index;
    }

    public Path append(Object elem) {
        return this.append(elem, -1);
    }

    public Path append(Object elem, int index) {
        if (elem == null) {
            throw new IllegalArgumentException("element in path must be non null");
        }
        return new Path(this, elem, index);
    }

    public Path getParentPath() {
        return this.parentPath;
    }

    public Path getParentPath(Class clazz) {
        Path path = this;
        while ((path = path.parentPath) != null && !clazz.isInstance(path.elem)) {
        }
        return path;
    }

    public Object getElement() {
        return this.elem;
    }

    public int getIndex() {
        return this.index;
    }

    public Object getElement(int i) {
        if (i < 0) {
            throw new IndexOutOfBoundsException("negative index: " + i);
        }
        int len = this.getLength();
        if (i >= len) {
            throw new IndexOutOfBoundsException(String.format("index %d is out of range", i));
        }
        --len;
        Path path = this;
        while (len != i) {
            path = path.parentPath;
        }
        return path.elem;
    }

    public int getLength() {
        int len = 0;
        Path path = this;
        while (path != null) {
            ++len;
            path = path.parentPath;
        }
        return len;
    }

    public Object[] toArray() {
        Object[] array = new Object[this.getLength()];
        Path path = this;
        for (int i = this.getLength(); i > 0; --i) {
            array[--i] = path.elem;
            path = path.parentPath;
        }
        return array;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        Path path = this;
        while (path != null) {
            if (buff.length() > 0) {
                buff.insert(0, ", ");
            }
            buff.insert(0, path.elem.toString());
            path = path.parentPath;
        }
        return buff.toString();
    }
}

