/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import jlibs.core.io.BOM;
import jlibs.core.io.IOUtil;

public class UnicodeInputStream
extends FilterInputStream {
    public final boolean hasBOM;
    public final BOM bom;
    private byte[] marker = new byte[4];
    private int imarker;

    public UnicodeInputStream(InputStream delegate) throws IOException {
        super(delegate);
        int len = IOUtil.readFully(delegate, this.marker);
        BOM bom = null;
        if (len == 4) {
            bom = BOM.get(this.marker, true);
            if (bom != null) {
                this.imarker = bom.with().length;
            } else {
                bom = BOM.get(this.marker, false);
            }
        }
        this.bom = bom;
        this.hasBOM = this.imarker > 0;
    }

    @Override
    public int read() throws IOException {
        if (this.marker != null) {
            byte b = this.marker[this.imarker++];
            if (this.imarker == this.marker.length) {
                this.marker = null;
            }
            return b;
        }
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = 0;
        while (this.marker != null && len > 0) {
            b[off] = (byte)this.read();
            ++off;
            --len;
            ++read;
        }
        int r = super.read(b, off, len);
        if (read == 0) {
            return r;
        }
        return r == -1 ? read : read + r;
    }
}

