/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import com.sun.nfs.Buffer;
import com.sun.nfs.Fattr;
import com.sun.nfs.Fattr2;
import com.sun.nfs.Nfs;
import com.sun.nfs.NfsConnect;
import com.sun.nfs.NfsException;
import com.sun.nfs.NfsSecurity;
import com.sun.rpc.CredGss;
import com.sun.rpc.CredUnix;
import com.sun.rpc.MsgRejectedException;
import com.sun.rpc.Rpc;
import com.sun.rpc.Xdr;
import java.io.IOException;

public class Nfs2
extends Nfs {
    Fattr2 attr;
    private static final int NFSPROC2_NULL = 0;
    private static final int NFSPROC2_GETATTR = 1;
    private static final int NFSPROC2_SETATTR = 2;
    private static final int NFSPROC2_LOOKUP = 4;
    private static final int NFSPROC2_READLINK = 5;
    private static final int NFSPROC2_READ = 6;
    private static final int NFSPROC2_WRITE = 8;
    private static final int NFSPROC2_CREATE = 9;
    private static final int NFSPROC2_REMOVE = 10;
    private static final int NFSPROC2_RENAME = 11;
    private static final int NFSPROC2_LINK = 12;
    private static final int NFSPROC2_SYMLINK = 13;
    private static final int NFSPROC2_MKDIR = 14;
    private static final int NFSPROC2_RMDIR = 15;
    private static final int NFSPROC2_READDIR = 16;
    private static final int NFSPROC2_STATFS = 17;
    private static final int NFS_OK = 0;
    private static final int RWSIZE = 8192;
    private static final int FHSIZE = 32;
    int nwb;

    public Nfs2(Rpc rpc2, byte[] byArray, String string, Fattr2 fattr2) {
        this.rpc = rpc2;
        this.fh = byArray;
        if (string.startsWith("./")) {
            string = string.substring(2);
        }
        this.name = string;
        this.attr = fattr2 == null ? new Fattr2() : fattr2;
        this.rsize = 8192;
        this.NRA = 2;
        this.NWB = 8;
    }

    boolean cacheOK(long l) throws IOException {
        this.checkAttr();
        return l == this.attr.mtime;
    }

    boolean canRead() throws IOException {
        this.checkAttr();
        return this.check_access(4L);
    }

    boolean canWrite() throws IOException {
        this.checkAttr();
        return this.check_access(2L);
    }

    void checkAttr() throws IOException {
        if (!this.attr.valid()) {
            this.getattr();
        }
    }

    private boolean check_access(long l) {
        boolean bl = false;
        long l2 = NfsConnect.getCred().getUid();
        long l3 = NfsConnect.getCred().getGid();
        int[] nArray = NfsConnect.getCred().getGids();
        l <<= 6;
        if (l2 != this.attr.uid) {
            l >>= 3;
            if (l3 != this.attr.gid) {
                int n = 0;
                if (nArray != null) {
                    n = nArray.length;
                }
                int n2 = 0;
                while (n2 < n) {
                    bl = (long)nArray[n2] == this.attr.gid;
                    if (bl) break;
                    ++n2;
                }
                if (!bl) {
                    l >>= 3;
                }
            }
        }
        return (this.attr.mode & l) == l;
    }

    long commit(int n, int n2) throws IOException {
        return 0L;
    }

    Nfs create(String string, long l) throws IOException {
        return this.create_otw(9, string, l);
    }

    private Nfs create_otw(int n, String string, long l) throws IOException {
        long l2 = System.currentTimeMillis();
        Xdr xdr = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(xdr, n);
        xdr.xdr_raw(this.fh);
        xdr.xdr_string(string);
        xdr.xdr_u_int(l);
        xdr.xdr_u_int(NfsConnect.getCred().getUid());
        xdr.xdr_u_int(NfsConnect.getCred().getGid());
        xdr.xdr_u_int(0L);
        xdr.xdr_u_int(l2 / 1000L);
        xdr.xdr_u_int(l2 % 1000L);
        xdr.xdr_u_int(l2 / 1000L);
        xdr.xdr_u_int(l2 % 1000L);
        Xdr xdr2 = this.rpc.rpc_call(xdr, 2000, 0);
        int n2 = xdr2.xdr_int();
        if (n2 != 0) {
            throw new NfsException(n2);
        }
        byte[] byArray = xdr2.xdr_raw(32);
        Fattr2 fattr2 = new Fattr2(xdr2);
        String string2 = String.valueOf(this.name) + "/" + string;
        Nfs2 nfs2 = new Nfs2(this.rpc, byArray, string2, fattr2);
        Nfs.cache_put(nfs2);
        this.dircache = null;
        return nfs2;
    }

    boolean exists() throws IOException {
        this.checkAttr();
        return true;
    }

    void fsinfo() throws IOException {
        this.wsize = 8192;
    }

    Fattr getAttr() throws IOException {
        this.checkAttr();
        return this.attr;
    }

    void getattr() throws IOException {
        Xdr xdr;
        Xdr xdr2 = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(xdr2, 1);
        xdr2.xdr_raw(this.fh);
        try {
            xdr = this.rpc.rpc_call(xdr2, 2000, 2);
        }
        catch (IOException iOException) {
            return;
        }
        int n = xdr.xdr_int();
        if (n != 0) {
            throw new NfsException(n);
        }
        this.attr.getFattr(xdr);
    }

    void invalidate() {
        this.attr.validtime = 0L;
    }

    boolean isDirectory() throws IOException {
        this.checkAttr();
        return this.attr.ftype == 2;
    }

    boolean isFile() throws IOException {
        this.checkAttr();
        return this.attr.ftype == 1;
    }

    boolean isSymlink() throws IOException {
        this.checkAttr();
        return this.attr.ftype == 5;
    }

    long length() throws IOException {
        this.checkAttr();
        return this.maxLength > this.attr.size ? this.maxLength : this.attr.size;
    }

    /*
     * Unable to fully structure code
     */
    Nfs lookup(String var1_1) throws IOException {
        if (var1_1 == null) {
            var5_2 = this.name;
            var1_1 = this.name;
        } else {
            var5_2 = this.name == null ? var1_1 : String.valueOf(this.name) + "/" + var1_1;
        }
        var4_3 = Nfs.cache_get(this.rpc.conn.server, var5_2);
        if (var4_3 != null && var4_3.cacheOK(this.cacheTime)) {
            if (((Nfs2)var4_3).attr.ftype == 5) {
                var4_3 = NfsConnect.followLink(var4_3);
            }
            return var4_3;
        }
        var6_4 = new Xdr(this.rsize + 512);
        var7_5 = null;
        var8_6 = 1;
        while (var8_6 >= 0) {
            this.rpc.rpc_header(var6_4, 4);
            var6_4.xdr_raw(this.fh);
            var6_4.xdr_string(var1_1);
            try {
                var7_5 = this.rpc.rpc_call(var6_4, 5000, 0);
                break;
            }
            catch (MsgRejectedException var9_7) {
                var10_10 = true;
                var11_11 = 0;
                ** while (var11_11 < 32)
            }
lbl-1000:
            // 1 sources

            {
                if (this.fh[var11_11] != 0) {
                    var10_10 = false;
                    break;
                }
                ++var11_11;
                continue;
            }
lbl30:
            // 2 sources

            if (!var10_10 || var9_7.why != 5) ** GOTO lbl-1000
            var12_12 = this.lookupSec();
            if (var12_12 != null && NfsSecurity.getMech(var12_12) != null) {
                this.rpc.setCred(new CredGss("nfs", NfsSecurity.getMech(var12_12), NfsSecurity.getService(var12_12), NfsSecurity.getQop(var12_12)));
            } else if (var12_12 != null && var12_12.equals("1")) {
                this.rpc.setCred(new CredUnix());
            } else lbl-1000:
            // 2 sources

            {
                throw var9_7;
                catch (IOException var9_8) {
                    throw var9_8;
                }
            }
            --var8_6;
        }
        var9_9 = var7_5.xdr_int();
        if (var9_9 != 0) {
            throw new NfsException(var9_9);
        }
        var2_13 = var7_5.xdr_raw(32);
        var3_14 = new Fattr2(var7_5);
        var4_3 = new Nfs2(this.rpc, var2_13, var5_2, var3_14);
        Nfs.cache_put(var4_3);
        if (((Nfs2)var4_3).attr.ftype == 5) {
            var4_3 = NfsConnect.followLink(var4_3);
        }
        return var4_3;
    }

    public String lookupSec() throws IOException {
        int n = 1;
        boolean bl = false;
        String string = null;
        Xdr xdr = new Xdr(this.rsize + 512);
        do {
            this.rpc.rpc_header(xdr, 4);
            xdr.xdr_raw(new byte[32]);
            int n2 = this.name.getBytes().length + 2;
            byte[] byArray = new byte[n2];
            byArray[0] = -127;
            byArray[1] = (byte)n;
            System.arraycopy(this.name.getBytes(), 0, byArray, 2, this.name.getBytes().length);
            xdr.xdr_bytes(byArray);
            Xdr xdr2 = this.rpc.rpc_call(xdr, 5000, 3);
            int n3 = xdr2.xdr_int();
            if (n3 != 0) {
                return NfsSecurity.getDefault();
            }
            byte[] byArray2 = xdr2.xdr_raw(4);
            int n4 = byArray2[0] / 4;
            if (byArray2[1] == 0) {
                bl = false;
            } else {
                bl = true;
                n += n4;
            }
            String string2 = NfsSecurity.getPrefer();
            while (n4-- > 0) {
                String string3 = Integer.toString(xdr2.xdr_int());
                if (string2 != null && string2.equals(string3)) {
                    return string2;
                }
                if (string != null || !NfsSecurity.hasValue(string3)) continue;
                string = string3;
            }
        } while (bl);
        return string;
    }

    Nfs mkdir(String string, long l) throws IOException {
        return this.create_otw(14, string, l);
    }

    long mtime() throws IOException {
        this.checkAttr();
        return this.attr.mtime;
    }

    void read_otw(Buffer buffer) throws IOException {
        Xdr xdr = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(xdr, 6);
        xdr.xdr_raw(this.fh);
        xdr.xdr_u_int(buffer.foffset);
        xdr.xdr_u_int(this.rsize);
        xdr.xdr_u_int(this.rsize);
        Xdr xdr2 = this.rpc.rpc_call(xdr, 1000, 0);
        int n = xdr2.xdr_int();
        if (n != 0) {
            throw new NfsException(n);
        }
        this.attr.getFattr(xdr2);
        int n2 = xdr2.xdr_int();
        buffer.eof = buffer.foffset + (long)this.rsize >= this.attr.size;
        buffer.buf = xdr2.xdr_buf();
        buffer.bufoff = xdr2.xdr_offset();
        buffer.buflen = n2;
        this.cacheTime = this.attr.mtime;
    }

    /*
     * Unable to fully structure code
     */
    String[] readdir() throws IOException {
        var1_1 = 0L;
        var3_2 = false;
        var4_3 = new String[32];
        var6_4 = 0;
        if (this.dircache != null && this.cacheOK(this.cacheTime)) {
            return this.dircache;
        }
        var7_5 = new Xdr(this.rsize + 512);
        while (!var3_2) {
            this.rpc.rpc_header(var7_5, 16);
            var7_5.xdr_raw(this.fh);
            var7_5.xdr_u_int(var1_1);
            var7_5.xdr_u_int(4096L);
            var8_7 = this.rpc.rpc_call(var7_5, 2000, 0);
            var9_8 = var8_7.xdr_int();
            if (var9_8 == 0) ** GOTO lbl27
            throw new NfsException(var9_8);
lbl-1000:
            // 1 sources

            {
                var8_7.xdr_u_int();
                var5_6 = var8_7.xdr_string();
                var1_1 = var8_7.xdr_u_int();
                if (var5_6.equals(".") || var5_6.equals("..")) continue;
                var4_3[var6_4++] = var5_6;
                if (var6_4 < var4_3.length) continue;
                var10_9 = var4_3;
                var4_3 = new String[var6_4 * 2];
                System.arraycopy(var10_9, 0, var4_3, 0, var6_4);
lbl27:
                // 4 sources

                ** while (var8_7.xdr_bool())
            }
lbl28:
            // 1 sources

            var3_2 = var8_7.xdr_bool();
        }
        if (var6_4 < var4_3.length) {
            var8_7 = var4_3;
            var4_3 = new String[var6_4];
            System.arraycopy(var8_7, 0, var4_3, 0, var6_4);
        }
        this.dircache = var4_3;
        this.cacheTime = this.attr.mtime;
        return var4_3;
    }

    String readlink() throws IOException {
        if (this.symlink != null && this.cacheOK(this.cacheTime)) {
            return this.symlink;
        }
        Xdr xdr = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(xdr, 5);
        xdr.xdr_raw(this.fh);
        Xdr xdr2 = this.rpc.rpc_call(xdr, 2000, 0);
        int n = xdr2.xdr_int();
        if (n != 0) {
            throw new NfsException(n);
        }
        this.symlink = xdr2.xdr_string();
        this.cacheTime = this.attr.mtime;
        return this.symlink;
    }

    boolean remove(String string) throws IOException {
        return this.remove_otw(10, string);
    }

    private boolean remove_otw(int n, String string) throws IOException {
        Xdr xdr = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(xdr, n);
        xdr.xdr_raw(this.fh);
        xdr.xdr_string(string);
        Xdr xdr2 = this.rpc.rpc_call(xdr, 2000, 0);
        int n2 = xdr2.xdr_int();
        if (n2 != 0) {
            throw new NfsException(n2);
        }
        Nfs.cache_remove(this, string);
        this.dircache = null;
        return true;
    }

    boolean rename(Nfs nfs, String string, String string2) throws IOException {
        Xdr xdr = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(xdr, 11);
        xdr.xdr_raw(this.fh);
        xdr.xdr_string(string);
        xdr.xdr_raw(nfs.getFH());
        xdr.xdr_string(string2);
        Xdr xdr2 = this.rpc.rpc_call(xdr, 2000, 0);
        int n = xdr2.xdr_int();
        if (n != 0) {
            throw new NfsException(n);
        }
        Nfs.cache_remove(this, string);
        this.dircache = null;
        nfs.dircache = null;
        return true;
    }

    boolean rmdir(String string) throws IOException {
        return this.remove_otw(15, string);
    }

    int write_otw(Buffer buffer) throws IOException {
        Xdr xdr = new Xdr(this.wsize + 512);
        int n = (int)buffer.foffset + buffer.minOffset;
        int n2 = buffer.maxOffset - buffer.minOffset;
        this.rpc.rpc_header(xdr, 8);
        xdr.xdr_raw(this.fh);
        xdr.xdr_u_int(n);
        xdr.xdr_u_int(n);
        xdr.xdr_u_int(n2);
        xdr.xdr_bytes(buffer.buf, buffer.bufoff + buffer.minOffset, n2);
        Xdr xdr2 = this.rpc.rpc_call(xdr, 2000, 0);
        int n3 = xdr2.xdr_int();
        if (n3 != 0) {
            throw new NfsException(n3);
        }
        this.attr.getFattr(xdr2);
        buffer.status = 1;
        buffer.writeVerifier = 0L;
        this.cacheTime = this.attr.mtime;
        return n2;
    }
}

