/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.net;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import net.sf.jftp.config.Settings;
import net.sf.jftp.system.logging.Log;

public class JConnection
implements Runnable {
    private int timeout = 30000;
    private String host;
    private int port;
    private PrintStream out;
    private BufferedReader in;
    private Socket s;
    private boolean isOk = false;
    private boolean established = false;
    private Thread runner;
    private int localPort = -1;

    public JConnection(String host, int port) {
        this.host = host;
        this.port = port;
        this.runner = new Thread(this);
        this.runner.start();
    }

    @Override
    public void run() {
        try {
            this.s = new Socket(this.host, this.port);
            this.localPort = this.s.getLocalPort();
            this.out = new PrintStream(new BufferedOutputStream(this.s.getOutputStream(), Settings.bufferSize));
            this.in = new BufferedReader(new InputStreamReader(this.s.getInputStream()), Settings.bufferSize);
            this.isOk = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.out("WARNING: connection closed due to exception (" + this.host + ":" + this.port + ")");
            this.isOk = false;
            try {
                if (this.s != null && !this.s.isClosed()) {
                    this.s.close();
                }
                if (this.out != null) {
                    this.out.close();
                }
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
                Log.out("WARNING: got more errors trying to close socket and streams");
            }
        }
        this.established = true;
    }

    public boolean isThere() {
        for (int cnt = 0; !this.established && cnt < this.timeout; cnt += 10) {
            this.pause(10);
        }
        return this.isOk;
    }

    public void send(String data) {
        try {
            this.out.print(data);
            this.out.print("\r\n");
            this.out.flush();
            if (data.startsWith("PASS")) {
                Log.debug("> PASS ****");
            } else {
                Log.debug("> " + data);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public PrintStream getInetOutputStream() {
        return this.out;
    }

    public BufferedReader getReader() {
        return this.in;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public InetAddress getLocalAddress() throws IOException {
        return this.s.getLocalAddress();
    }

    private void pause(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BufferedReader getIn() {
        return this.in;
    }

    public void setIn(BufferedReader in) {
        this.in = in;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }
}

