/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.httpclient.ChunkedOutputStream;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpConstants;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.Wire;
import org.apache.commons.httpclient.WireLogOutputStream;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.httpclient.util.TimeoutController;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpConnection {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$HttpConnection == null ? (class$org$apache$commons$httpclient$HttpConnection = HttpConnection.class$("org.apache.commons.httpclient.HttpConnection")) : class$org$apache$commons$httpclient$HttpConnection);
    private boolean used = false;
    private String hostName = null;
    private String virtualName = null;
    private int portNumber = -1;
    private String proxyHostName = null;
    private int proxyPortNumber = -1;
    private Socket socket = null;
    private PushbackInputStream inputStream = null;
    private OutputStream outputStream = null;
    private int sendBufferSize = -1;
    private InputStream lastResponseInputStream = null;
    protected boolean isOpen = false;
    private Protocol protocolInUse;
    private int soTimeout = 0;
    private boolean soNodelay = true;
    private boolean usingSecureSocket = false;
    private boolean tunnelEstablished = false;
    private boolean staleCheckingEnabled = true;
    private int connectTimeout = 0;
    private HttpConnectionManager httpConnectionManager;
    private InetAddress localAddress;
    static /* synthetic */ Class class$org$apache$commons$httpclient$HttpConnection;

    public HttpConnection(String host, int port) {
        this(null, -1, host, port, false);
    }

    public HttpConnection(String host, int port, boolean secure) {
        this(null, -1, host, port, secure);
    }

    public HttpConnection(String host, int port, Protocol protocol) {
        this(null, -1, host, null, port, protocol);
    }

    public HttpConnection(String host, String virtualHost, int port, Protocol protocol) {
        this(null, -1, host, virtualHost, port, protocol);
    }

    public HttpConnection(String proxyHost, int proxyPort, String host, int port) {
        this(proxyHost, proxyPort, host, port, false);
    }

    public HttpConnection(String proxyHost, int proxyPort, String host, int port, boolean secure) {
        this(proxyHost, proxyPort, host, null, port, Protocol.getProtocol(secure ? "https" : "http"));
    }

    public HttpConnection(HostConfiguration hostConfiguration) {
        this(hostConfiguration.getProxyHost(), hostConfiguration.getProxyPort(), hostConfiguration.getHost(), hostConfiguration.getVirtualHost(), hostConfiguration.getPort(), hostConfiguration.getProtocol());
        this.localAddress = hostConfiguration.getLocalAddress();
    }

    public HttpConnection(String proxyHost, int proxyPort, String host, String virtualHost, int port, Protocol protocol) {
        if (host == null) {
            throw new IllegalArgumentException("host parameter is null");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("protocol is null");
        }
        this.proxyHostName = proxyHost;
        this.proxyPortNumber = proxyPort;
        this.hostName = host;
        this.virtualName = virtualHost;
        this.portNumber = protocol.resolvePort(port);
        this.protocolInUse = protocol;
    }

    public String getHost() {
        return this.hostName;
    }

    public void setHost(String host) throws IllegalStateException {
        if (host == null) {
            throw new IllegalArgumentException("host parameter is null");
        }
        this.assertNotOpen();
        this.hostName = host;
    }

    public String getVirtualHost() {
        return this.virtualName;
    }

    public void setVirtualHost(String host) throws IllegalStateException {
        this.assertNotOpen();
        this.virtualName = host;
    }

    public int getPort() {
        if (this.portNumber < 0) {
            return this.isSecure() ? 443 : 80;
        }
        return this.portNumber;
    }

    public void setPort(int port) throws IllegalStateException {
        this.assertNotOpen();
        this.portNumber = port;
    }

    public String getProxyHost() {
        return this.proxyHostName;
    }

    public void setProxyHost(String host) throws IllegalStateException {
        this.assertNotOpen();
        this.proxyHostName = host;
    }

    public int getProxyPort() {
        return this.proxyPortNumber;
    }

    public void setProxyPort(int port) throws IllegalStateException {
        this.assertNotOpen();
        this.proxyPortNumber = port;
    }

    public boolean isSecure() {
        return this.protocolInUse.isSecure();
    }

    public Protocol getProtocol() {
        return this.protocolInUse;
    }

    public void setSecure(boolean secure) throws IllegalStateException {
        this.assertNotOpen();
        this.protocolInUse = secure ? Protocol.getProtocol("https") : Protocol.getProtocol("http");
    }

    public void setProtocol(Protocol protocol) {
        this.assertNotOpen();
        if (protocol == null) {
            throw new IllegalArgumentException("protocol is null");
        }
        this.protocolInUse = protocol;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(InetAddress localAddress) {
        this.assertNotOpen();
        this.localAddress = localAddress;
    }

    public boolean isOpen() {
        if (this.used && this.isStaleCheckingEnabled() && this.isStale()) {
            LOG.debug("Connection is stale, closing...");
            this.close();
        }
        return this.isOpen;
    }

    public boolean isStaleCheckingEnabled() {
        return this.staleCheckingEnabled;
    }

    public void setStaleCheckingEnabled(boolean staleCheckEnabled) {
        this.staleCheckingEnabled = staleCheckEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isStale() {
        boolean isStale;
        block9: {
            isStale = true;
            if (this.isOpen) {
                isStale = false;
                try {
                    if (this.inputStream.available() != 0) break block9;
                    try {
                        this.socket.setSoTimeout(1);
                        int byteRead = this.inputStream.read();
                        if (byteRead == -1) {
                            isStale = true;
                        } else {
                            this.inputStream.unread(byteRead);
                        }
                    }
                    finally {
                        this.socket.setSoTimeout(this.soTimeout);
                    }
                }
                catch (InterruptedIOException e) {
                }
                catch (IOException e) {
                    LOG.debug("An error occurred while reading from the socket, is appears to be stale", e);
                    isStale = true;
                }
            }
        }
        return isStale;
    }

    public boolean isProxied() {
        return null != this.proxyHostName && 0 < this.proxyPortNumber;
    }

    public void setLastResponseInputStream(InputStream inStream) {
        this.lastResponseInputStream = inStream;
    }

    public InputStream getLastResponseInputStream() {
        return this.lastResponseInputStream;
    }

    public void setSoTimeout(int timeout) throws SocketException, IllegalStateException {
        LOG.debug("HttpConnection.setSoTimeout(" + timeout + ")");
        this.soTimeout = timeout;
        if (this.socket != null) {
            this.socket.setSoTimeout(timeout);
        }
    }

    public int getSoTimeout() throws SocketException {
        LOG.debug("HttpConnection.getSoTimeout()");
        if (this.socket != null) {
            return this.socket.getSoTimeout();
        }
        return this.soTimeout;
    }

    public void setConnectionTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    public void open() throws IOException {
        LOG.trace("enter HttpConnection.open()");
        this.assertNotOpen();
        try {
            if (null == this.socket) {
                ProtocolSocketFactory socketFactory;
                final String host = null == this.proxyHostName ? this.hostName : this.proxyHostName;
                final int port = null == this.proxyHostName ? this.portNumber : this.proxyPortNumber;
                this.usingSecureSocket = this.isSecure() && !this.isProxied();
                ProtocolSocketFactory protocolSocketFactory = socketFactory = this.isSecure() && this.isProxied() ? new DefaultProtocolSocketFactory() : this.protocolInUse.getSocketFactory();
                if (this.connectTimeout == 0) {
                    this.socket = this.localAddress != null ? socketFactory.createSocket(host, port, this.localAddress, 0) : socketFactory.createSocket(host, port);
                } else {
                    SocketTask task = new SocketTask(){

                        public void doit() throws IOException {
                            if (HttpConnection.this.localAddress != null) {
                                this.setSocket(socketFactory.createSocket(host, port, HttpConnection.this.localAddress, 0));
                            } else {
                                this.setSocket(socketFactory.createSocket(host, port));
                            }
                        }
                    };
                    TimeoutController.execute(task, (long)this.connectTimeout);
                    this.socket = task.getSocket();
                    if (task.exception != null) {
                        throw task.exception;
                    }
                }
            }
            this.socket.setTcpNoDelay(this.soNodelay);
            this.socket.setSoTimeout(this.soTimeout);
            if (this.sendBufferSize != -1) {
                this.socket.setSendBufferSize(this.sendBufferSize);
            }
            this.inputStream = new PushbackInputStream(this.socket.getInputStream());
            this.outputStream = new BufferedOutputStream(new WrappedOutputStream(this.socket.getOutputStream()), this.socket.getSendBufferSize());
            this.isOpen = true;
            this.used = false;
        }
        catch (IOException e) {
            this.closeSocketAndStreams();
            throw e;
        }
        catch (TimeoutController.TimeoutException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("The host " + this.hostName + ":" + this.portNumber + " (or proxy " + this.proxyHostName + ":" + this.proxyPortNumber + ") did not accept the connection within timeout of " + this.connectTimeout + " milliseconds");
            }
            throw new ConnectionTimeoutException();
        }
    }

    public void tunnelCreated() throws IllegalStateException, IOException {
        LOG.trace("enter HttpConnection.tunnelCreated()");
        if (!this.isSecure() || !this.isProxied()) {
            throw new IllegalStateException("Connection must be secure and proxied to use this feature");
        }
        if (this.usingSecureSocket) {
            throw new IllegalStateException("Already using a secure socket");
        }
        SecureProtocolSocketFactory socketFactory = (SecureProtocolSocketFactory)this.protocolInUse.getSocketFactory();
        this.socket = socketFactory.createSocket(this.socket, this.hostName, this.portNumber, true);
        if (this.sendBufferSize != -1) {
            this.socket.setSendBufferSize(this.sendBufferSize);
        }
        this.inputStream = new PushbackInputStream(this.socket.getInputStream());
        this.outputStream = new BufferedOutputStream(new WrappedOutputStream(this.socket.getOutputStream()), this.socket.getSendBufferSize());
        this.usingSecureSocket = true;
        this.tunnelEstablished = true;
        LOG.debug("Secure tunnel created");
    }

    public boolean isTransparent() {
        return !this.isProxied() || this.tunnelEstablished;
    }

    public void flushRequestOutputStream() throws IOException {
        LOG.trace("enter HttpConnection.flushRequestOutputStream()");
        this.assertOpen();
        this.outputStream.flush();
    }

    public OutputStream getRequestOutputStream() throws IOException, IllegalStateException {
        LOG.trace("enter HttpConnection.getRequestOutputStream()");
        this.assertOpen();
        OutputStream out = this.outputStream;
        if (Wire.enabled()) {
            out = new WireLogOutputStream(out);
        }
        return out;
    }

    public OutputStream getRequestOutputStream(boolean useChunking) throws IOException, IllegalStateException {
        LOG.trace("enter HttpConnection.getRequestOutputStream(boolean)");
        OutputStream out = this.getRequestOutputStream();
        if (useChunking) {
            out = new ChunkedOutputStream(out);
        }
        return out;
    }

    public InputStream getResponseInputStream(HttpMethod method) throws IOException, IllegalStateException {
        LOG.trace("enter HttpConnection.getResponseInputStream(HttpMethod)");
        return this.getResponseInputStream();
    }

    public InputStream getResponseInputStream() throws IOException, IllegalStateException {
        LOG.trace("enter HttpConnection.getResponseInputStream()");
        this.assertOpen();
        return this.inputStream;
    }

    public boolean isResponseAvailable() throws IOException {
        LOG.trace("enter HttpConnection.isResponseAvailable()");
        this.assertOpen();
        return this.inputStream.available() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isResponseAvailable(int timeout) throws IOException {
        boolean result;
        block13: {
            LOG.trace("enter HttpConnection.isResponseAvailable(int)");
            this.assertOpen();
            result = false;
            if (this.inputStream.available() > 0) {
                result = true;
            } else {
                block12: {
                    this.socket.setSoTimeout(timeout);
                    int byteRead = this.inputStream.read();
                    if (byteRead != -1) {
                        this.inputStream.unread(byteRead);
                        LOG.debug("Input data available");
                        result = true;
                        break block12;
                    }
                    LOG.debug("Input data not available");
                }
                Object var5_5 = null;
                try {
                    this.socket.setSoTimeout(this.soTimeout);
                }
                catch (IOException ioe) {
                    LOG.debug("An error ocurred while resetting soTimeout, we will assume that no response is available.", ioe);
                    result = false;
                }
            }
            break block13;
            {
                catch (InterruptedIOException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Input data not available after " + timeout + " ms");
                    }
                    Object var5_6 = null;
                    try {
                        this.socket.setSoTimeout(this.soTimeout);
                    }
                    catch (IOException ioe) {
                        LOG.debug("An error ocurred while resetting soTimeout, we will assume that no response is available.", ioe);
                        result = false;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    this.socket.setSoTimeout(this.soTimeout);
                }
                catch (IOException ioe) {
                    LOG.debug("An error ocurred while resetting soTimeout, we will assume that no response is available.", ioe);
                    result = false;
                }
                throw throwable;
            }
        }
        return result;
    }

    public void write(byte[] data) throws IOException, IllegalStateException, HttpRecoverableException {
        LOG.trace("enter HttpConnection.write(byte[])");
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int offset, int length) throws IOException, IllegalStateException, HttpRecoverableException {
        LOG.trace("enter HttpConnection.write(byte[], int, int)");
        if (offset + length > data.length) {
            throw new HttpRecoverableException("Unable to write: offset=" + offset + " length=" + length + " data.length=" + data.length);
        }
        if (data.length <= 0) {
            throw new HttpRecoverableException("Unable to write: data.length=" + data.length);
        }
        this.assertOpen();
        try {
            this.outputStream.write(data, offset, length);
        }
        catch (HttpRecoverableException hre) {
            throw hre;
        }
        catch (SocketException se) {
            LOG.debug("HttpConnection: Socket exception while writing data", se);
            throw new HttpRecoverableException(se.toString());
        }
        catch (IOException ioe) {
            LOG.debug("HttpConnection: Exception while writing data", ioe);
            throw ioe;
        }
    }

    public void writeLine(byte[] data) throws IOException, IllegalStateException, HttpRecoverableException {
        LOG.trace("enter HttpConnection.writeLine(byte[])");
        this.write(data);
        this.writeLine();
    }

    public void writeLine() throws IOException, IllegalStateException, HttpRecoverableException {
        LOG.trace("enter HttpConnection.writeLine()");
        this.write(CRLF);
    }

    public void print(String data) throws IOException, IllegalStateException, HttpRecoverableException {
        LOG.trace("enter HttpConnection.print(String)");
        this.write(HttpConstants.getBytes(data));
    }

    public void printLine(String data) throws IOException, IllegalStateException, HttpRecoverableException {
        LOG.trace("enter HttpConnection.printLine(String)");
        this.writeLine(HttpConstants.getBytes(data));
    }

    public void printLine() throws IOException, IllegalStateException, HttpRecoverableException {
        LOG.trace("enter HttpConnection.printLine()");
        this.writeLine();
    }

    public String readLine() throws IOException, IllegalStateException {
        LOG.trace("enter HttpConnection.readLine()");
        this.assertOpen();
        return HttpParser.readLine(this.inputStream);
    }

    public void shutdownOutput() {
        LOG.trace("enter HttpConnection.shutdownOutput()");
        try {
            Class[] paramsClasses = new Class[]{};
            Method shutdownOutput = this.socket.getClass().getMethod("shutdownOutput", paramsClasses);
            Object[] params = new Object[]{};
            shutdownOutput.invoke((Object)this.socket, params);
        }
        catch (Exception ex) {
            LOG.debug("Unexpected Exception caught", ex);
        }
    }

    public void close() {
        LOG.trace("enter HttpConnection.close()");
        this.closeSocketAndStreams();
    }

    public HttpConnectionManager getHttpConnectionManager() {
        return this.httpConnectionManager;
    }

    public void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
        this.httpConnectionManager = httpConnectionManager;
    }

    public void releaseConnection() {
        LOG.trace("enter HttpConnection.releaseConnection()");
        this.used = true;
        if (this.httpConnectionManager != null) {
            this.httpConnectionManager.releaseConnection(this);
        }
    }

    protected void closeSocketAndStreams() {
        Closeable temp;
        LOG.trace("enter HttpConnection.closeSockedAndStreams()");
        this.lastResponseInputStream = null;
        if (null != this.outputStream) {
            temp = this.outputStream;
            this.outputStream = null;
            try {
                ((OutputStream)temp).close();
            }
            catch (Exception ex) {
                LOG.debug("Exception caught when closing output", ex);
            }
        }
        if (null != this.inputStream) {
            temp = this.inputStream;
            this.inputStream = null;
            try {
                ((InputStream)temp).close();
            }
            catch (Exception ex) {
                LOG.debug("Exception caught when closing input", ex);
            }
        }
        if (null != this.socket) {
            temp = this.socket;
            this.socket = null;
            try {
                ((Socket)temp).close();
            }
            catch (Exception ex) {
                LOG.debug("Exception caught when closing socket", ex);
            }
        }
        this.isOpen = false;
        this.used = false;
        this.tunnelEstablished = false;
        this.usingSecureSocket = false;
    }

    protected void assertNotOpen() throws IllegalStateException {
        if (this.isOpen) {
            throw new IllegalStateException("Connection is open");
        }
    }

    protected void assertOpen() throws IllegalStateException {
        if (!this.isOpen) {
            throw new IllegalStateException("Connection is not open");
        }
    }

    public int getSendBufferSize() throws SocketException {
        if (this.socket == null) {
            return -1;
        }
        return this.socket.getSendBufferSize();
    }

    public void setSendBufferSize(int sendBufferSize) throws SocketException {
        this.sendBufferSize = sendBufferSize;
        if (this.socket != null) {
            this.socket.setSendBufferSize(sendBufferSize);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class WrappedOutputStream
    extends OutputStream {
        private OutputStream out;

        public WrappedOutputStream(OutputStream out) {
            this.out = out;
        }

        private IOException handleException(IOException ioe) {
            boolean tempUsed = HttpConnection.this.used;
            HttpConnection.this.close();
            if (tempUsed) {
                LOG.debug("Output exception occurred on a used connection.  Will treat as recoverable.", ioe);
                return new HttpRecoverableException(ioe.toString());
            }
            return ioe;
        }

        public void write(int b) throws IOException {
            try {
                this.out.write(b);
            }
            catch (IOException ioe) {
                throw this.handleException(ioe);
            }
        }

        public void flush() throws IOException {
            try {
                this.out.flush();
            }
            catch (IOException ioe) {
                throw this.handleException(ioe);
            }
        }

        public void close() throws IOException {
            try {
                this.out.close();
            }
            catch (IOException ioe) {
                throw this.handleException(ioe);
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.out.write(b, off, len);
            }
            catch (IOException ioe) {
                throw this.handleException(ioe);
            }
        }

        public void write(byte[] b) throws IOException {
            try {
                this.out.write(b);
            }
            catch (IOException ioe) {
                throw this.handleException(ioe);
            }
        }
    }

    private abstract class SocketTask
    implements Runnable {
        private Socket socket;
        private IOException exception;

        private SocketTask() {
        }

        protected void setSocket(Socket newSocket) {
            this.socket = newSocket;
        }

        protected Socket getSocket() {
            return this.socket;
        }

        public abstract void doit() throws IOException;

        public void run() {
            try {
                this.doit();
            }
            catch (IOException e) {
                this.exception = e;
            }
        }
    }

    public class ConnectionTimeoutException
    extends IOException {
    }
}

