/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.properties;

import java.util.ArrayList;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.util.DOMUtils;
import org.apache.webdav.lib.Ace;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.Privilege;
import org.apache.webdav.lib.ResponseEntity;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AclProperty
extends BaseProperty {
    public static final String TAG_NAME = "acl";

    public AclProperty(ResponseEntity response, Element element) {
        super(response, element);
    }

    public Ace[] getAces() {
        NodeList children = this.element.getChildNodes();
        if (children == null || children.getLength() == 0) {
            return null;
        }
        ArrayList<Ace> aces = new ArrayList<Ace>();
        for (int i = 0; i < children.getLength(); ++i) {
            try {
                String localName;
                Element child = (Element)children.item(i);
                String namespace = DOMUtils.getElementNamespaceURI(child);
                if (namespace == null || !namespace.equals("DAV:") || !"ace".equals(localName = DOMUtils.getElementLocalName(child))) continue;
                aces.add(this.parseAce(child));
                continue;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return aces.toArray(new Ace[aces.size()]);
    }

    protected Ace parseAce(Element element) {
        String principal = null;
        Element child = DOMUtils.getFirstElement(element, "DAV:", "principal");
        if (child == null) {
            System.err.println("Error: mandatory element <principal> is missing !");
            System.err.println("element: " + element);
            return null;
        }
        Element href = DOMUtils.getFirstElement(child, "DAV:", "href");
        if (href != null) {
            principal = DOMUtils.getTextValue(href);
            try {
                principal = URIUtil.decode(principal);
            }
            catch (URIException e) {
                System.err.println("Warning: decoding href element failed!");
                System.err.println("reason: " + e.getReason());
            }
        }
        String[] types = new String[]{"all", "authenticated", "unauthenticated", "property", "self"};
        for (int i = 0; i < types.length && principal == null; ++i) {
            Element type = DOMUtils.getFirstElement(child, "DAV:", types[i]);
            if (type == null) continue;
            principal = types[i];
        }
        if (principal == null) {
            System.err.println("Error: unknown type of principal");
            System.err.println("element: " + element);
            return null;
        }
        Ace ace = new Ace(principal);
        child = DOMUtils.getFirstElement(element, "DAV:", "grant");
        if (child == null) {
            child = DOMUtils.getFirstElement(element, "DAV:", "deny");
            ace.setNegative(true);
        }
        if (child != null) {
            NodeList privilegeElements = child.getElementsByTagNameNS("DAV:", "privilege");
            for (int i = 0; i < privilegeElements.getLength(); ++i) {
                Element privilegeElement = (Element)privilegeElements.item(i);
                NodeList privileges = privilegeElement.getElementsByTagName("*");
                for (int j = 0; j < privileges.getLength(); ++j) {
                    Element privilege = (Element)privileges.item(j);
                    ace.addPrivilege(this.parsePrivilege(privilege));
                }
            }
        }
        if ((child = DOMUtils.getFirstElement(element, "DAV:", "inherited")) != null) {
            href = DOMUtils.getFirstElement(child, "DAV:", "href");
            if (href != null) {
                ace.setInherited(true);
                ace.setInheritedFrom(DOMUtils.getTextValue(href));
            } else {
                System.err.println("Error: mandatory element <href> is missing !");
                return null;
            }
        }
        if ((child = DOMUtils.getFirstElement(element, "DAV:", "protected")) != null) {
            ace.setProtected(true);
        }
        return ace;
    }

    protected Privilege parsePrivilege(Element privilegeElement) {
        return new Privilege(privilegeElement.getNamespaceURI(), privilegeElement.getLocalName(), null);
    }

    public String getPropertyAsString() {
        Ace[] aces = this.getAces();
        if (aces == null || aces.length == 0) {
            return "";
        }
        StringBuffer tmp = new StringBuffer(aces[0].toString());
        for (int i = 1; i < aces.length; ++i) {
            tmp.append(", ");
            tmp.append(aces[i].toString());
        }
        return tmp.toString();
    }
}

