/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.RangeDrawData;

public class Theme {
    Device device;
    int shellHandle;
    int fixedHandle;
    int buttonHandle;
    int arrowHandle;
    int frameHandle;
    int entryHandle;
    int checkButtonHandle;
    int radioButtonHandle;
    int notebookHandle;
    int treeHandle;
    int progressHandle;
    int toolbarHandle;
    int labelHandle;
    int separatorHandle;

    public Theme(Device device) {
        this.device = device;
        this.shellHandle = OS.gtk_window_new(0);
        this.fixedHandle = OS.gtk_fixed_new();
        this.buttonHandle = OS.gtk_button_new();
        this.arrowHandle = OS.gtk_arrow_new(1, 0);
        this.checkButtonHandle = OS.gtk_check_button_new();
        this.frameHandle = OS.gtk_check_button_new();
        this.entryHandle = OS.gtk_entry_new();
        this.radioButtonHandle = OS.gtk_radio_button_new(0);
        this.notebookHandle = OS.gtk_notebook_new();
        this.progressHandle = OS.gtk_progress_bar_new();
        this.toolbarHandle = OS.gtk_toolbar_new();
        this.treeHandle = OS.gtk_tree_view_new_with_model(0);
        this.separatorHandle = OS.gtk_vseparator_new();
        this.labelHandle = OS.gtk_label_new(null);
        OS.gtk_container_add(this.fixedHandle, this.labelHandle);
        OS.gtk_container_add(this.fixedHandle, this.frameHandle);
        OS.gtk_container_add(this.fixedHandle, this.entryHandle);
        OS.gtk_container_add(this.fixedHandle, this.separatorHandle);
        OS.gtk_container_add(this.fixedHandle, this.arrowHandle);
        OS.gtk_container_add(this.fixedHandle, this.toolbarHandle);
        OS.gtk_container_add(this.fixedHandle, this.progressHandle);
        OS.gtk_container_add(this.fixedHandle, this.checkButtonHandle);
        OS.gtk_container_add(this.fixedHandle, this.radioButtonHandle);
        OS.gtk_container_add(this.fixedHandle, this.buttonHandle);
        OS.gtk_container_add(this.fixedHandle, this.treeHandle);
        OS.gtk_container_add(this.fixedHandle, this.notebookHandle);
        OS.gtk_container_add(this.shellHandle, this.fixedHandle);
        OS.gtk_widget_realize(this.separatorHandle);
        OS.gtk_widget_realize(this.labelHandle);
        OS.gtk_widget_realize(this.frameHandle);
        OS.gtk_widget_realize(this.entryHandle);
        OS.gtk_widget_realize(this.arrowHandle);
        OS.gtk_widget_realize(this.buttonHandle);
        OS.gtk_widget_realize(this.treeHandle);
        OS.gtk_widget_realize(this.notebookHandle);
        OS.gtk_widget_realize(this.checkButtonHandle);
        OS.gtk_widget_realize(this.radioButtonHandle);
        OS.gtk_widget_realize(this.progressHandle);
        OS.gtk_widget_realize(this.toolbarHandle);
        OS.gtk_widget_realize(this.shellHandle);
    }

    static int createPixbuf(Image image) {
        int n;
        boolean bl;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_drawable_get_size(image.pixmap, nArray, nArray2);
        int n2 = OS.gdk_colormap_get_system();
        boolean bl2 = bl = image.mask != 0 && OS.gdk_drawable_get_depth(image.mask) == 1;
        if (bl) {
            n = OS.gdk_pixbuf_new(0, true, 8, nArray[0], nArray2[0]);
            if (n == 0) {
                SWT.error(2);
            }
            OS.gdk_pixbuf_get_from_drawable(n, image.pixmap, n2, 0, 0, 0, 0, nArray[0], nArray2[0]);
            int n3 = OS.gdk_pixbuf_new(0, false, 8, nArray[0], nArray2[0]);
            if (n3 == 0) {
                SWT.error(2);
            }
            OS.gdk_pixbuf_get_from_drawable(n3, image.mask, 0, 0, 0, 0, 0, nArray[0], nArray2[0]);
            int n4 = OS.gdk_pixbuf_get_rowstride(n);
            int n5 = OS.gdk_pixbuf_get_pixels(n);
            byte[] byArray = new byte[n4];
            int n6 = OS.gdk_pixbuf_get_rowstride(n3);
            int n7 = OS.gdk_pixbuf_get_pixels(n3);
            byte[] byArray2 = new byte[n6];
            int n8 = 0;
            while (n8 < nArray2[0]) {
                int n9 = n5 + n8 * n4;
                OS.memmove(byArray, n9, n4);
                int n10 = n7 + n8 * n6;
                OS.memmove(byArray2, n10, n6);
                int n11 = 0;
                while (n11 < nArray[0]) {
                    if (byArray2[n11 * 3] == 0) {
                        byArray[n11 * 4 + 3] = 0;
                    }
                    ++n11;
                }
                OS.memmove(n9, byArray, n4);
                ++n8;
            }
            OS.g_object_unref(n3);
        } else {
            ImageData imageData = image.getImageData();
            boolean bl3 = imageData.getTransparencyType() == 1;
            n = OS.gdk_pixbuf_new(0, bl3, 8, nArray[0], nArray2[0]);
            if (n == 0) {
                SWT.error(2);
            }
            OS.gdk_pixbuf_get_from_drawable(n, image.pixmap, n2, 0, 0, 0, 0, nArray[0], nArray2[0]);
            if (bl3) {
                byte[] byArray = imageData.alphaData;
                int n12 = OS.gdk_pixbuf_get_rowstride(n);
                int n13 = OS.gdk_pixbuf_get_pixels(n);
                byte[] byArray3 = new byte[n12];
                int n14 = 0;
                while (n14 < nArray2[0]) {
                    int n15 = n13 + n14 * n12;
                    OS.memmove(byArray3, n15, n12);
                    int n16 = 0;
                    while (n16 < nArray[0]) {
                        byArray3[n16 * 4 + 3] = byArray[n14 * nArray[0] + n16];
                        ++n16;
                    }
                    OS.memmove(n15, byArray3, n12);
                    ++n14;
                }
            }
        }
        return n;
    }

    void checkTheme() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    public Rectangle computeTrim(GC gC, DrawData drawData) {
        if (gC == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        return drawData.computeTrim(this, gC);
    }

    public void dispose() {
        if (this.shellHandle == 0) {
            return;
        }
        OS.gtk_widget_destroy(this.shellHandle);
        this.separatorHandle = 0;
        this.labelHandle = 0;
        this.toolbarHandle = 0;
        this.progressHandle = 0;
        this.treeHandle = 0;
        this.notebookHandle = 0;
        this.radioButtonHandle = 0;
        this.checkButtonHandle = 0;
        this.entryHandle = 0;
        this.frameHandle = 0;
        this.arrowHandle = 0;
        this.buttonHandle = 0;
        this.fixedHandle = 0;
        this.shellHandle = 0;
    }

    public void drawBackground(GC gC, Rectangle rectangle, DrawData drawData) {
        this.checkTheme();
        if (gC == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        drawData.draw(this, gC, rectangle);
    }

    public void drawFocus(GC gC, Rectangle rectangle, DrawData drawData) {
        this.checkTheme();
        if (gC == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        gC.drawFocus(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawImage(GC gC, Rectangle rectangle, DrawData drawData, Image image, int n) {
        this.checkTheme();
        if (gC == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        drawData.drawImage(this, image, gC, rectangle);
    }

    public void drawText(GC gC, Rectangle rectangle, DrawData drawData, String string, int n) {
        this.checkTheme();
        if (gC == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        drawData.drawText(this, string, n, gC, rectangle);
    }

    public Rectangle getBounds(int n, Rectangle rectangle, DrawData drawData) {
        this.checkTheme();
        if (rectangle == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        return drawData.getBounds(n, rectangle);
    }

    public int getSelection(Point point, Rectangle rectangle, RangeDrawData rangeDrawData) {
        this.checkTheme();
        if (point == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (rangeDrawData == null) {
            SWT.error(4);
        }
        return rangeDrawData.getSelection(point, rectangle);
    }

    public int hitBackground(Point point, Rectangle rectangle, DrawData drawData) {
        this.checkTheme();
        if (point == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        return drawData.hit(this, point, rectangle);
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    public Rectangle measureText(GC gC, Rectangle rectangle, DrawData drawData, String string, int n) {
        this.checkTheme();
        if (gC == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        return drawData.measureText(this, string, n, gC, rectangle);
    }

    int getWidgetProperty(int n, String string) {
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int[] nArray = new int[1];
        OS.gtk_widget_style_get(n, byArray, nArray, 0);
        return nArray[0];
    }

    int getBorderProperty(int n, String string) {
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int[] nArray = new int[1];
        OS.gtk_widget_style_get(n, byArray, nArray, 0);
        return nArray[0];
    }

    void transferClipping(GC gC, int n) {
        GCData gCData = gC.getGCData();
        int n2 = gCData.clipRgn;
        int n3 = gCData.damageRgn;
        int n4 = n2;
        if (n3 != 0) {
            if (n4 != 0) {
                n4 = OS.gdk_region_new();
                OS.gdk_region_union(n4, n2);
                OS.gdk_region_intersect(n4, n3);
            } else {
                n4 = n3;
            }
        }
        int[] nArray = new int[1];
        int n5 = 0;
        while (n5 < 5) {
            OS.gtk_style_get_fg_gc(n, n5, nArray);
            if (nArray[0] != 0) {
                OS.gdk_gc_set_clip_region(nArray[0], n4);
            }
            OS.gtk_style_get_bg_gc(n, n5, nArray);
            if (nArray[0] != 0) {
                OS.gdk_gc_set_clip_region(nArray[0], n4);
            }
            OS.gtk_style_get_light_gc(n, n5, nArray);
            if (nArray[0] != 0) {
                OS.gdk_gc_set_clip_region(nArray[0], n4);
            }
            OS.gtk_style_get_dark_gc(n, n5, nArray);
            if (nArray[0] != 0) {
                OS.gdk_gc_set_clip_region(nArray[0], n4);
            }
            OS.gtk_style_get_mid_gc(n, n5, nArray);
            if (nArray[0] != 0) {
                OS.gdk_gc_set_clip_region(nArray[0], n4);
            }
            OS.gtk_style_get_text_gc(n, n5, nArray);
            if (nArray[0] != 0) {
                OS.gdk_gc_set_clip_region(nArray[0], n4);
            }
            OS.gtk_style_get_text_aa_gc(n, n5, nArray);
            if (nArray[0] != 0) {
                OS.gdk_gc_set_clip_region(nArray[0], n4);
            }
            ++n5;
        }
        OS.gtk_style_get_black_gc(n, nArray);
        if (nArray[0] != 0) {
            OS.gdk_gc_set_clip_region(nArray[0], n4);
        }
        OS.gtk_style_get_white_gc(n, nArray);
        if (nArray[0] != 0) {
            OS.gdk_gc_set_clip_region(nArray[0], n4);
        }
        if (n4 != n2 && n4 != n3) {
            OS.gdk_region_destroy(n4);
        }
    }
}

