/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UPnPManager;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.chat.ChatManager;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.statistics.HTTPStat;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Acceptor
implements Runnable {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor);
    static long INCOMING_EXPIRE_TIME = 1800000L;
    static long WAIT_TIME_AFTER_REQUESTS = 30000L;
    static long TIME_BETWEEN_VALIDATES = 600000L;
    private static final UPnPManager UPNP_MANAGER = CommonUtils.isJava14OrLater() && !ConnectionSettings.DISABLE_UPNP.getValue() ? UPnPManager.instance() : null;
    private volatile ServerSocket _socket = null;
    private volatile int _port = 6346;
    private final Object SOCKET_LOCK = new Object();
    private static byte[] _address = new byte[4];
    private static byte[] _externalAddress = new byte[4];
    private volatile boolean _acceptedIncoming = false;
    private volatile long _lastIncomingTime = 0L;
    private volatile long _lastConnectBackTime = System.currentTimeMillis();
    static /* synthetic */ Class class$com$limegroup$gnutella$Acceptor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddress(InetAddress address) {
        byte[] byteAddr = address.getAddress();
        if (!NetworkUtils.isValidAddress(byteAddr)) {
            return;
        }
        if (byteAddr[0] == 127 && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        boolean addrChanged = false;
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            if (!Arrays.equals(_address, byteAddr)) {
                _address = byteAddr;
                addrChanged = true;
            }
        }
        if (addrChanged) {
            RouterService.addressChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExternalAddress(InetAddress address) {
        byte[] byteAddr = address.getAddress();
        if (byteAddr[0] == 127 && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            _externalAddress = byteAddr;
        }
    }

    public void init() {
        int oldPort;
        block19: {
            int tempPort = ConnectionSettings.PORT.getValue();
            try {
                this.setAddress(UPNP_MANAGER != null ? UPNP_MANAGER.getLocalAddress() : InetAddress.getLocalHost());
            }
            catch (UnknownHostException e) {
            }
            catch (SecurityException e) {
                // empty catch block
            }
            oldPort = tempPort;
            try {
                this.setListeningPort(tempPort);
                this._port = tempPort;
            }
            catch (IOException e) {
                int numToTry = 20;
                Random gen = null;
                for (int i = 0; i < numToTry; ++i) {
                    if (i < 10) {
                        tempPort = i + 6346;
                    } else {
                        if (gen == null) {
                            gen = new Random();
                        }
                        tempPort = gen.nextInt(50000);
                        tempPort += 2000;
                    }
                    if (tempPort == ConnectionSettings.MULTICAST_PORT.getValue()) {
                        ++numToTry;
                        continue;
                    }
                    try {
                        this.setListeningPort(tempPort);
                        this._port = tempPort;
                        break;
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                if (this._socket != null) break block19;
                MessageService.showError("ERROR_NO_PORTS_AVAILABLE");
            }
        }
        if (this._port != oldPort) {
            ConnectionSettings.PORT.setValue(this._port);
            SettingsHandler.save();
            RouterService.addressChanged();
        }
        if (this._socket != null && UPNP_MANAGER != null) {
            boolean forcedIP;
            UPNP_MANAGER.waitForDevice();
            UPNP_MANAGER.stop();
            boolean natted = UPNP_MANAGER.isNATPresent();
            boolean validPort = NetworkUtils.isValidPort(this._port);
            boolean bl = forcedIP = ConnectionSettings.FORCE_IP_ADDRESS.getValue() && !ConnectionSettings.UPNP_IN_USE.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Natted: " + natted + ", validPort: " + validPort + ", forcedIP: " + forcedIP);
            }
            if (natted && validPort && !forcedIP) {
                int mappedPort = UPNP_MANAGER.mapPort(this._port);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("UPNP port mapped: " + mappedPort);
                }
                if (mappedPort != 0) {
                    UPNP_MANAGER.clearMappingsOnShutdown();
                    ConnectionSettings.FORCE_IP_ADDRESS.setValue(true);
                    ConnectionSettings.FORCED_PORT.setValue(mappedPort);
                    ConnectionSettings.UPNP_IN_USE.setValue(true);
                    if (mappedPort != this._port) {
                        RouterService.addressChanged();
                    }
                    this.resetLastConnectBackTime();
                    UDPService.instance().resetLastConnectBackTime();
                }
            }
        }
    }

    public void start() {
        MulticastService.instance().start();
        UDPService.instance().start();
        ManagedThread at = new ManagedThread(this, "Acceptor");
        at.setDaemon(true);
        at.start();
        RouterService.schedule(new IncomingValidator(), TIME_BETWEEN_VALIDATES, TIME_BETWEEN_VALIDATES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAddressExternal() {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return true;
        }
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            return Arrays.equals(this.getAddress(true), _externalAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getExternalAddress() {
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            return _externalAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAddress(boolean checkForce) {
        if (checkForce && ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            String address = ConnectionSettings.FORCED_IP_ADDRESS_STRING.getValue();
            try {
                InetAddress ia = InetAddress.getByName(address);
                return ia.getAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            return _address;
        }
    }

    public int getPort(boolean checkForce) {
        if (checkForce && ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            return ConnectionSettings.FORCED_PORT.getValue();
        }
        return this._port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListeningPort(int port) throws IOException {
        LOG.trace("Acceptor.setListeningPort(): entered.");
        if (this._socket != null && this._port == port) {
            return;
        }
        if (port == 0) {
            LOG.trace("Acceptor.setListeningPort(): shutting off service.");
            if (this._socket != null) {
                try {
                    this._socket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            Object e = this.SOCKET_LOCK;
            synchronized (e) {
                this._socket = null;
                this._port = 0;
                this.SOCKET_LOCK.notify();
            }
            UDPService.instance().setListeningSocket(null);
            MulticastService.instance().setListeningSocket(null);
            LOG.trace("Acceptor.setListeningPort(): service OFF.");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Acceptor.setListeningPort(): changing port to " + port);
        }
        DatagramSocket udpServiceSocket = UDPService.instance().newListeningSocket(port);
        LOG.trace("Acceptor.setListeningPort(): UDP Service is ready.");
        MulticastSocket mcastServiceSocket = null;
        try {
            InetAddress mgroup = InetAddress.getByName(ConnectionSettings.MULTICAST_ADDRESS.getValue());
            mcastServiceSocket = MulticastService.instance().newListeningSocket(ConnectionSettings.MULTICAST_PORT.getValue(), mgroup);
            LOG.trace("Acceptor.setListeningPort(): Multicast Service is ready.");
        }
        catch (IOException e) {
            mcastServiceSocket = null;
            LOG.debug("Acceptor.setListeningPort(): Unable to start multicast service.", e);
        }
        ServerSocket newSocket = null;
        try {
            newSocket = new ServerSocket(port);
        }
        catch (IOException e) {
            udpServiceSocket.close();
            throw e;
        }
        catch (IllegalArgumentException e) {
            udpServiceSocket.close();
            throw new IOException("could not create a listening socket");
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        Object object = this.SOCKET_LOCK;
        synchronized (object) {
            this._socket = newSocket;
            this._port = port;
            this.SOCKET_LOCK.notify();
        }
        LOG.trace("Acceptor.setListeningPort(): I am ready.");
        UDPService.instance().setListeningSocket(udpServiceSocket);
        if (mcastServiceSocket != null) {
            MulticastService.instance().setListeningSocket(mcastServiceSocket);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Acceptor.setListeningPort(): listening UDP/TCP on " + this._port);
        }
    }

    public boolean acceptedIncoming() {
        return this._acceptedIncoming;
    }

    private boolean setIncoming(boolean status) {
        boolean old = this._acceptedIncoming;
        this._acceptedIncoming = status;
        return old != status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFirewall(Socket socket) {
        boolean changed = false;
        if (this.isOutsideConnection(socket.getInetAddress())) {
            Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
            synchronized (clazz) {
                changed = this.setIncoming(true);
                ConnectionSettings.EVER_ACCEPTED_INCOMING.setValue(true);
                this._lastIncomingTime = System.currentTimeMillis();
            }
        }
        if (changed) {
            RouterService.incomingStatusChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket client = null;
                    Object object = this.SOCKET_LOCK;
                    synchronized (object) {
                        block15: {
                            if (this._socket != null) {
                                try {
                                    client = this._socket.accept();
                                    break block15;
                                }
                                catch (IOException e) {
                                    LOG.error("IOX while accepting", e);
                                    continue;
                                }
                            }
                            try {
                                this.SOCKET_LOCK.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    InetAddress address = client.getInetAddress();
                    if (this.isBannedIP(address.getAddress())) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn("Ignoring banned host: " + address);
                        }
                        HTTPStat.BANNED_REQUESTS.incrementStat();
                        client.close();
                        continue;
                    }
                    if (!ConnectionSettings.UNSET_FIREWALLED_FROM_CONNECTBACK.getValue()) {
                        this.checkFirewall(client);
                    }
                    InetAddress localAddress = client.getLocalAddress();
                    this.setAddress(localAddress);
                    ConnectionDispatchRunner dispatcher = new ConnectionDispatchRunner(client);
                    ManagedThread dispatchThread = new ManagedThread(dispatcher, "ConnectionDispatchRunner");
                    dispatchThread.setDaemon(true);
                    dispatchThread.start();
                }
            }
            catch (Throwable e) {
                ErrorService.error(e);
                continue;
            }
            break;
        }
    }

    private boolean isOutsideConnection(InetAddress addr) {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return true;
        }
        byte[] bytes = addr.getAddress();
        return !RouterService.isConnectedTo(addr) && !NetworkUtils.isCloseIP(bytes, this.getAddress(false)) && !NetworkUtils.isLocalAddress(addr);
    }

    public boolean isBannedIP(byte[] addr) {
        return !IPFilter.instance().allow(addr);
    }

    void resetLastConnectBackTime() {
        this._lastConnectBackTime = System.currentTimeMillis() - INCOMING_EXPIRE_TIME;
    }

    public void shutdown() {
        if (UPNP_MANAGER != null && UPNP_MANAGER.isNATPresent() && UPNP_MANAGER.mappingsExist()) {
            ConnectionSettings.FORCE_IP_ADDRESS.revertToDefault();
            ConnectionSettings.FORCED_PORT.revertToDefault();
            ConnectionSettings.UPNP_IN_USE.revertToDefault();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ boolean access$600(Acceptor x0, boolean x1) {
        return x0.setIncoming(x1);
    }

    private class IncomingValidator
    implements Runnable {
        public void run() {
            long currTime = System.currentTimeMillis();
            ConnectionManager cm = RouterService.getConnectionManager();
            if ((Acceptor.this._acceptedIncoming && currTime - Acceptor.this._lastIncomingTime > INCOMING_EXPIRE_TIME || !Acceptor.this._acceptedIncoming && currTime - Acceptor.this._lastConnectBackTime > INCOMING_EXPIRE_TIME) && cm.sendTCPConnectBackRequests()) {
                Acceptor.this._lastConnectBackTime = System.currentTimeMillis();
                Runnable resetter = new Runnable(this, currTime){
                    private final /* synthetic */ long val$currTime;
                    private final /* synthetic */ IncomingValidator this$1;
                    {
                        this.this$1 = this$1;
                        this.val$currTime = val$currTime;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        boolean changed = false;
                        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
                        synchronized (clazz) {
                            if (Acceptor.access$300(IncomingValidator.access$500(this.this$1)) < this.val$currTime) {
                                changed = Acceptor.access$600(IncomingValidator.access$500(this.this$1), false);
                            }
                        }
                        if (changed) {
                            RouterService.incomingStatusChanged();
                        }
                    }
                };
                RouterService.schedule(resetter, WAIT_TIME_AFTER_REQUESTS, 0L);
            }
        }

        static /* synthetic */ Acceptor access$500(IncomingValidator x0) {
            return x0.Acceptor.this;
        }
    }

    private static class ConnectionDispatchRunner
    implements Runnable {
        private final Socket _socket;

        public ConnectionDispatchRunner(Socket socket) {
            this._socket = socket;
        }

        public void run() {
            ConnectionManager cm = RouterService.getConnectionManager();
            UploadManager um = RouterService.getUploadManager();
            DownloadManager dm = RouterService.getDownloadManager();
            Acceptor ac = RouterService.getAcceptor();
            try {
                InputStream in = null;
                try {
                    in = this._socket.getInputStream();
                }
                catch (IOException e) {
                    HTTPStat.CLOSED_REQUESTS.incrementStat();
                    throw e;
                }
                catch (NullPointerException e) {
                    throw new IOException(e.getMessage());
                }
                this._socket.setSoTimeout(8000);
                String word = IOUtils.readLargestWord(in, 8);
                this._socket.setSoTimeout(0);
                if (!word.equals("MAGNET")) {
                    InetAddress address = this._socket.getInetAddress();
                    byte[] addressBytes = address.getAddress();
                    if (ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && addressBytes[0] == 127) {
                        LOG.trace("Killing localhost connection with non-magnet.");
                        this._socket.close();
                        return;
                    }
                }
                boolean useDefaultConnect = ConnectionSettings.CONNECT_STRING.isDefault();
                if (word.equals("GNUTELLA")) {
                    HTTPStat.GNUTELLA_REQUESTS.incrementStat();
                    cm.acceptConnection(this._socket);
                } else if (useDefaultConnect && word.equals("LIMEWIRE")) {
                    HTTPStat.GNUTELLA_LIMEWIRE_REQUESTS.incrementStat();
                    cm.acceptConnection(this._socket);
                } else if (word.equals("GET")) {
                    HTTPStat.GET_REQUESTS.incrementStat();
                    um.acceptUpload(HTTPRequestMethod.GET, this._socket, false);
                } else if (word.equals("HEAD")) {
                    HTTPStat.HEAD_REQUESTS.incrementStat();
                    um.acceptUpload(HTTPRequestMethod.HEAD, this._socket, false);
                } else if (word.equals("GIV")) {
                    HTTPStat.GIV_REQUESTS.incrementStat();
                    dm.acceptDownload(this._socket);
                } else if (word.equals("CHAT")) {
                    HTTPStat.CHAT_REQUESTS.incrementStat();
                    ChatManager.instance().accept(this._socket);
                } else if (word.equals("MAGNET")) {
                    HTTPStat.MAGNET_REQUESTS.incrementStat();
                    ExternalControl.fireMagnet(this._socket);
                } else if (word.equals("CONNECT") || word.equals("\n\n")) {
                    if (ConnectionSettings.UNSET_FIREWALLED_FROM_CONNECTBACK.getValue()) {
                        ac.checkFirewall(this._socket);
                    }
                    IOUtils.close(this._socket);
                } else {
                    HTTPStat.UNKNOWN_REQUESTS.incrementStat();
                    if (LOG.isErrorEnabled()) {
                        LOG.error("Unknown protocol: " + word);
                    }
                    IOUtils.close(this._socket);
                }
            }
            catch (IOException e) {
                LOG.error("IOX while dispatching", e);
                IOUtils.close(this._socket);
            }
            catch (Throwable e) {
                ErrorService.error(e);
            }
        }
    }
}

