/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.vendor.SimppVM;
import com.limegroup.gnutella.messages.vendor.StatisticVendorMessage;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.util.FixedsizeForgetfulHashMap;
import com.limegroup.gnutella.util.IntWrapper;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ForMeReplyHandler
implements ReplyHandler {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$ForMeReplyHandler == null ? (class$com$limegroup$gnutella$ForMeReplyHandler = ForMeReplyHandler.class$("com.limegroup.gnutella.ForMeReplyHandler")) : class$com$limegroup$gnutella$ForMeReplyHandler);
    private final Map PUSH_REQUESTS = Collections.synchronizedMap(new FixedsizeForgetfulHashMap(200));
    private final Map GUID_REQUESTS = Collections.synchronizedMap(new FixedsizeForgetfulHashMap(200));
    private static final ReplyHandler INSTANCE = new ForMeReplyHandler();
    static /* synthetic */ Class class$com$limegroup$gnutella$ForMeReplyHandler;

    public static ReplyHandler instance() {
        return INSTANCE;
    }

    private ForMeReplyHandler() {
        RouterService.schedule(new Runnable(){

            public void run() {
                ForMeReplyHandler.this.PUSH_REQUESTS.clear();
            }
        }, 30000L, 30000L);
    }

    public void handlePingReply(PingReply pingReply, ReplyHandler handler) {
        if (pingReply.getHops() <= 1 && handler.getNumMessagesReceived() <= 2 && !handler.isOutgoing() && handler.isKillable() && pingReply.getFiles() < (long)SharingSettings.FREELOADER_FILES.getValue() && (int)(Math.random() * 100.0) > SharingSettings.FREELOADER_ALLOWED.getValue() && handler instanceof ManagedConnection && handler.isStable()) {
            ConnectionManager cm = RouterService.getConnectionManager();
            cm.remove((ManagedConnection)handler);
        }
    }

    public void handleQueryReply(QueryReply reply, ReplyHandler handler) {
        boolean validResponses;
        if (handler != null && handler.isPersonalSpam(reply)) {
            return;
        }
        if (reply.isReplyToMulticastQuery()) {
            if (reply.isTCP()) {
                return;
            }
            if (reply.getHops() != 1 || reply.getTTL() != 0) {
                return;
            }
        }
        if (reply.isUDP()) {
            Assert.that(handler instanceof UDPReplyHandler);
            UDPReplyHandler udpHandler = (UDPReplyHandler)handler;
            reply.setOOBAddress(udpHandler.getInetAddress(), udpHandler.getPort());
        }
        if (!(validResponses = this.addXMLToResponses(reply))) {
            return;
        }
        SearchResultHandler resultHandler = RouterService.getSearchResultHandler();
        resultHandler.handleQueryReply(reply);
        DownloadManager dm = RouterService.getDownloadManager();
        dm.handleQueryReply(reply);
    }

    private boolean addXMLToResponses(QueryReply qr) {
        int responsesLength;
        Response[] responses;
        String xmlCollectionString = "";
        try {
            LOG.trace("Trying to do uncompress XML.....");
            byte[] xmlCompressed = qr.getXMLBytes();
            if (xmlCompressed.length > 1) {
                byte[] xmlUncompressed = LimeXMLUtils.uncompress(xmlCompressed);
                xmlCollectionString = new String(xmlUncompressed, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException use) {
            ErrorService.error(use);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (xmlCollectionString == null || xmlCollectionString.equals("")) {
            return true;
        }
        try {
            responses = qr.getResultsArray();
            responsesLength = responses.length;
        }
        catch (BadPacketException bpe) {
            LOG.trace("Unable to get responses", bpe);
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("xmlCollectionString = " + xmlCollectionString);
        }
        List allDocsArray = LimeXMLDocumentHelper.getDocuments(xmlCollectionString, responsesLength);
        block5: for (int i = 0; i < responsesLength; ++i) {
            Response response = responses[i];
            for (int schema = 0; schema < allDocsArray.size(); ++schema) {
                LimeXMLDocument[] metaDocs = (LimeXMLDocument[])allDocsArray.get(schema);
                if (metaDocs == null || metaDocs[i] == null) continue;
                response.setDocument(metaDocs[i]);
                continue block5;
            }
        }
        return true;
    }

    public void handlePushRequest(PushRequest pushRequest, ReplyHandler handler) {
        if (handler.isPersonalSpam(pushRequest)) {
            return;
        }
        byte[] ip = pushRequest.getIP();
        String h = NetworkUtils.ip2string(ip);
        GUID guid = new GUID(pushRequest.getGUID());
        if (this.GUID_REQUESTS.put(guid, guid) != null) {
            return;
        }
        IntWrapper i = (IntWrapper)this.PUSH_REQUESTS.get(h);
        if (i == null) {
            i = new IntWrapper(1);
            this.PUSH_REQUESTS.put(h, i);
        } else {
            i.addInt(1);
            if (i.getInt() > UploadSettings.MAX_PUSHES_PER_HOST.getValue()) {
                return;
            }
        }
        if (RouterService.getAcceptor().isBannedIP(ip)) {
            return;
        }
        int port = pushRequest.getPort();
        if (!NetworkUtils.isValidPort(port)) {
            return;
        }
        String req_guid_hexstring = new GUID(pushRequest.getClientGUID()).toString();
        RouterService.getPushManager().acceptPushUpload(h, port, req_guid_hexstring, pushRequest.isMulticast(), pushRequest.isFirewallTransferPush());
    }

    public boolean isOpen() {
        return true;
    }

    public int getNumMessagesReceived() {
        return 0;
    }

    public void countDroppedMessage() {
    }

    public boolean isSupernodeClientConnection() {
        return false;
    }

    public Set getDomains() {
        return Collections.EMPTY_SET;
    }

    public boolean isPersonalSpam(Message m) {
        return false;
    }

    public void updateHorizonStats(PingReply pingReply) {
    }

    public boolean isOutgoing() {
        return false;
    }

    public boolean isKillable() {
        return false;
    }

    public boolean isLeafConnection() {
        return !RouterService.isSupernode();
    }

    public boolean isHighDegreeConnection() {
        return false;
    }

    public boolean isUltrapeerQueryRoutingConnection() {
        return false;
    }

    public boolean isGoodUltrapeer() {
        return false;
    }

    public boolean isGoodLeaf() {
        return false;
    }

    public boolean supportsPongCaching() {
        return true;
    }

    public boolean allowNewPings() {
        return true;
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(NetworkUtils.ip2string(RouterService.getAddress()));
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public int getPort() {
        return RouterService.getPort();
    }

    public String getAddress() {
        return NetworkUtils.ip2string(RouterService.getAddress());
    }

    public void handleStatisticVM(StatisticVendorMessage vm) {
        Assert.that(false, "ForMeReplyHandler asked to send vendor message");
    }

    public void handleSimppVM(SimppVM simppVM) {
        Assert.that(false, "ForMeReplyHandler asked to send vendor message");
    }

    public boolean isStable() {
        return true;
    }

    public String getLocalePref() {
        return ApplicationSettings.LANGUAGE.getValue();
    }

    public void reply(Message m) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

