/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.util.Comparators;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class MediaType
implements Serializable {
    private static final long serialVersionUID = 3999062781289258389L;
    public static final String SCHEMA_ANY_TYPE = "*";
    public static final String SCHEMA_DOCUMENTS = "text";
    public static final String SCHEMA_PROGRAMS = "application";
    public static final String SCHEMA_AUDIO = "audio";
    public static final String SCHEMA_VIDEO = "video";
    public static final String SCHEMA_IMAGES = "image";
    public static final String ANY_TYPE = "MEDIA_ANY_TYPE";
    public static final String DOCUMENTS = "MEDIA_DOCUMENTS";
    public static final String PROGRAMS = "MEDIA_PROGRAMS";
    public static final String AUDIO = "MEDIA_AUDIO";
    public static final String VIDEO = "MEDIA_VIDEO";
    public static final String IMAGES = "MEDIA_IMAGES";
    private static final MediaType TYPE_ANY = new MediaType("*", "MEDIA_ANY_TYPE", null){

        public boolean matches(String ext) {
            return true;
        }
    };
    private static final MediaType TYPE_DOCUMENTS = new MediaType("text", "MEDIA_DOCUMENTS", new String[]{"html", "htm", "xhtml", "mht", "mhtml", "xml", "txt", "ans", "asc", "diz", "eml", "pdf", "ps", "eps", "epsf", "rtf", "wri", "doc", "mcw", "wps", "xls", "wk1", "dif", "csv", "ppt", "hlp", "chm", "lit", "tex", "texi", "latex", "info", "man"});
    private static final MediaType TYPE_LINUX_OSX_PROGRAMS = new MediaType("application", "MEDIA_PROGRAMS", new String[]{"bin", "mdb", "sh", "csh", "awk", "pl", "rpm", "deb", "gz", "gzip", "z", "bz2", "zoo", "tar", "tgz", "taz", "shar", "hqx", "sit", "dmg", "7z", "jar", "zip", "nrg", "cue"});
    private static final MediaType TYPE_WINDOWS_PROGRAMS = new MediaType("application", "MEDIA_PROGRAMS", new String[]{"exe", "zip", "jar", "cab", "msi", "msp", "arj", "rar", "ace", "lzh", "lha", "bin", "nrg", "cue"});
    private static final MediaType TYPE_PROGRAMS = new MediaType("application", "MEDIA_PROGRAMS", MediaType.makeArray(MediaType.TYPE_LINUX_OSX_PROGRAMS.exts, MediaType.TYPE_WINDOWS_PROGRAMS.exts));
    private static final MediaType TYPE_AUDIO = new MediaType("audio", "MEDIA_AUDIO", new String[]{"mp3", "mpa", "mp1", "mpga", "ra", "rm", "ram", "rmj", "wma", "wav", "m4a", "m4p", "mp4", "lqt", "ogg", "med", "aif", "aiff", "aifc", "au", "snd", "s3m", "mid", "midi", "rmi", "mod"});
    private static final MediaType TYPE_VIDEO = new MediaType("video", "MEDIA_VIDEO", new String[]{"mpg", "mpeg", "mpe", "mng", "mpv", "m1v", "vob", "mp2", "mpv2", "mp2v", "m2p", "m2v", "vcd", "mp4", "dv", "dvd", "div", "divx", "dvx", "smi", "smil", "rm", "ram", "rv", "avi", "asf", "asx", "wmv", "qt", "mov", "fli", "flc", "flx", "wml", "vrml", "swf", "dcr", "jve", "nsv"});
    private static final MediaType TYPE_IMAGES = new MediaType("image", "MEDIA_IMAGES", new String[]{"gif", "png", "jpg", "jpeg", "jpe", "jif", "jiff", "jfif", "tif", "tiff", "iff", "lbm", "ilbm", "eps", "mac", "drw", "pct", "img", "bmp", "dib", "rle", "ico", "ani", "icl", "cur", "emf", "wmf", "pcx", "pcd", "tga", "pic", "fig", "psd", "wpg", "dcx", "cpt", "mic", "pbm", "pnm", "ppm", "xbm", "xpm", "xwd", "sgi", "fax", "rgb", "ras"});
    private static final MediaType[] ALL_MEDIA_TYPES = new MediaType[]{TYPE_ANY, TYPE_DOCUMENTS, TYPE_PROGRAMS, TYPE_AUDIO, TYPE_VIDEO, TYPE_IMAGES};
    private final String schema;
    private final String descriptionKey;
    private final Set exts;
    private final boolean isDefault;

    public MediaType(String schema) {
        this.schema = schema;
        this.descriptionKey = null;
        this.exts = Collections.EMPTY_SET;
        this.isDefault = false;
    }

    public MediaType(String schema, String descriptionKey, String[] extensions) {
        this.schema = schema;
        this.descriptionKey = descriptionKey;
        this.isDefault = true;
        if (extensions == null) {
            this.exts = Collections.EMPTY_SET;
        } else {
            TreeSet<String> set = new TreeSet<String>(Comparators.caseInsensitiveStringComparator());
            set.addAll(Arrays.asList(extensions));
            this.exts = set;
        }
    }

    public boolean matches(String filename) {
        if (this.exts == null) {
            return true;
        }
        int j = filename.lastIndexOf(".");
        if (j == -1 || j == filename.length()) {
            return false;
        }
        String suffix = filename.substring(j + 1);
        return this.exts.contains(suffix);
    }

    public String toString() {
        return this.schema;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public String getMimeType() {
        return this.schema;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public Set getExtensions() {
        return this.exts;
    }

    public static final MediaType[] getDefaultMediaTypes() {
        return ALL_MEDIA_TYPES;
    }

    public static MediaType getMediaTypeForSchema(String schema) {
        int i = ALL_MEDIA_TYPES.length;
        while (--i >= 0) {
            if (!schema.equals(MediaType.ALL_MEDIA_TYPES[i].schema)) continue;
            return ALL_MEDIA_TYPES[i];
        }
        return null;
    }

    public static MediaType getMediaTypeForExtension(String ext) {
        int i = ALL_MEDIA_TYPES.length;
        while (--i >= 0) {
            if (!MediaType.ALL_MEDIA_TYPES[i].exts.contains(ext)) continue;
            return ALL_MEDIA_TYPES[i];
        }
        return null;
    }

    public static boolean isDefaultType(String schema) {
        MediaType[] types = MediaType.getDefaultMediaTypes();
        int i = ALL_MEDIA_TYPES.length;
        while (--i >= 0) {
            if (!schema.equals(MediaType.ALL_MEDIA_TYPES[i].schema)) continue;
            return true;
        }
        return false;
    }

    public static MediaType getAnyTypeMediaType() {
        return TYPE_ANY;
    }

    public static MediaType getAudioMediaType() {
        return TYPE_AUDIO;
    }

    public static MediaType getVideoMediaType() {
        return TYPE_VIDEO;
    }

    public static MediaType getImageMediaType() {
        return TYPE_IMAGES;
    }

    public static MediaType getDocumentMediaType() {
        return TYPE_DOCUMENTS;
    }

    public static MediaType getProgramMediaType() {
        return TYPE_PROGRAMS;
    }

    public static Aggregator getAggregator(QueryRequest query) {
        if (query.desiresAll()) {
            return null;
        }
        Aggregator retAggr = new Aggregator();
        if (query.desiresLinuxOSXPrograms()) {
            retAggr.addFilter(MediaType.TYPE_LINUX_OSX_PROGRAMS);
        }
        if (query.desiresWindowsPrograms()) {
            retAggr.addFilter(MediaType.TYPE_WINDOWS_PROGRAMS);
        }
        if (query.desiresDocuments()) {
            retAggr.addFilter(MediaType.TYPE_DOCUMENTS);
        }
        if (query.desiresAudio()) {
            retAggr.addFilter(MediaType.TYPE_AUDIO);
        }
        if (query.desiresVideo()) {
            retAggr.addFilter(MediaType.TYPE_VIDEO);
        }
        if (query.desiresImages()) {
            retAggr.addFilter(MediaType.TYPE_IMAGES);
        }
        return retAggr;
    }

    private static String[] makeArray(Set one, Set two) {
        HashSet all = new HashSet(one);
        all.addAll(two);
        return all.toArray(new String[all.size()]);
    }

    public static class Aggregator {
        private List _filters = new LinkedList();

        private Aggregator() {
        }

        private void addFilter(MediaType filter) {
            this._filters.add(filter);
        }

        public boolean allow(String fName) {
            Iterator iter = this._filters.iterator();
            while (iter.hasNext()) {
                MediaType currType = (MediaType)iter.next();
                if (!currType.matches(fName)) continue;
                return true;
            }
            return false;
        }
    }
}

