/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushProxyInterface;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.IpPortImpl;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;

public class PushEndpoint
implements HTTPHeaderValue,
IpPort {
    public static final int HEADER_SIZE = 17;
    public static final int PROXY_SIZE = 6;
    public static final int PLAIN = 0;
    private static final int SIZE_MASK = 7;
    private static final int FWT_VERSION_MASK = 24;
    private static final int FEATURES_MASK = 224;
    private static final Map GUID_PROXY_MAP = Collections.synchronizedMap(new WeakHashMap());
    private final byte[] _clientGUID;
    private GUID _guid;
    private final int _features;
    private final int _fwtVersion;
    private Set _proxies;
    private final IpPort _externalAddr;

    public PushEndpoint(byte[] guid, Set proxies, int features, int version) {
        this(guid, proxies, features, version, null);
    }

    public PushEndpoint(byte[] guid, Set proxies, int features, int version, IpPort addr) {
        this._features = features & 0xE0 | version << 3;
        this._fwtVersion = version;
        this._clientGUID = guid;
        this._guid = new GUID(this._clientGUID);
        this._proxies = proxies != null ? proxies : new HashSet();
        this._externalAddr = addr;
    }

    public PushEndpoint(byte[] guid, Set proxies) {
        this(guid, proxies, 0, 0);
    }

    public PushEndpoint(byte[] guid) {
        this(guid, Collections.EMPTY_SET);
    }

    public PushEndpoint(String httpString) throws IOException {
        if (httpString.length() < 32 || httpString.indexOf(";") > 32) {
            throw new IOException("http string does not contain valid guid");
        }
        String guidS = httpString.substring(0, 32);
        httpString = httpString.substring(32);
        try {
            this._clientGUID = GUID.fromHexString(guidS);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException(iae.getMessage());
        }
        this._guid = new GUID(this._clientGUID);
        StringTokenizer tok = new StringTokenizer(httpString, ";");
        HashSet<PushProxyInterface> proxies = new HashSet<PushProxyInterface>();
        int fwtVersion = 0;
        IpPort addr = null;
        while (tok.hasMoreTokens() && proxies.size() < 4) {
            String current = tok.nextToken().trim();
            if (current.startsWith("fwt")) {
                fwtVersion = (int)HTTPUtils.parseFeatureToken(current);
                continue;
            }
            try {
                proxies.add(PushEndpoint.parseIpPort(current));
            }
            catch (IOException ohWell) {
                if (addr != null) continue;
                try {
                    addr = PushEndpoint.parsePortIp(current);
                }
                catch (IOException notBad) {}
            }
        }
        this._proxies = proxies;
        this._externalAddr = addr;
        this._fwtVersion = fwtVersion;
        this._features = proxies.size() | this._fwtVersion << 3;
    }

    public byte[] toBytes() {
        Set proxies = this.getProxies();
        int payloadSize = PushEndpoint.getSizeBytes(proxies);
        IpPort addr = this.getValidExternalAddress();
        if (addr != null && this.supportsFWTVersion() > 0) {
            payloadSize += 6;
        }
        byte[] ret = new byte[payloadSize];
        this.toBytes(ret, 0, proxies, addr);
        return ret;
    }

    public void toBytes(byte[] where, int offset) {
        this.toBytes(where, offset, this.getProxies(), this.getValidExternalAddress());
    }

    private void toBytes(byte[] where, int offset, Set proxies, IpPort address) {
        int neededSpace = PushEndpoint.getSizeBytes(proxies);
        int supportsFWT = this.supportsFWTVersion();
        if (address != null && supportsFWT > 0) {
            neededSpace += 6;
        }
        if (where.length - offset < neededSpace) {
            throw new IllegalArgumentException("target array too small");
        }
        where[offset] = (byte)(Math.min(4, proxies.size()) | this.getFeatures() | supportsFWT << 3);
        System.arraycopy(this._clientGUID, 0, where, ++offset, 16);
        offset += 16;
        if (address != null && supportsFWT > 0) {
            byte[] addr = address.getInetAddress().getAddress();
            int port = address.getPort();
            System.arraycopy(addr, 0, where, offset, 4);
            ByteOrder.short2leb((short)port, where, offset += 4);
            offset += 2;
        }
        Iterator iter = proxies.iterator();
        for (int i = 0; iter.hasNext() && i < 4; ++i) {
            PushProxyInterface ppi = (PushProxyInterface)iter.next();
            byte[] addr = ppi.getPushProxyAddress().getAddress();
            short port = (short)ppi.getPushProxyPort();
            System.arraycopy(addr, 0, where, offset, 4);
            ByteOrder.short2leb(port, where, offset += 4);
            offset += 2;
        }
    }

    protected IpPort getValidExternalAddress() {
        if (!NetworkUtils.isValidExternalIpPort(this._externalAddr)) {
            return null;
        }
        return this._externalAddr;
    }

    public static PushEndpoint fromBytes(byte[] data) throws BadPacketException {
        return PushEndpoint.fromBytes(data, 0);
    }

    public static PushEndpoint fromBytes(byte[] data, int offset) throws BadPacketException {
        byte[] tmp = new byte[6];
        byte[] guid = new byte[16];
        HashSet<QueryReply.PushProxyContainer> proxies = new HashSet<QueryReply.PushProxyContainer>();
        IpPortImpl addr = null;
        boolean hasAddr = false;
        int number = data[offset] & 7;
        int features = data[offset] & 0xE0;
        int version = (data[offset] & 0x18) >> 3;
        if (data.length - offset < 17 + number * 6) {
            throw new BadPacketException("not a valid PushEndpoint");
        }
        if (data.length - offset >= 17 + (number + 1) * 6 && version > 0) {
            hasAddr = true;
        }
        System.arraycopy(data, ++offset, guid, 0, 16);
        offset += 16;
        if (hasAddr) {
            String address = NetworkUtils.ip2string(data, offset);
            short port = ByteOrder.leb2short(data, offset += 4);
            offset += 2;
            try {
                addr = new IpPortImpl(address, port);
            }
            catch (UnknownHostException hmm) {
                throw new BadPacketException(hmm.getMessage());
            }
        }
        for (int i = 0; i < number; ++i) {
            System.arraycopy(data, offset, tmp, 0, 6);
            offset += 6;
            proxies.add(new QueryReply.PushProxyContainer(tmp));
        }
        PushEndpoint pe = new PushEndpoint(guid, proxies, features, version, addr);
        pe.updateProxies(true);
        return pe;
    }

    public byte[] getClientGUID() {
        return this._clientGUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getProxies() {
        PushEndpoint pushEndpoint = this;
        synchronized (pushEndpoint) {
            if (this._proxies != null) {
                return this._proxies;
            }
        }
        GuidSetWrapper current = (GuidSetWrapper)GUID_PROXY_MAP.get(this._guid);
        Assert.that(current != null);
        return current.getProxies();
    }

    public static int getSizeBytes(Set proxies) {
        return 17 + Math.min(proxies.size(), 4) * 6;
    }

    public int supportsFWTVersion() {
        GuidSetWrapper current = (GuidSetWrapper)GUID_PROXY_MAP.get(this._guid);
        int currentVersion = current == null ? this._fwtVersion : current.getFWTVersion();
        return currentVersion;
    }

    public static void setFWTVersionSupported(byte[] guid, int version) {
        GUID g = new GUID(guid);
        GuidSetWrapper current = (GuidSetWrapper)GUID_PROXY_MAP.get(g);
        if (current != null) {
            current.setFWTVersion(version);
        }
    }

    public int hashCode() {
        return this._guid.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof PushEndpoint)) {
            return false;
        }
        PushEndpoint o = (PushEndpoint)other;
        return this._guid.equals(o._guid);
    }

    public String toString() {
        String ret = "PE [FEATURES:" + this.getFeatures() + ", FWT Version:" + this.supportsFWTVersion() + ", GUID:" + this._guid + ", proxies:{ ";
        Iterator iter = this.getProxies().iterator();
        while (iter.hasNext()) {
            PushProxyInterface ppi = (PushProxyInterface)iter.next();
            ret = ret + ppi.getPushProxyAddress() + ":" + ppi.getPushProxyPort() + " ";
        }
        ret = ret + "}]";
        return ret;
    }

    public String httpStringValue() {
        StringBuffer httpString = new StringBuffer(this._guid.toHexString()).append(";");
        int fwtVersion = this.supportsFWTVersion();
        if (fwtVersion != 0) {
            httpString.append("fwt").append("/").append(fwtVersion).append(";");
            IpPort address = this.getValidExternalAddress();
            if (address != null) {
                String addr = this.getAddress();
                int port = this.getPort();
                if (!addr.equals("1.1.1.1") && NetworkUtils.isValidPort(port)) {
                    httpString.append(port).append(":").append(addr).append(";");
                }
            }
        }
        Iterator iter = this.getProxies().iterator();
        for (int proxiesWritten = 0; iter.hasNext() && proxiesWritten < 4; ++proxiesWritten) {
            PushProxyInterface cur = (PushProxyInterface)iter.next();
            httpString.append(NetworkUtils.ip2string(cur.getPushProxyAddress().getAddress()));
            httpString.append(":").append(cur.getPushProxyPort()).append(";");
        }
        httpString.deleteCharAt(httpString.length() - 1);
        return httpString.toString();
    }

    public int getFeatures() {
        GuidSetWrapper current = (GuidSetWrapper)GUID_PROXY_MAP.get(this._guid);
        int currentFeatures = current == null ? this._features : current.getFeatures();
        return currentFeatures & 0xE0;
    }

    public static void setFeatures(byte[] guid, int features) {
        GUID g = new GUID(guid);
        GuidSetWrapper current = (GuidSetWrapper)GUID_PROXY_MAP.get(g);
        if (current != null) {
            current.setFeatures(features);
        }
    }

    public String getAddress() {
        return this._externalAddr != null ? this._externalAddr.getAddress() : "1.1.1.1";
    }

    public InetAddress getInetAddress() {
        return this._externalAddr != null ? this._externalAddr.getInetAddress() : null;
    }

    public int getPort() {
        return this._externalAddr != null ? this._externalAddr.getPort() : 6346;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateProxies(boolean good) {
        GuidSetWrapper existing;
        GUID guidRef = null;
        Map map = GUID_PROXY_MAP;
        synchronized (map) {
            existing = (GuidSetWrapper)GUID_PROXY_MAP.get(this._guid);
            if (existing != null) {
                guidRef = existing.getGuid();
            }
            if (existing == null || guidRef == null) {
                existing = new GuidSetWrapper(this._guid, this._features, this._fwtVersion);
                if (good) {
                    existing.updateProxies(this._proxies, true);
                } else {
                    existing.updateProxies(Collections.EMPTY_SET, true);
                }
                GUID_PROXY_MAP.put(this._guid, existing);
                this._proxies = null;
                return;
            }
        }
        existing.updateProxies(this._proxies, good);
        this._guid = guidRef;
        this._proxies = null;
    }

    public static void overwriteProxies(byte[] guid, String httpString) throws IOException {
        HashSet<PushProxyInterface> newSet = new HashSet<PushProxyInterface>();
        StringTokenizer tok = new StringTokenizer(httpString, ",");
        while (tok.hasMoreTokens()) {
            String proxy = tok.nextToken().trim();
            try {
                newSet.add(PushEndpoint.parseIpPort(proxy));
            }
            catch (IOException ohWell) {}
        }
        PushEndpoint.overwriteProxies(guid, newSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void overwriteProxies(byte[] guid, Set newSet) {
        GUID g = new GUID(guid);
        Map map = GUID_PROXY_MAP;
        synchronized (map) {
            GuidSetWrapper wrapper = (GuidSetWrapper)GUID_PROXY_MAP.get(g);
            if (wrapper == null) {
                wrapper = new GuidSetWrapper(g);
                GUID_PROXY_MAP.put(g, wrapper);
            }
            wrapper.overwriteProxies(newSet);
        }
    }

    private static PushProxyInterface parseIpPort(String http) throws IOException {
        int separator = http.indexOf(":");
        if (separator == -1 || separator != http.lastIndexOf(":") || separator == http.length()) {
            throw new IOException();
        }
        String host = http.substring(0, separator);
        if (!NetworkUtils.isValidAddress(host) || NetworkUtils.isPrivateAddress(host)) {
            throw new IOException();
        }
        String portS = http.substring(separator + 1);
        try {
            int port = Integer.parseInt(portS);
            if (!NetworkUtils.isValidPort(port)) {
                throw new IOException();
            }
            QueryReply.PushProxyContainer ppc = new QueryReply.PushProxyContainer(host, port);
            return ppc;
        }
        catch (NumberFormatException notBad) {
            throw new IOException(notBad.getMessage());
        }
    }

    private static IpPort parsePortIp(String http) throws IOException {
        int separator = http.indexOf(":");
        if (separator == -1 || separator != http.lastIndexOf(":") || separator == http.length()) {
            throw new IOException();
        }
        String portS = http.substring(0, separator);
        int port = 0;
        try {
            port = Integer.parseInt(portS);
            if (!NetworkUtils.isValidPort(port)) {
                throw new IOException();
            }
        }
        catch (NumberFormatException failed) {
            throw new IOException(failed.getMessage());
        }
        String host = http.substring(separator + 1);
        if (!NetworkUtils.isValidAddress(host) || NetworkUtils.isPrivateAddress(host)) {
            throw new IOException();
        }
        return new IpPortImpl(host, port);
    }

    private static class GuidSetWrapper {
        private final WeakReference _guidRef;
        private Set _proxies;
        private int _features;
        private int _fwtVersion;

        GuidSetWrapper(GUID guid) {
            this(guid, 0, 0);
        }

        GuidSetWrapper(GUID guid, int features, int version) {
            this._guidRef = new WeakReference<GUID>(guid);
            this._features = features;
            this._fwtVersion = version;
        }

        synchronized void updateProxies(Set s, boolean add) {
            HashSet existing = new HashSet();
            if (this._proxies != null) {
                existing.addAll(this._proxies);
            }
            if (add) {
                existing.addAll(s);
            } else {
                existing.removeAll(s);
            }
            this.overwriteProxies(existing);
        }

        synchronized void overwriteProxies(Set s) {
            this._proxies = Collections.unmodifiableSet(s);
        }

        synchronized Set getProxies() {
            return this._proxies != null ? this._proxies : Collections.EMPTY_SET;
        }

        synchronized int getFeatures() {
            return this._features;
        }

        synchronized int getFWTVersion() {
            return this._fwtVersion;
        }

        synchronized void setFeatures(int features) {
            this._features = features;
        }

        synchronized void setFWTVersion(int version) {
            this._fwtVersion = version;
        }

        GUID getGuid() {
            return (GUID)this._guidRef.get();
        }
    }
}

