/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.statistics.UploadStat;
import com.limegroup.gnutella.udpconnect.UDPConnection;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PushManager {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$PushManager == null ? (class$com$limegroup$gnutella$PushManager = PushManager.class$("com.limegroup.gnutella.PushManager")) : class$com$limegroup$gnutella$PushManager);
    private static final int CONNECT_TIMEOUT = 10000;
    static /* synthetic */ Class class$com$limegroup$gnutella$PushManager;

    public void acceptPushUpload(final String host, final int port, final String guid, final boolean forceAllow, final boolean isFWTransfer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("acceptPushUp ip:" + host + " port:" + port + " FW:" + isFWTransfer);
        }
        if (host == null) {
            throw new NullPointerException("null host");
        }
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        if (guid == null) {
            throw new NullPointerException("null guid");
        }
        FileManager fm = RouterService.getFileManager();
        if (fm.getNumFiles() < 1 && fm.getNumIncompleteFiles() < 1) {
            return;
        }
        ManagedThread runner = new ManagedThread("PushUploadThread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void managedRun() {
                block23: {
                    Socket s = null;
                    s = isFWTransfer ? new UDPConnection(host, port) : Sockets.connect(host, port, 10000);
                    OutputStream ostream = s.getOutputStream();
                    String giv = "GIV 0:" + guid + "/file\n\n";
                    ostream.write(giv.getBytes());
                    ostream.flush();
                    s.setSoTimeout(30000);
                    String word = IOUtils.readWord(s.getInputStream(), 4);
                    if (isFWTransfer) {
                        UploadStat.FW_FW_SUCCESS.incrementStat();
                    }
                    if (word.equals("GET")) {
                        UploadStat.PUSHED_GET.incrementStat();
                        RouterService.getUploadManager().acceptUpload(HTTPRequestMethod.GET, s, forceAllow);
                    } else if (word.equals("HEAD")) {
                        UploadStat.PUSHED_HEAD.incrementStat();
                        RouterService.getUploadManager().acceptUpload(HTTPRequestMethod.HEAD, s, forceAllow);
                    } else {
                        UploadStat.PUSHED_UNKNOWN.incrementStat();
                        throw new IOException();
                    }
                    Object var6_6 = null;
                    if (s == null) break block23;
                    try {
                        s.getInputStream().close();
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    try {
                        s.getOutputStream().close();
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    try {
                        s.close();
                    }
                    catch (IOException ioe2) {}
                    break block23;
                    {
                        catch (IOException ioe) {
                            if (isFWTransfer) {
                                UploadStat.FW_FW_FAILURE.incrementStat();
                            }
                            UploadStat.PUSH_FAILED.incrementStat();
                            Object var6_7 = null;
                            if (s == null) break block23;
                            try {
                                s.getInputStream().close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                            try {
                                s.getOutputStream().close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                            try {
                                s.close();
                            }
                            catch (IOException ioe2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        if (s != null) {
                            try {
                                s.getInputStream().close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                            try {
                                s.getOutputStream().close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                            try {
                                s.close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
            }
        };
        runner.setDaemon(true);
        runner.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

