/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.util.StringUtils;
import java.io.File;
import java.io.Serializable;

public class ResumeDownloader
extends ManagedDownloader
implements Serializable {
    static final long serialVersionUID = -4535935715006098724L;
    private final File _incompleteFile;
    private final String _name;
    private final int _size;
    private final URN _hash;

    public ResumeDownloader(IncompleteFileManager incompleteFileManager, File incompleteFile, String name, int size) {
        super(new RemoteFileDesc[0], incompleteFileManager, null);
        if (incompleteFile == null) {
            throw new NullPointerException("null incompleteFile");
        }
        this._incompleteFile = incompleteFile;
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Bad name in ResumeDownloader");
        }
        this._name = name;
        this._size = size;
        this._hash = incompleteFileManager.getCompletedHash(incompleteFile);
    }

    public void initialize(DownloadManager manager, FileManager fileManager, ActivityCallback callback) {
        if (this._hash != null) {
            this.downloadSHA1 = this._hash;
        }
        this.initializeIncompleteFile(this._incompleteFile);
        super.initialize(manager, fileManager, callback);
    }

    public boolean conflicts(File incompleteFile) {
        return incompleteFile.equals(this._incompleteFile);
    }

    protected boolean allowAddition(RemoteFileDesc other) {
        return IncompleteFileManager.same(this._name, this._size, this.downloadSHA1, other.getFileName(), other.getSize(), other.getSHA1Urn());
    }

    public synchronized int getContentLength() {
        return this._size;
    }

    public synchronized String getFileName() {
        return this._name;
    }

    public synchronized boolean resume() {
        boolean ret = super.resume();
        if (ret) {
            this.deserializedFromDisk = false;
        }
        return ret;
    }

    protected boolean shouldSendRequeryImmediately(int numRequeries) {
        if (this.deserializedFromDisk) {
            return false;
        }
        if (numRequeries > 0) {
            return super.shouldSendRequeryImmediately(numRequeries);
        }
        return true;
    }

    protected boolean shouldInitAltLocs(boolean deserializedFromDisk) {
        return !deserializedFromDisk;
    }

    protected QueryRequest newRequery(int numRequeries) {
        String queryName = StringUtils.createQueryString(this.getFileName());
        if (this.downloadSHA1 != null) {
            return QueryRequest.createQuery(queryName);
        }
        return QueryRequest.createQuery(queryName);
    }
}

